set terminal epslatex monochrome
set pm3d
set xlabel 'Education'
set ylabel 'Income (K)'
set zlabel 'Prestige'
set xtics 8,2,14
set ytics 5,5,25
set ztics 0,20,100
unset colorbox
unset hidden3d
set view 42,61
set size 0.8,1.2

f(x,y)=b0+b1*x+b2*y
fit f(x,y) 'prestige.dat' using 1:2:3:(1) via b0,b1,b2

set output 'plot_ols_linear.eps'
splot  f(x,y) title "$\\hat y_i=x_i'\\hat\\beta$", 'prestige.dat' notitle w impulses, 'prestige.dat' notitle w points

set output 'plot_gam.eps'
splot  'gam_grid.dat' title '$\hat y_i=s(x_1)+s(x_2)$' w l, 'prestige.dat' notitle w impulses, 'prestige.dat' notitle w points


