/* Major bug in mat_free - memory not freed!!! (missing parentheses)
   Found 7/6/96, jracine */

/*
*-----------------------------------------------------------------------------
*	file:	matcreat.c
*	desc:	matrix mathematics - object creation
*	by:	ko shu pui, patrick
*	date:	24 nov 91 v0.1
*	revi:	14 may 92 v0.2
*		21 may 92 v0.3
*	ref:
*       [1] Mary L.Boas, "Mathematical Methods in the Physical Sciene,"
*	John Wiley & Sons, 2nd Ed., 1983. Chap 3.
*
*	[2] Kendall E.Atkinson, "An Introduction to Numerical Analysis,"
*	John Wiley & Sons, 1978.
*
*-----------------------------------------------------------------------------
*/
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>

#include "matrix.h"

MATRIX	_mat_creat( unsigned int row, unsigned int col )
{
	MATBODY	*mat;
	unsigned int	i;

	if ((mat = (MATBODY *)malloc( sizeof(MATHEAD) + sizeof(double *) * row)) == NULL) {
		return (mat_error( MAT_MALLOC ));
	}

  for (i=0; i<row; i++) {
    if ((*((double **)(&mat->matrix) + i) = (double *)malloc(sizeof(double) * col)) == NULL) {
      return (mat_error( MAT_MALLOC ));
    }
  }

	mat->head.row = row;
	mat->head.col = col;

	return (&(mat->matrix));
}

/*
*-----------------------------------------------------------------------------
*	funct:	mat_creat
*	desct:	create a matrix
*	given:  row, col = dimension, type = which kind of matrix
*	retrn:	allocated matrix (use mat_free() to free memory)
*-----------------------------------------------------------------------------
*/
MATRIX	mat_creat( unsigned int row, unsigned int col, int type )
{
	MATRIX	A;

	if ((A =_mat_creat( row, col )) != NULL) {
		return (mat_fill(A, type));
	}
	else {
		return (NULL);
	}
}

/*
*-----------------------------------------------------------------------------
*	funct:	mat_fill
*	desct:	form a special matrix
*	given:  A = matrix, type = which kind of matrix
*	retrn:	A
*-----------------------------------------------------------------------------
*/
MATRIX mat_fill( MATRIX A, int type )
{
	unsigned int	i, j;

	switch (type)
		{
		case UNDEFINED:
			break;
		case ZERO_MATRIX:
		case UNIT_MATRIX:
			for (i=0; i<MatRow(A); i++)
			for (j=0; j<MatCol(A); j++)
				{
				if (type == UNIT_MATRIX)
					{
					if (i==j)
						{
						A[i][j] = 1.0;
						continue;
						}
					}
				A[i][j] = 0.0;
				}
			break;
		}
	return (A);
}


/*
*-----------------------------------------------------------------------------
*	funct:	mat_free
*	desct:	free an allocated matrix
*	given:  A = matrix
*	retrn:	nothing <actually 0 = NULL A passed, 1 = normal exit>
*-----------------------------------------------------------------------------
*/
int mat_free( MATRIX A )
{
	unsigned int i;

	if (A == NULL) {
		fprintf(stderr,"\nAttempting to free a non-existent matrix in mat_free()\n");
		return (0);
	}

	for (i=0; i<MatRow(A); i++) {
		free(A[i]);
	}
	
	free(Mathead(A));

	return (1);
}

/*
*-----------------------------------------------------------------------------
*	funct:	mat_copy
*	desct:	duplicate a matrix
*	given:	A = matrice to duplicated
*	retrn:	C = A
*	comen:
*-----------------------------------------------------------------------------
*/
MATRIX mat_copy( MATRIX A, MATRIX C )
{
	unsigned int i, j;

	for (i=0; i<MatRow(A); i++)
	for (j=0; j<MatCol(A); j++)
		{
		C[i][j] = A[i][j];
		}
	return (C);
}


MATRIX mat_colcopy1( MATRIX A, MATRIX B, int cola, int colb )
{
	int	i, n;

	n = MatRow(A);
	for (i=0; i<n; i++)
		{
		A[i][cola] = B[i][colb];
		}
	return (A);
}

int fgetmat( MATRIX A, FILE *fp )
{
	unsigned int	i, j;
	int k=0;

	for (i=0; i<MatRow(A); i++)
	for (j=0; j<MatCol(A); j++)
		{

		k += fscanf( fp, "%lf", &A[i][j] );

		}

	return (k);
}
