/*
* Program for the feasible cross-validation algorithm
* by J. Racine, 1994. Last modified Dec 8 1994
*/

#include <stdio.h>
#include <malloc.h>
#include <stdlib.h>
#include <float.h>
#include <math.h>
#include <time.h>
#include "matrix.h"

/* Turning on debugging (DEBUG 1) will give printouts of data etc. */

#define DEBUG 0

/* Define either STAN_TIME for standard time, or MILLI_TIME for millisecond
   timer - only available on djgcc 2.6.0 or later on 286 or higher PC.
	 For a unix box, use STAN_TIME */

int main()
{
  MATRIX  X;
  MATRIX  XT;
  MATRIX  XTX;
  MATRIX  XTXINV;
  MATRIX  Y;
  MATRIX  XTY;
  MATRIX  IDENT;
  MATRIX  X_SUB;
  MATRIX  X_SUBT;
  MATRIX  Y_ROW;
  MATRIX  Y_SUB;
  MATRIX  X_ROW;

  MATRIX X_MIN_SUB;
  MATRIX Y_MIN_SUB;
  MATRIX X_MIN_SUBT;

  MATRIX  TMP_DATA; /* For reading data from one file, then parsing */

  /* Some temporary dummies which are reused */
  MATRIX MAT_DUM_11;
  MATRIX MAT_DUM_REGREG;
  MATRIX MAT_DUM_REGREG_A;
  MATRIX MAT_DUM_REGREG_B;
  MATRIX MAT_DUM_REGREG_C;
  MATRIX MAT_DUM_REG2H1;
  MATRIX MAT_DUM_2H1REG;
  MATRIX MAT_DUM_2H12H1;
  MATRIX MAT_DUM_REG1;
  MATRIX MAT_DUM_REG1_A;
  MATRIX MAT_DUM_REG1_B;

  FILE  *fp;
  time_t  t1, t2;
  unsigned long int tick_1, tick_2, elapsedtime, eff_time, sta_time;
  int i, j;

  int h;  /* Size of h-block */

  int num_ob;
  int num_reg;

  double cv_sta,tmp;

  /* Get data on number of observations, regressors, and h from files */

  if (!(fp = fopen( "h_block.dat", "r" )))
    {
    fprintf( stderr, "file `h_block.dat' cannot be opened\n" );
    exit (0);
    }

  fscanf(fp,"%d",&h);

  fclose(fp);

  if (!(fp = fopen( "num_obs.dat", "r" )))
    {
    fprintf( stderr, "file `num_obs.dat' cannot be opened\n" );
    exit (0);
    }

  fscanf(fp,"%d",&num_ob);

  fclose(fp);

  if (!(fp = fopen( "num_reg.dat", "r" )))
    {
    fprintf( stderr, "file `num_reg.dat' cannot be opened\n" );
    exit (0);
    }

  fscanf(fp,"%d",&num_reg);

  fclose(fp);

  if((num_reg <= 0) || (num_ob <=0) || (h < 0) || (h > (num_ob/2 - 1)))
    {
    fprintf( stderr, "Invalid number for observations, regressors, or h-block\n" );
    exit (0);
    }

/*  printf("Number of observations: %d\nNumber of regressors: %d\n",num_ob, num_reg);*/
/*  printf("Size of h-block: %d\nSize of removed block: %d\n\n", h, 2*h+1);*/

  /* Create all matrices */

  X = mat_creat( num_ob, num_reg, UNDEFINED );
  XT = mat_creat( num_reg, num_ob, UNDEFINED );
  XTX = mat_creat( num_reg, num_reg, UNDEFINED );
  XTXINV = mat_creat( num_reg, num_reg, UNDEFINED );
  Y = mat_creat( num_ob, 1, UNDEFINED );
  XTY = mat_creat( num_reg, 1, UNDEFINED );
  X_SUB = mat_creat( 2*h+1, num_reg, UNDEFINED);
  X_SUBT = mat_creat( num_reg, 2*h+1, UNDEFINED);
  X_ROW = mat_creat( 1, num_reg, UNDEFINED);
  Y_ROW = mat_creat( 1, 1, UNDEFINED);
  Y_SUB = mat_creat( 2*h+1, 1, UNDEFINED);
  IDENT = mat_creat( 2*h+1, 2*h+1, UNIT_MATRIX);

  /* Create extra temporary dummies */

  MAT_DUM_11 = mat_creat( 1, 1, UNDEFINED);
  MAT_DUM_REGREG = mat_creat( num_reg, num_reg, UNDEFINED);
  MAT_DUM_REGREG_A = mat_creat( num_reg, num_reg, UNDEFINED);
  MAT_DUM_REGREG_B = mat_creat( num_reg, num_reg, UNDEFINED);
  MAT_DUM_REGREG_C = mat_creat( num_reg, num_reg, UNDEFINED);
  MAT_DUM_REG2H1 = mat_creat( num_reg, 2*h+1, UNDEFINED);
  MAT_DUM_2H1REG = mat_creat( 2*h+1, num_reg, UNDEFINED);
  MAT_DUM_REG1 = mat_creat( num_reg, 1, UNDEFINED);
  MAT_DUM_REG1_A = mat_creat( num_reg, 1, UNDEFINED);
  MAT_DUM_REG1_B = mat_creat( num_reg, 1, UNDEFINED);
  MAT_DUM_2H12H1 = mat_creat( 2*h+1, 2*h+1, UNDEFINED);

  /* First order of business: read in the data and store in the
     matrices X and Y.  */

#ifdef STAN_TIME
    t1 = time(&t1);
#endif

  TMP_DATA = mat_creat( num_ob, num_reg+1, UNDEFINED );

  if (!(fp = fopen( "data.dat", "r" )))
    {
    fprintf( stderr, "file `data.dat' cannot be opened\n" );
    exit (0);
    }

  fgetmat(TMP_DATA, fp );

  fclose(fp);

  for(i=0;i<num_ob;i++) {
    Y[i][0]=TMP_DATA[i][0];
    for(j=0;j <num_reg; j++) {
      X[i][j]=TMP_DATA[i][j+1];
    }
  }

  mat_free(TMP_DATA); /* Simply temporary */

#ifdef STAN_TIME
    t2 = time(&t2);
    elapsedtime = t2 - t1;
#endif

  if(DEBUG){
    printf( "|- Matrix X -|\n");
    mat_dumpf( X, "%g " );
    printf( "|- Matrix Y -|\n");
    mat_dumpf( Y, "%g " );
  }

  /* Calculate necessary matrices which do not change with each iteration */

#ifdef STAN_TIME
    t1 = time(&t1);
#endif

  XT = mat_tran( X, XT );
  XTX = mat_mul( XT, X, XTX );
  XTXINV = mat_inv( XTX, XTXINV );
  XTY = mat_mul( XT, Y, XTY );

  if(DEBUG){
    printf( "|- Matrix XTX -|\n");
    mat_dumpf( XTX, "%g " );
    printf( "|- Matrix XTXINV -|\n");
    mat_dumpf( XTXINV, "%g " );
    printf( "|- Matrix XTY -|\n");
    mat_dumpf( XTY, "%g " );
    printf( "|- Matrix BETA -|\n");
    mat_dumpf( mat_mul(XTXINV,XTY,MAT_DUM_REG1), "%g " );
  }

#ifdef STAN_TIME
    t2 = time(&t2);
    elapsedtime = t2 - t1;
#endif

  /* We now calculate the cross-validation function */

#ifdef STAN_TIME
    t1 = time(&t1);
#endif

/*  printf("Calculating...");*/
/*  fflush(stdout);*/

  cv_sta = 0.0;

  X_MIN_SUB = mat_creat( num_ob - (2*h+1), num_reg, UNDEFINED);
  Y_MIN_SUB = mat_creat( num_ob - (2*h+1), 1, UNDEFINED);
  X_MIN_SUBT = mat_creat( num_reg, num_ob - (2*h+1), UNDEFINED);

  for(i=h;i < num_ob-h; i++) {

    if(DEBUG) printf("i=%d\n", i);

    X_ROW = mat_sub_mat ( X, i, i, X_ROW, 0, num_reg-1); /* Pointer only... */

    Y_ROW = mat_sub_mat ( Y, i, i, Y_ROW, 0, 0);
    Y_MIN_SUB = mat_sub_rem_mat( Y, i-h, i+h, Y_MIN_SUB);
    X_MIN_SUB = mat_sub_rem_mat( X, i-h, i+h, X_MIN_SUB);
    X_MIN_SUBT = mat_tran( X_MIN_SUB, X_MIN_SUBT ); /* Copy... */

    tmp = mat_sub(Y_ROW,
            mat_mul(X_ROW,
              mat_mul(
                  mat_inv(mat_mul(X_MIN_SUBT, X_MIN_SUB, MAT_DUM_REGREG_A),
                          MAT_DUM_REGREG_B),
                  mat_mul(X_MIN_SUBT,Y_MIN_SUB,MAT_DUM_REG1),
                  MAT_DUM_REG1_B)
            ,MAT_DUM_11)
          ,MAT_DUM_11)[0][0];

    if(DEBUG) printf("Finished computation %d\n", i);

    if(DEBUG) printf("%g\n", tmp*tmp);

    cv_sta += tmp*tmp;
  }

  mat_free( X_MIN_SUB );
  mat_free( Y_MIN_SUB );
  mat_free( X_MIN_SUBT );

  /* Observations for which  i < h */

  for(i=0, j=0;i < h; i++, j++) {

    if(DEBUG) printf("i=%d\n", i);

    X_ROW = mat_sub_mat ( X, i, i, X_ROW, 0, num_reg-1); /* Pointer only... */
    Y_ROW = mat_sub_mat ( Y, i, i, Y_ROW, 0, 0);

	  X_MIN_SUB = mat_creat( num_ob -(h+j+1), num_reg, UNDEFINED);
  	Y_MIN_SUB = mat_creat( num_ob -(h+j+1), 1, UNDEFINED);
	  X_MIN_SUBT = mat_creat( num_reg, num_ob -(h+j+1), UNDEFINED);
    
    Y_MIN_SUB = mat_sub_rem_mat( Y, i-j, i+h, Y_MIN_SUB);
    X_MIN_SUB = mat_sub_rem_mat( X, i-j, i+h, X_MIN_SUB);
    X_MIN_SUBT = mat_tran( X_MIN_SUB, X_MIN_SUBT ); /* Copy... */

    tmp = mat_sub(Y_ROW,
            mat_mul(X_ROW,
              mat_mul(
                  mat_inv(mat_mul(X_MIN_SUBT, X_MIN_SUB, MAT_DUM_REGREG_A),
                          MAT_DUM_REGREG_B),
                  mat_mul(X_MIN_SUBT,Y_MIN_SUB,MAT_DUM_REG1),
                  MAT_DUM_REG1_B)
            ,MAT_DUM_11)
          ,MAT_DUM_11)[0][0];

    if(DEBUG) printf("Finished computation %d\n", i);

    if(DEBUG) printf("%g\n", tmp*tmp);

	  mat_free( X_MIN_SUB );
  	mat_free( Y_MIN_SUB );
	  mat_free( X_MIN_SUBT );

    cv_sta += tmp*tmp;

  }

  /* Observations for which  i > n - h */

  for(i=num_ob-h, j=h-1;i < num_ob; i++, j--) {

    if(DEBUG) printf("i=%d\n", i);

    X_ROW = mat_sub_mat ( X, i, i, X_ROW, 0, num_reg-1); /* Pointer only... */
    Y_ROW = mat_sub_mat ( Y, i, i, Y_ROW, 0, 0);

	  X_MIN_SUB = mat_creat( num_ob -(h+j+1), num_reg, UNDEFINED);
  	Y_MIN_SUB = mat_creat( num_ob -(h+j+1), 1, UNDEFINED);
	  X_MIN_SUBT = mat_creat( num_reg, num_ob -(h+j+1), UNDEFINED);
    
    Y_MIN_SUB = mat_sub_rem_mat( Y, i-h, i+j, Y_MIN_SUB);
    X_MIN_SUB = mat_sub_rem_mat( X, i-h, i+j, X_MIN_SUB);
    X_MIN_SUBT = mat_tran( X_MIN_SUB, X_MIN_SUBT ); /* Copy... */

    tmp = mat_sub(Y_ROW,
            mat_mul(X_ROW,
              mat_mul(
                  mat_inv(mat_mul(X_MIN_SUBT, X_MIN_SUB, MAT_DUM_REGREG_A),
                          MAT_DUM_REGREG_B),
                  mat_mul(X_MIN_SUBT,Y_MIN_SUB,MAT_DUM_REG1),
                  MAT_DUM_REG1_B)
            ,MAT_DUM_11)
          ,MAT_DUM_11)[0][0];

    if(DEBUG) printf("Finished computation %d\n", i);

    if(DEBUG) printf("%g\n", tmp*tmp);

	  mat_free( X_MIN_SUB );
  	mat_free( Y_MIN_SUB );
	  mat_free( X_MIN_SUBT );

    cv_sta += tmp*tmp;

  }

#ifdef STAN_TIME
    t2 = time(&t2);
    sta_time = elapsedtime = t2 - t1;
    printf("\rStandard execution time: %ld seconds\n", elapsedtime);
#endif

  cv_sta /= (double) num_ob;

/*  printf("CV = %g\n\n", cv_sta);*/

  if (!(fp = fopen( "output.dat", "w" )))
    {
    fprintf( stderr, "file `time.dat' cannot be opened\n" );
    exit (0);
    }

  fprintf(fp,"%lf  %d  %d  %d\n", cv_sta, num_ob, num_reg, h);

  fclose(fp);

  /* Free all allocated matrices */

  mat_free( X );
  mat_free( XT );
  mat_free( XTX );
  mat_free( XTXINV );
  mat_free( Y );
  mat_free( XTY );
  mat_free( X_SUB );
  mat_free( X_SUBT );
  mat_free( X_ROW );
  mat_free( Y_ROW );
  mat_free( Y_SUB );
  mat_free( IDENT );

  mat_free( MAT_DUM_11 );
  mat_free( MAT_DUM_REGREG );
  mat_free( MAT_DUM_REGREG_A );
  mat_free( MAT_DUM_REGREG_B );
  mat_free( MAT_DUM_REGREG_C );
  mat_free( MAT_DUM_REG2H1 );
  mat_free( MAT_DUM_2H1REG );
  mat_free( MAT_DUM_2H12H1 );
  mat_free( MAT_DUM_REG1 );
  mat_free( MAT_DUM_REG1_A );
  mat_free( MAT_DUM_REG1_B );

/*  printf("\nProgram terminated normally.\n");*/

  return(0);

}
