import java.util.*;

class Deutschland_US_UI
	extends Institutions
	// Deutschland 1997
	// US unemployment insurance (TAXABLE!)
	{
		public Deutschland_US_UI(int L,int Lr,double q0,double R,double Scale,double phi)
		{
			super(L,Lr,q0,R,Scale);
			
			this.phi=phi;
			FamSize=new double[L+1];
			Children=new double[L+1];
			for (int i=0;i<L/24;i++) for (int j=1;j<=24;j++)
			{
				FamSize[i*24+j]=(fs[i]*(25-j)+fs[i+1]*(j-1))/24;
				Children[i*24+j]=(cn[i]*(25-j)+cn[i+1]*(j-1))/24;
				CM[i*24+j]=Math.exp(Math.log(FamSize[i*24+j])*phi);
			}
		}
		
		public void reset(double q0,double R,double Scale,double phi)
		{
			super.reset(q0,R,Scale);
			
			this.phi=phi;
			for (int i=0;i<60;i++) for (int j=0;j<24;j++)
				CM[i*24+j]=Math.exp(Math.log(FamSize[i*24+j])*phi);
		}
		
		private double Age(int j)
		{
			return 20+((double)j-1)/24;
		}
		
		public double Brutto(double y)
		{
			if (y>9753.25/2) return y-1556.975/2;
			if (y>7432.275/2) return (y-458.175/2)/1.134;
			return y/1.2085;
		}
		
		public double nextBenefit(double Match,double HK,double UI,int j)
		{
			//adjustment adj: convert $ into DM amounts in an appropriate manner;
			//uses APW ratio
			double adj=4861.0/2382.0;
			//actual Benefit
			return Math.max(adj*4524/24.0,Math.min(adj*15600/24.0,0.5*Brutto(Scale*Match*(q0+HK))));
		}
		
		public double nextPension(double Match,double HK,double Pension,double UI,int e,int j)
		{
			// 0<=Pension<=1.88718117
			if (j>=Lr) return Pension;
			double yL=0;
			if (e==1) yL=Brutto(Scale*Match*(q0+HK));
			else if (UI>=0) yL=Brutto(Match)*0.8;
			return (Pension*(j-1)+Math.min(yL /*"Brutto-EK"*/,8200/2)/(52143/24))/j;
		}
		
		public double nextUI(double Match,double HK,double UI,int e,int j,int en)
		{
			//adjustment adj: convert $ into DM amounts in an appropriate manner;
			//uses APW ratio
			double adj=4861.0/2382.0;
			// same as US, except adj:
			if (e==1)
			{
				if ((Brutto(Scale*Match*(q0+HK))>=3084*adj/24.0) && (UI<6)) UI+=0.5;
				if (en==0)
				{
					if (UI==6) return 6;
					return 0;
				}
				return UI;
			}
			if (en==0) return Math.max(UI-0.5,0);
			return 0;
		}
		
		private double ErtragsAnteil(int j)
		{
			double Age=(j-1)/24+20;
			if (Age<68) return (92-Age)/100;
			if (Age<81) return (91-Age)/100;
			if (Age<85) return (92-Age)/100;
			if (Age<87) return (93-Age)/100;
			if (Age<90) return (94-Age)/100;
			if (Age<92) return 0.05;
			if (Age<94) return 0.04;
			if (Age<97) return 0.03;
			return 0.02;
		}
		
		public double y(double Assets,double MatchOrBenefit,double HK,double Pension,double UI,int e,int j)
		{
			double Splitting=Math.min(2,FamSize[j]-Children[j]);
			double PL=1.0/24;
			
			double yL=((e==1) && (j<Lr))?Brutto(Scale*MatchOrBenefit*(q0+HK)):0,yK=Math.max(0,(r+0*0.0284)*Assets/(1+r)),yR=0;
			if (e==2) yL=Brutto(MatchOrBenefit); //zur Berechnung des NettoLohns
			
			//AL-Vers:
			if ((e==0) && (j<Lr) && (UI>0)) yL+=MatchOrBenefit;

			// SozVers.
			yL-=Math.min(yL,6150*12*PL)*0.0745+Math.min(yL,8200*12*PL)*0.134;
			
			//Rente
			if (j>=Lr) 
			{
				if (Pension<0.75) Pension=Math.min(1.5*Pension,0.75); //Rente nach Mindesteinkommen, 262, SGB 6
				yR=Pension*45*40.51*12*PL;
			}
			
			//Freibetraege
			double yS=0;
			yS=Math.max(0,yK-6100*Splitting*PL)+Math.max(yR*ErtragsAnteil(j)-200,0);
			if (Age(j)>=64) yS-=Math.max(0,Math.min(3720*Splitting*PL,0.4*(yR+yK)));
			yS+=Math.max(0,yL-2000*PL);
			yS=Math.max(0,yS-3456*Children[j]*Splitting);
			
			//Steuertarif
			yS/=PL*Splitting;
			double tax=0;
			if ((yS>=12096) && (yS<55728)) tax=86.63E-8*yS*yS+0.23813603*yS-2993.256041;
			else if ((yS>=55728) && (yS<120042)) tax=151.91E-8*yS*yS+0.165451253*yS-974.8733263;
			else if (yS>=120042) tax=0.53*yS-22842;
			double y=yL+yR-tax*1.055*Splitting*PL;
			
			if (e==2) return y;
						
			//Kindergeld
			if (Children[j]>0) y+=220*12*PL*Math.min(2,Children[j]);
			if (Children[j]>2) y+=300*12*PL*Math.min(1,Children[j]-2);
			if (Children[j]>3) y+=350*12*PL*(Children[j]-3);
			
			
			//Soz.Hilfe
			if (Assets<=((Age(j)<60)?2500:4500)+(Splitting-1)*1200+(FamSize[j]-1)*500) y=Math.max(y,534*12*PL*(1+0.8*(FamSize[j]-Children[j]-1)+0.65*Children[j]));
			
			return y;
		}
		
		public int MakePeriods(Period[] P,Grid MG)
		{
			//adjustment adj: convert $ into DM amounts in an appropriate manner;
			//uses APW ratio
			double adj=4861.0/2382.0;

			Grid ZG=new ZeroGrid();
			Grid AG=new CombinedGrid(new ELogGrid(43,0,-233352,12),new ELogGrid(78,0,2100168,100)); //-4*APW...36*APW
			Grid HG1=new CombinedGrid(new EvenGrid(7,0,1),new LogGrid(4,1,1.54,0)); //25 Perioden lang
			Grid HG2=new CombinedGrid(new EvenGrid(7,0,1),new LogGrid(6,1,2.05,0)); // die restlichen 20
			Grid BG=new EvenGrid(6,188.5*adj,650*adj);
			double[] P1={0,1,1.89};Grid PG1=new PLGrid(P1);
			double[] P2={0,0.75,1,1.3,1.89};Grid PG2=new PLGrid(P2);
			double[] P3={0,0.5,0.75,1,1.3,1.6,1.89};Grid PG3=new PLGrid(P3);
			Grid UG=new EvenGrid(4,0,6);
			
			Grid HG=HG1,PG=PG1,UeG=UG,UuG=UG;
			
			P[0]=P[L+1]=new Period(0,0,ZG,ZG,ZG,ZG,ZG,ZG,ZG);
			int cnt=0;
			int Basis=24;
			for (int i=1;i<Lr;i++) 
			{
				if (i==24*25+1) HG=HG2;
				if (i==24*15+1) PG=PG2;
				if (i==24*30+1) PG=PG3;
				if (i==Basis)
				{ 
					P[i]=new Period(1,0,AG,MG,HG,BG,PG,UeG,UuG);
					if (i<1056) Basis+=24;
					else if (i<1068) Basis+=4;
					else if (i<1076) Basis+=2;
					else Basis++;
				}
				else
					P[i]=new Period(1,Basis,AG,MG,HG,BG,PG,UeG,UuG);
				cnt+=P[i].Size;
			}
			for (int i=Lr;i<=L;i++)
			{
				P[i]=new Period(2,0,AG,ZG,ZG,ZG,PG3,ZG,ZG);
				cnt+=P[i].Size;
			} 
			return cnt;
		}
		
		double phi,FamSize[],Children[];
		double fs[]=
		{1.469477,1.460009,1.605168,1.638724,1.772256,1.875615,1.810568,1.966422,2.000291,2.07277,2.143389,2.232974,2.387896,2.608009,2.808831,2.89637,2.89637,3.011235,3.11275,3.113931,3.15002,3.021219,3.007174,2.941447,2.999769,2.918441,2.834677,2.828536,2.732589,2.718965,2.80877,2.66286,2.625944,2.538983,2.434001,2.412622,2.385218,2.3481,2.288275,2.18332,2.10425,2.057797,1.990315,1.963784,1.867851,1.791152,1.711168,1.692563,1.619055,1.619637,1.559044,1.544855,1.510234,1.497789,1.455722,1.397622,1.386305,1.380239,1.398441,1.332914,1.294709,1.269522,1.250426,1.193537,1.244331,1.21128,1.207547,1.197409,1.27427,1.272242,1.276638};
		double cn[]=
		{0.1361777,0.1650809,0.2066014,0.2190127,0.2930346,0.3248403,0.3035464,0.4360645,0.4773302,0.516277,0.5954615,0.6829938,0.8019977,0.9494416,1.084804,1.175856,1.199202,1.219951,1.302891,1.272042,1.277275,1.161281,1.070141,0.9528889,0.9065176,0.7995372,0.6956645,0.6073926,0.5349463,0.4847855,0.4695864,0.3561606,0.3150203,0.2539642,0.192064,0.1624788,0.1250561,0.1104801,0.0895124,0.0658358,0.069252,0.0757035,0.0298257,0.0347224,0.0276274,0.0237833,0.0102839,0.0076741,0.0093706,0.0124521,0.0086449,0.0197351,0.0139889,0.0137782,0.0110017,0.0087281,0.0117513,0.0051705,0.0384093,0.0043711,0.0043595,0.0031116,0.0091908,0.0068407,0.0044978,0.0116574,0,0,0,0,0}; 
		
	}

class US_Ger_UI
	extends Institutions
	// USA 1997, with German UI system (benefits NOT taxable, AH)
	{
		public US_Ger_UI(int L,int Lr,double q0,double R,double Scale,double phi)
		{
			super(L,Lr,q0,R,Scale);
			
			this.phi=phi;
			FamSize=new double[L+1];
			Children=new double[L+1];
			for (int i=0;i<L/24;i++) for (int j=1;j<=24;j++)
			{
				FamSize[i*24+j]=(fs[i]*(25-j)+fs[i+1]*(j-1))/24;
				Children[i*24+j]=(cn[i]*(25-j)+cn[i+1]*(j-1))/24;
				CM[i*24+j]=Math.exp(Math.log(FamSize[i*24+j])*phi);
			}
		}
		
		public void reset(double q0,double R,double Scale,double phi)
		{
			super.reset(q0,R,Scale);
			
			this.phi=phi;
			for (int i=0;i<60;i++) for (int j=0;j<24;j++)
				CM[i*24+j]=Math.exp(Math.log(FamSize[i*24+j])*phi);
		}
		
		private double Age(int j)
		{
			return 20+((double)j-1)/24;
		}
		
		public double nextBenefit(double Match,double HK,double UI,int j)
		{
			//adjustment adj: convert $ into DM amounts in an appropriate manner;
			//uses APW ratio
			double adj=2382.0/4861.0;
			// max. 8200 DM/Monat als Benefit-Basis
			// Benefit speichert EK bis Obergrenze
			return Math.min(Scale*Match*(q0+HK),adj*(8200+1556.975)/2);
		}
		
		public double nextPension(double Match,double HK,double Pension,double UI,int e,int j)
		{
			if (j>45*24) return Pension;
			// AIME (=2x Period pension of Single)
			double Pj=2*((e==1)?Math.min(Brutto(Scale*Match*(q0+HK)),65400/24.0):0);
			if (j<=35*24) return (Pension*(j-1)+Pj)/j;
			if (Pj>Pension) return (Pension*(35*24)+Pj)/(35*24+1);
			return Pension;
		}
		
		public double Brutto(double y)
		{
			if (y>70877.1/24.0) return (y-4528.8/24.0)/1.0145;
			if (y>10700.74/24.0) return (y-474/24.0)/1.0765;
			if (y>7899.5/24.0) return (y-56/24.0)/1.1205;
			return y/1.1285;
		}
		
		public double nextUI(double Match,double HK,double UI,int e,int j,int en)
		{
			// UI (e==1): Anzahl der vor t bereits gearbeiteten Perioden
			// Achtung: guenstigere die Altersgrenzen bis April 97; Ab Mai 97 alles +3 Jahre
			if (e==1)
			{
				UI+=0.5;
				if ((Age(j)<44-3) && (UI>24)) UI=24;
				else if ((Age(j)<46.34-3) && (UI>36)) UI=36;
				else if ((Age(j)<51.34-3) && (UI>44)) UI=44;
				else if ((Age(j)<56-3) && (UI>52)) UI=52;
				else if (UI>64) UI=64;
				if (en==1) return UI;
				if (UI<12) return 0;
				UI=Math.floor(UI/2);
				if (Age(j)<45-3) UI=Math.min(UI,12);
				else if (Age(j)<47-3) UI=Math.min(UI,18);
				else if (Age(j)<52-3) UI=Math.min(UI,22);
				else if (Age(j)<57-3) UI=Math.min(UI,26);
				return UI;
			}
			if (en==1) return 0;
			if (UI>0) return UI-0.5;
			return UI;
		}
		
		public double firstUI() {return 0;}
		
		public double y(double Assets,double MatchOrBenefit,double HK,double Pension,double UI,int e,int j)
		{
			//no local tax
			double Spouse=Math.min(FamSize[j]-Children[j]-1,1);	
			
			double yL=((e==1) && (j<Lr))?Brutto(Scale*MatchOrBenefit*(q0+HK)):0,yK=Math.max(0,(r+0*0.031)*Assets/(1+r)),yU=0,yS=0,SS=0;
			if (e==2) yL=Brutto(MatchOrBenefit); //zur Berechnung des NettoLohns
			double AGI=0,FItax=0,Stax=0,taxableSS=0,EITC=0;
			double FItaxable=0,Staxable=0;
			double SSI=0,food=0;
			
			//Payroll tax
			SS=0.062*Math.min(yL,65400/24.0)+0.0145*yL;
			
			if (j>=Lr)
			{
				//soc.sec.
				yS=0.9*Math.min(455,Pension);
				yS+=0.32*Math.max(0,Math.min(2286,Pension-455));
				yS+=0.15*Math.max(0,Pension-2741);
				yS*=0.5*(1+0.5*Spouse);
				
				//SSI
				if (Assets<(2000+1000*Spouse))
					SSI=Math.max(0,(484+Spouse*242)/2.0-Math.max(0,yS+yK-10));
			}

			//Fed Inc. Tax
			//and Michigan State tax
			AGI=yL+yK+yU;
			Staxable=AGI-FamSize[j]*2500/24.0;
			if ((yS>0) && (yS/2+AGI>(25000+Spouse*7000)/24.0))
				taxableSS=Math.min(0.85*yS,Math.max(yS/2+AGI-(34000+10000*Spouse)/24.0,0)*0.85+Math.min(yS/2,Math.min((9000+3000)/24.0,0.5*Math.max(yS/2+AGI-(25000+Spouse*7000)/24.0,0)) ));
			AGI+=taxableSS;
			FItaxable=AGI-(4150+2750*Spouse)/24.0;
			if (j>24*45)
			{
				FItaxable-=(1000+600*Spouse)/24.0;
				Staxable-=900*(1+Spouse)/24.0;
			}
			FItaxable-=2650*FamSize[j]/24.0*Math.max(0,1-Math.max(0,AGI*24-121200-Spouse*60600)/125000.0);
			if (FItaxable>0)
			{
				double TT=(24650+Spouse*16550)/24.0;
				FItax=0.15*Math.min(TT,FItaxable);FItaxable-=TT;
				if (FItaxable>0)
				{
					TT=(35100+Spouse*23300)/24.0;FItax+=0.28*Math.min(TT,FItaxable);FItaxable-=TT;
					if (FItaxable>0)
					{
						TT=(64900-Spouse*12750)/24.0;FItax+=0.31*Math.min(TT,FItaxable);FItaxable-=TT;
						if (FItaxable>0)
						{
							TT=(146400-Spouse*27100)/24.0;FItax+=0.36*Math.min(TT,FItaxable);FItaxable-=TT;
							if (FItaxable>0) FItax+=0.396*FItaxable;
						}
					} 
				}
			} 
			if (yU>0) if (AGI<=2*yU) Staxable-=900/24.0;
			Stax=0.044*Math.max(0,Staxable);
			
			//EITC
			if ((yK<2250/24.0) && (yL>0))
			{
				double EIC0,EIC1,EIC2;
				if ((j<=5*24) || (j>45*24)) EIC0=0;
				else EIC0=Math.min(332/24.0,0.0765*AGI)-Math.max(0,Math.min((AGI-5450/24.0)*0.0765,332/24.0));
				EIC1=Math.min(2210/24.0,0.34*AGI)-Math.max(0,Math.min((AGI-11950/24.0)*0.16,2210/24.0));
				EIC2=Math.min(3656/24.0,0.4*AGI)-Math.max(0,Math.min((AGI-11950/24.0)*0.2108,3656/24.0));
				if (Children[j]<=1) EITC=EIC0*(1-Children[j])+EIC1*Children[j];
				else if (Children[j]>1) EITC=EIC1*(1-Math.min(Children[j]-1,1))+EIC2*Math.min(Children[j]-1,1);
			}
			
			//Food stamps (exactly correct for up to 3 persons, ok if <4)
			if ((Assets<2000) || ((Assets<3000) && (j>40*24)))
			{
				double basic,counted;
				basic=yL+yK+yU+yS-FItax-Stax-SS;
				counted=Math.max(basic-0.2*yL-134/2.0-177/2.0*Children[j],0);
				if ((FamSize[j]<2) && (basic<(893+283*(FamSize[j]-1))/2.0) && (counted<(671+234*(FamSize[j]-1))/2.0)) food=Math.max(0,125/2.0-0.3*counted);
				else if ((FamSize[j]*0<3) && (basic<(1176+303*(FamSize[j]-2))/2.0) && (counted<(905+233*(FamSize[j]-2))/2.0)) food=Math.max(0,230/2.0-0.3*counted);
			}   
			
			double y=yL+yU+yS+food-SS-FItax-Stax+EITC+SSI;

			//unemp. ins.
			if ((e==0) && (j<Lr))
			{
				//adjustment adj: convert $ into DM amounts in an appropriate manner;
				//uses APW ratio
				double adj=2382.0/4861.0;
				double Splitting=Math.min(2,FamSize[j]-Children[j]);
				
				if (UI>0) y+=y(0,MatchOrBenefit,0,0,0,2,j)*(0.6+0.07*Math.min(1,Children[j]));
				//AL-Hilfe nur falls Assets<Schonvermoegen; Abzug von Kap-EK
				else if ((UI==0) && (Assets<=Math.floor(Age(j))*Splitting*1000*adj)) y=Math.max(y(0,MatchOrBenefit,0,0,0,2,j)*(0.53+0.04*Math.min(1,Children[j])),y);
			}
			
			return y;
		}
		
		public int MakePeriods(Period[] P,Grid MG)
		{
			//adjustment adj: convert $ into DM amounts in an appropriate manner;
			//uses APW ratio
			double adj=2382.0/4861.0;

			Grid ZG=new ZeroGrid();
			Grid AG=new CombinedGrid(new ELogGrid(43,0,-114336,12),new ELogGrid(78,0,1029024,100)); //-4*APW...36*APW
			Grid HG1=new CombinedGrid(new EvenGrid(7,0,1),new LogGrid(5,1,1.85,0)); //23 Perioden lang
			Grid HG2=new CombinedGrid(new EvenGrid(7,0,1),new LogGrid(9,1,3.32,0)); // die restlichen 22
			Grid BG=new EvenGrid(10,0,4878.5*adj);
			Grid PG1=new EvenGrid(3,0,5450);
			Grid PG2=new EvenGrid(5,0,5450);
			Grid PG3=new EvenGrid(9,0,5450);
			double[] Ue1={0,3.5,7.5,11.5,17.5,23.5};Grid UeG1=new PLGrid(Ue1); 
			double[] Ue2={0,3.5,7.5,11.5,17.5,23.5,35.5};Grid UeG2=new PLGrid(Ue2); 
			double[] Ue3={0,3.5,7.5,11.5,17.5,23.5,35.5,43.5};Grid UeG3=new PLGrid(Ue3); 
			double[] Ue4={0,3.5,7.5,11.5,17.5,23.5,35.5,51.5};Grid UeG4=new PLGrid(Ue4); 
			double[] Ue5={0,3.5,7.5,11.5,17.5,23.5,35.5,51.5,63.5};Grid UeG5=new PLGrid(Ue5);
			double[] Ue6={0,3.5,7.5,11.5,17.5,23.5};Grid UeG6=new PLGrid(Ue6); // ab hier fuer's letzte Jahr
			double[] Ue7={0,3.5,7.5,11.5};Grid UeG7=new PLGrid(Ue7);
			double[] Ue8={0,3.5};Grid UeG8=new PLGrid(Ue8);
			double[] Uu1={-1,0,2,4,6,9,12};Grid UuG1=new PLGrid(Uu1);
			double[] Uu2={0,2,4,6,9,12,18};Grid UuG2=new PLGrid(Uu2);
			double[] Uu3={0,2,4,6,9,12,18,22};Grid UuG3=new PLGrid(Uu3);
			double[] Uu4={0,2,4,6,9,12,18,26};Grid UuG4=new PLGrid(Uu4);
			double[] Uu5={0,2,4,6,9,12,18,26,32};Grid UuG5=new PLGrid(Uu5);
			double[] Uu6={0,2,4,6,9,12};Grid UuG6=new PLGrid(Uu6);
			double[] Uu7={0,2,4,6};Grid UuG7=new PLGrid(Uu7);
			double[] Uu8={0,2};Grid UuG8=new PLGrid(Uu8);
			
			Grid HG=HG1,PG=PG1,UeG=UeG1,UuG=UuG1;
			
			int cnt=0;
			int Basis=24;
			P[0]=P[L+1]=new Period(0,0,ZG,ZG,ZG,ZG,ZG,ZG,ZG);
			for (int i=1;i<Lr;i++) 
			{
				if (i==24*23+1) HG=HG2;
				if (i==24*15+1) PG=PG2;
				if (i==24*30+1) PG=PG3;
				if (i==24*22+1) {UeG=UeG2;UuG=UuG2;}
				if (i==24*24+1) {UeG=UeG3;UuG=UuG3;}
				if (i==24*29+1) {UeG=UeG4;UuG=UuG4;}
				if (i==24*34+1) {UeG=UeG5;UuG=UuG5;}
				if (i==24*42+21) {UeG=UeG4;UuG=UuG4;}
				if (i==24*43+5) {UeG=UeG3;UuG=UuG3;}
				if (i==24*43+13) {UeG=UeG2;UuG=UuG2;}
				if (i==24*44+1) {UeG=UeG6;UuG=UuG6;}
				if (i==24*44+13) {UeG=UeG7;UuG=UuG7;}
				if (i==24*44+21) {UeG=UeG8;UuG=UuG8;}
				if (i==Basis) 
				{	
					P[i]=new Period(1,0,AG,MG,HG,BG,PG,UeG,UuG);
					if (i<1056) Basis+=24;
					else if (i<1068) Basis+=4;
					else if (i<1076) Basis+=2;
					else Basis++;
				}
				else 
					P[i]=new Period(1,Basis,AG,MG,HG,BG,PG,UeG,UuG);
				cnt+=P[i].Size;
			}
			for (int i=Lr;i<=L;i++)
			{
				P[i]=new Period(2,0,AG,ZG,ZG,ZG,PG,ZG,ZG);
				cnt+=P[i].Size;
			}
			return cnt;
		}
		
		double phi,FamSize[],Children[];
		double fs[]=
		{1.875342,1.948713,1.82825,1.799823,1.904865,1.955105,2.080133,2.085318,2.238999,2.328083,2.44759,2.521041,2.726534,2.806953,2.989861,3.076663,3.07061,3.179005,3.109714,2.994171,3.024195,3.000719,2.941247,2.910616,2.960295,2.860008,2.869957,2.833571,2.711429,2.598353,2.550589,2.437344,2.383241,2.327384,2.236204,2.133012,2.144219,2.126836,2.12439,2.123333,2.116677,2.072742,1.995117,1.976793,1.940439,1.949167,1.878473,1.868272,1.901043,1.847554,1.794773,1.75487,1.776353,1.736906,1.762271,1.687131,1.630891,1.587733,1.569849,1.503675,1.465886,1.500762,1.475022,1.402472,1.39519,1.295989,1.294879,1.311057,1.352917,1.209096,1.415462};
		double cn[]=
		{0.470242,0.517566,0.447822,0.4330432,0.481953,0.5147713,0.595273,0.6158588,0.7225585,0.8305319,0.9349168,0.9685141,1.154981,1.221325,1.342863,1.393512,1.387165,1.461266,1.393254,1.271097,1.263912,1.226633,1.140716,1.044452,1.01211,0.9018111,0.8495852,0.7459612,0.6380427,0.5398549,0.4597526,0.3885322,0.3274153,0.2894415,0.2081096,0.1763081,0.1728856,0.1381417,0.1517108,0.1010706,0.1018906,0.1006871,0.0715019,0.0622521,0.0776425,0.070011,0.0816301,0.06214,0.0713894,0.0498848,0.0444782,0.0443683,0.0494928,0.0436891,0.0515947,0.0335454,0.0308722,0.0124626,0.0251226,0.0152833,0.0107336,0.0187258,0.0189497,0.0151641,0.0147921,0.0064061,0.0160397,0.0139362,0.0129067,0,0.0635865}; 
		
	}

