import java.util.*;
import java.io.*;

class GoKnecht
extends Thread
{
 public void run()
 {
  int L=1440,Lr=1081;
     
  //DE
	 ModelParameters Params=new ModelParameters(
												0,			//q0	0 +++
												0.00066160831,	//de	1 ***
												0.00414158806878509,		//du	2
												0.147852653740288,		//df	3
												0.001699470693,	//jd	4 ***
												3.94348348093399,		//jc	5
												0.182619902664711,		//jv	6 (SE of JobOffers)
												1.00136259593,	//R	7 ***
												0.994765604937502,	//beta	8
												3.0,		//gamma	9
												1975.43905900784);		//Scale 10
	 
  int [] Stat=
  { 24,		//Periods p.a.
    0,		//1st relevant year (starting at 0)
    45,		//1st irrelevant year
    1,		//aggregation length
    0,		//yL "Brutto"
    5,		//wksu
    10,		//assets
    15,		//delta log c
    20,		//P(wksu=0)
    25,		//P(wksu(t-1)=i)
    0,0,0,0};

   double[] Init=
   { 1,
     4861,   //=APW/12
     1};

  int Anz=50000;
  double S[];

  Institutions Inst=new Deutschland(L,Lr,Params.P[0],Params.P[7],Params.P[10],0.4684816);
  LifeCycle LC=new LifeCycle(L,Lr,Params,Inst);

  long TS; {Date D=new Date();TS=D.getTime();}

  {
   System.out.println("computing:");
   for (int i=0;i<11;i++) System.out.println("    "+Params.P[i]);
   
   {Date D=new Date();System.out.println("     ["+(D.getTime()-TS)+"]");}
   LC.reset(Params);
   LC.optimise();
   {Date D=new Date();System.out.println("     ["+(D.getTime()-TS)+"]");}
   S=Statistics.get2(LC,24,Anz,Init[0],Init[1],Init[2]);
   {Date D=new Date();System.out.println("     ["+(D.getTime()-TS)+"]");}

   System.out.println("    -> done!");
  }

  System.out.println("Stats.csv");

  try
  {
   BufferedWriter f=new BufferedWriter(new FileWriter("Stats.csv"));
   f.write("\"Age\",\"Assets\",,\"Cons\",,\"HK\",,\"approx. gross lab. inc.\",,\"net income\",,\"u\",\"u>6\",\"u>12\"\n");
   for (int i=0;i<60;i++)
   {
    f.write((i+1)+",");
    f.write((S[13*i]/24/Anz)+","+(-(S[13*i+1]-S[13*i]*S[13*i])/24/Anz/24/Anz)+",");
    f.write((S[13*i+2]/Anz)+","+(-(S[13*i+3]-S[13*i+2]*S[13*i+2])/Anz/Anz)+",");
    f.write((S[13*i+4]/24/Anz)+","+(-(S[13*i+5]-S[13*i+4]*S[13*i+4])/24/Anz/24/Anz)+",");
    f.write((LC.Inst.Brutto(LC.Inst.Scale*S[13*i+6])/Anz)+","+(-(S[13*i+7]-LC.Inst.Brutto(LC.Inst.Scale*S[13*i+6])*LC.Inst.Brutto(LC.Inst.Scale*S[13*i+6]))/Anz/Anz)+",");
    f.write((S[13*i+8]/Anz)+","+(-(S[13*i+9]-S[13*i+8]*S[13*i+8])/Anz/Anz)+",");
    f.write((S[13*i+10]/24/Anz)+","+(S[13*i+11]/24.0/Anz)+","+(S[13*i+12]/24.0/Anz)+"\n");
   }
   f.close();
  } catch (Exception e) {System.out.println("Fehler! "+e.toString());}
  
  System.out.println("Reserve");

  try
  {
   JobOffer J=new JobOffer(LC.jc,LC.jv,10000);
   BufferedWriter f=new BufferedWriter(new FileWriter("ReserveW.csv"));
   BufferedWriter g=new BufferedWriter(new FileWriter("Hazard.csv"));
   BufferedWriter hh=new BufferedWriter(new FileWriter("A.csv"));
   BufferedWriter ii=new BufferedWriter(new FileWriter("H.csv"));
   BufferedWriter jj=new BufferedWriter(new FileWriter("U.csv"));
   BufferedWriter kk=new BufferedWriter(new FileWriter("P.csv"));
   BufferedWriter ll=new BufferedWriter(new FileWriter("M_res.csv"));
   for (int i=0;i<45;i++)
   {
    double A=S[i*13]/24/Anz,H=S[i*13+4]/24/Anz,U=12+24,P=1.4,M=Inst.nextBenefit(S[i*13+6]/(Anz*24-S[i*13+10])/H,H,64,i*24+1);
    if (i>=25) U=18+24;
    if (i>=27) U=22+24;
    if (i>=32) U=26+24;
    if (i>=37) U=32+24;
    H*=(1-LC.df);
    double Pn,Un,An;
    System.out.println((i+20)+": "+A+","+H+","+M+","+U+","+P);

    f.write(Double.toString(i+1));
    g.write(Double.toString(i+1));
    hh.write(Double.toString(i+1));
    ii.write(Double.toString(i+1));
    jj.write(Double.toString(i+1));
    kk.write(Double.toString(i+1));
    ll.write(Double.toString(i+1));
    for (int j=0;j<24*4;j++)
    {
     Random R=new Random(1234);
     double min=LC.Periods[1].MatchGrid.Values[0],max=LC.Periods[1].MatchGrid.Values[LC.Periods[1].MatchGrid.numPoints-1],mid;
     for (int k=0;k<15;k++)
     {
      mid=(min+max)/2;
      if (LC.Accept(i*24+1+j,A,M,H,P,U,mid)) max=mid;else min=mid;
     }
     mid=(min+max)/2;
     f.write(","+(mid*(H+Params.P[0])*Params.P[10]));
     ll.write(","+mid);
     
     int Cnt=0;
     
     for (int k=0;k<10000;k++) if (J.getOffer(R)>=mid) Cnt++;
     g.write(","+(Cnt/10000.0));
     
     hh.write(","+A);
     ii.write(","+H);
     jj.write(","+U);
     kk.write(","+P);

     Pn=LC.Inst.nextPension(M,H,P,U,0,i*24+1+j);
     Un=LC.Inst.nextUI(M,H,U,0,i*24+1+j,0);
     An=LC.Asset(i*24+1+j,A,M,H,P,U,0);
     P=Pn;A=An;U=Un;
     H*=(1-LC.du);
    }
    f.write("\n");
    g.write("\n");
    hh.write("\n");
    ii.write("\n");
    jj.write("\n");
    kk.write("\n");
    ll.write("\n");
   }
   f.close();
   g.close();
   hh.close();
   ii.close();
   jj.close();
   kk.close();
   ll.close();
  } catch (Exception e) {System.out.println("Fehler! "+e.toString());}

  System.out.println("\nfertig.");
 }
}

public class Analyse
{
 public static void main(String[] args)
 {
  GoKnecht t=new GoKnecht();
  t.start();
 }
}