import java.util.*;
import java.io.*;

class Population
{
 Population(int Anz,int Lr)
 {
  A=new float[Anz*(Lr-1)];
  H=new float[Anz*(Lr-1)];
  M=new float[Anz*(Lr-1)];
  Rest=new int[Anz*(Lr-1)];
 }
 
 int e(int i) {return Rest[i]&1;}
 int j(int i) {return (Rest[i]>>1)&2047;}
 double U(int i) {return 0.5*(double)((Rest[i]>>12)&255);}
 double P(int i) {return 1.89*(double)((Rest[i]>>20)&4095)/4095.0;}
  
 void pack(int i,int e,int j,double U,double P) 
 {
  Rest[i]=e | (j<<1) | ((int)Math.round(2*U)<<12) | ((int)Math.round(P*4095.0/1.89)<<20);
 }
  
 float A[],H[],M[];
 int   Rest[];
}

class GoKnecht
extends Thread
{
 public void run()
 {
  int L=1440,Lr=1081;
     
  //DE
  ModelParameters Params=new ModelParameters(
     0,			//q0	0 +++
     0.00066160831,	//de	1 ***
     0.0039781724068301515,		//du	2
     0.20808838658310685,		//df	3
     0.001699470693,	//jd	4 ***
     11.685107718716456,		//jc	5
     0.11244822087962521,		//jv	6 (SE of JobOffers)
     1.00136259593,	//R	7 ***
     0.9946920468021678,	//beta	8
     3.0,		//gamma	9
     1980.868656886189);		//Scale 10

  int [] Stat=
  { 24,		//Periods p.a.
    0,		//1st relevant year (starting at 0)
    45,		//1st irrelevant year
    1,		//aggregation length
    0,		//yL "Brutto"
    5,		//wksu
    10,		//assets
    15,		//delta log c
    20,		//P(wksu=0)
    25,		//P(wksu(t-1)=i)
    0,0,0,0};

   double[] Init=
   { 1,
     4861,   //=APW/12
     1};

  int Anz=20000;
  double S[];

  Institutions Inst=new Deutschland(L,Lr,Params.P[0],Params.P[7],Params.P[10],0.4684816);
  LifeCycle LC=new LifeCycle(L,Lr,Params,Inst);

  Population Pop=new Population(Anz,Lr);

  long TS; {Date D=new Date();TS=D.getTime();}

  System.out.println("*** 1997 ***");
  {
   System.out.println("computing:");
   for (int i=0;i<11;i++) System.out.println("    "+Params.P[i]);
   
   {Date D=new Date();System.out.println("     ["+(D.getTime()-TS)+"]");}
   LC.reset(Params);
   LC.optimise();
   {Date D=new Date();System.out.println("     ["+(D.getTime()-TS)+"]");}
   S=Statistics.get2plus(LC,24,Anz,Init[0],Init[1],Init[2],Pop);
   {Date D=new Date();System.out.println("     ["+(D.getTime()-TS)+"]");}

   System.out.println("    -> done!");
  }
 
  System.out.println("- gc()");
  Inst=null;LC=null;
  System.gc();
   System.out.println("    -> done!");
  {Date D=new Date();System.out.println("     ["+(D.getTime()-TS)+"]");}

  System.out.println("*** Hartz ***");

  Inst=new DeutschlandHartz(L,Lr,Params.P[0],Params.P[7],Params.P[10],0.4684816);
  LC=new LifeCycle(L,Lr,Params,Inst);

  {
   System.out.println("computing:");
   for (int i=0;i<11;i++) System.out.println("    "+Params.P[i]);
   
   {Date D=new Date();System.out.println("     ["+(D.getTime()-TS)+"]");}
   LC.reset(Params);
   LC.optimise();
   {Date D=new Date();System.out.println("     ["+(D.getTime()-TS)+"]");}

   System.out.println("    -> done!");
  }

  for (int kk=0;kk<1081;kk++) try
  {
   System.out.println("Hartz - "+kk);
   S=Statistics.get2plus_Step(LC,24,Anz,Init[0],Init[1],Init[2],Pop);
   BufferedWriter f=new BufferedWriter(new FileWriter("Stats"+kk+".csv"));
   f.write("\"Age\",\"Assets\",,\"Cons\",,\"HK\",,\"approx. gross lab. inc.\",,\"net income\",,\"u\",\"u>6\",\"u>12\"\n");
   for (int i=0;i<60;i++)
   {
    f.write((i+1)+",");
    f.write((S[13*i]/24/Anz)+","+(-(S[13*i+1]-S[13*i]*S[13*i])/24/Anz/24/Anz)+",");
    f.write((S[13*i+2]/Anz)+","+(-(S[13*i+3]-S[13*i+2]*S[13*i+2])/Anz/Anz)+",");
    f.write((S[13*i+4]/24/Anz)+","+(-(S[13*i+5]-S[13*i+4]*S[13*i+4])/24/Anz/24/Anz)+",");
    f.write((LC.Inst.Brutto(LC.Inst.Scale*S[13*i+6])/Anz)+","+(-(S[13*i+7]-LC.Inst.Brutto(LC.Inst.Scale*S[13*i+6])*LC.Inst.Brutto(LC.Inst.Scale*S[13*i+6]))/Anz/Anz)+",");
    f.write((S[13*i+8]/Anz)+","+(-(S[13*i+9]-S[13*i+8]*S[13*i+8])/Anz/Anz)+",");
    f.write((S[13*i+10]/24/Anz)+","+(S[13*i+11]/24.0/Anz)+","+(S[13*i+12]/24.0/Anz)+"\n");
   }
   f.close();
  } catch (Exception e) {System.out.println("Fehler! "+e.toString());}
  
 } 
}

public class Analyse
{
 public static void main(String[] args)
 {
  GoKnecht t=new GoKnecht();
  t.start();
 }
}