import java.util.*;
import java.io.*;

abstract class Problem
{
 public Problem() {Count=0;}
 abstract public double f(double[] Param);
 
 public void announce(double[] Param) {}
 public void done() {}

 int Count;
}

class Quadr
extends Problem
{
 public double f(double[] Param)
 {
  Count++;
  return (Param[0]-67.1)*(Param[0]-67.1)+(Param[1]-72.3)*(Param[1]-72.3);
//  return -Math.exp(-(Param[0]-4.1)*(Param[0]-4.1))+0.3*(Param[1]-13.2)*(Param[1]-13.2)+5;
 }
 
}

class Rosenbrock
extends Problem
{
 public double f(double[] Param)
 {
  Count++;
  System.out.println(Count+" "+Param[0]+" "+Param[1]);
  return (1-Param[0])*(1-Param[0])+100*(Param[1]-Param[0]*Param[0])*(Param[1]-Param[0]*Param[0]);
//  return -Math.exp(-(Param[0]-4.1)*(Param[0]-4.1))+0.3*(Param[1]-13.2)*(Param[1]-13.2)+5;
 }
 
}

class Estimate1
extends Problem
{
 public Estimate1(LifeCycle LC,int[] Stat,double[] Init,ModelParameters Params,int Anz,double[] Data,double[] Bounds)
 {
  super();
  this.LC=LC;
  this.Stat=Stat;
  this.Init=Init;
  this.Params=Params;
  this.Anz=Anz;
  this.Data=Data;
  this.Bounds=Bounds;
 }

 public double f(double[] Param)
 {
  Count++;
  
  //Achtung: Inst abh. von q0!!!
  
  double[] p=new double[11];
  int j=0;
  for (int i=0;i<11;i++)
  {
   if (Params.P[i]==Double.POSITIVE_INFINITY) 
   {
    p[i]=Param[j++];
    if ((p[i]<=Bounds[2*i]) || (p[i]>=Bounds[2*i+1])) 
    {
     System.out.println(Count+": "+i+"; "+Bounds[2*i]+" "+Bounds[2*i+1]+" "+p[i]);
     return Double.POSITIVE_INFINITY;
    }
   }
   else p[i]=Params.P[i];
  }
  
  LC.reset(new ModelParameters(p[0],p[1],p[2],p[3],p[4],p[5],p[6],p[7],p[8],p[9],p[10]));

  double[] S=Statistics.get(LC,Stat,Anz,Init[0],Init[1],Init[2]);
  
  double x,D=0;
  for (int i=0;i<S.length;i++) {x=S[i]-Data[i];D+=x*x;}
  
  System.out.print(Count+": "+D+" - ");
  for (int k=0;k<j;k++) System.out.print(Param[k]+" ");System.out.println("");
  
  return D;
 }
 
 LifeCycle LC;
 int Stat[],Anz;
 double Init[],Data[],Bounds[];
 ModelParameters Params;
}

class EstimateDist
extends Problem
{
 public EstimateDist(SyncServer SS,int[] Stat,double[] Init,ModelParameters Params,int Anz,double[] Data,double[] Bounds,double[] Matrix,int BlockDiag)
 {
  super();
  Count2=0;
  this.SS=SS;
  this.Stat=Stat;
  this.Init=Init;
  this.Params=Params;
  this.Anz=Anz;
  this.Data=Data;
  this.Bounds=Bounds;
  this.Matrix=Matrix;
  this.BlockDiag=BlockDiag;
 }

 public static double[] loadArray(String path,int Anz)
 {
  double[] M=new double[Anz];
  int i=0;
  try
  {
   String Zeile;
   BufferedReader f=new BufferedReader(new FileReader(path));
   while ((Zeile=f.readLine())!=null)
   {
    StringTokenizer S=new StringTokenizer(Zeile,", \n");
    while (S.hasMoreTokens())
    {
     M[i++]=Double.parseDouble(S.nextToken());
     if (i>=Anz)
     {
      f.close();
      return M;
     }
    }
   }
   f.close();
   System.out.println("ERROR: EstimateDist kann Array nicht aus Datei "+path+" laden!");
   System.out.println("    Fehler: unerwartetes Dateiende!");
  } 
  catch (Exception e)
  {
   System.out.println("ERROR: EstimateDist kann Array nicht aus Datei "+path+" laden!");
   System.out.println("    Fehler: "+e.toString());
  }
  return null;
 }

 public static double[] eye(int size)
 {
  double[] E=new double[size*size];
  for (int i=0;i<size;i++) for (int j=0;j<size;j++)
   E[i*size+j]=(i==j)?1:0;
  return E;
 } 

 private double Square(double x[])
 {
  double Q=0;
  for (int i=0;i<x.length;i+=BlockDiag)
   for (int j=0;j<BlockDiag;j++)
    for (int k=0;k<BlockDiag;k++)
     Q+=x[i+k]*Matrix[(i+k)*x.length+i+j]*x[i+j];
  return Q; 
 }

 public double[] getList(double[] Param)
 {
  double[] p=new double[28];
  int j=0;
  for (int i=0;i<11;i++)
  {
   if (Params.P[i]==Double.POSITIVE_INFINITY) 
   {
    p[i]=Param[j++];
    System.out.println("    "+p[i]);
    if ((p[i]<=Bounds[2*i]) || (p[i]>=Bounds[2*i+1])) p[0]=Double.POSITIVE_INFINITY;
   }
   else p[i]=Params.P[i];
  }
  for (int i=0;i<13;i++) p[i+11]=Stat[i];
  p[24]=Anz;
  for (int i=0;i<3;i++) p[i+25]=Init[i];
  return p;
 }

 public double f(double[] Param)
 {
  Count++;
  System.out.println("f ("+Count+");");
  double S[],p[]=getList(Param);
  if (p[0]==Double.POSITIVE_INFINITY) return Double.POSITIVE_INFINITY;
  Count2++;
  
  System.out.println("    -> wird ermittelt ("+Count2+")");
  S=SS.getResult(1,p);
  
  double x[]=new double[S.length],D=0;
  for (int i=0;i<S.length;i++) x[i]=S[i]-Data[i];
  D=Square(x);
  
  System.out.println("    -> "+D);
  return D;
 }
 
 public void announce(double[] Param)
 {
  System.out.println("announce:");
  double D[]=getList(Param);
  if (D[0]!=Double.POSITIVE_INFINITY) SS.order(1,D);
 }
 
 public void done()
 {
//  SS.kill();
 }

 int Stat[],Anz,Count2,BlockDiag;
 double Init[],Data[],Bounds[],Matrix[];
 ModelParameters Params;
 SyncServer SS;
}

abstract class Optimiser
{
 public Optimiser(int dim,Problem func)
 {
  this.dim=dim;
  this.func=func;
 }
 
 abstract public double[] optimise(double[] Start);
 
 int dim;
 Problem func;
}

class Opt_NelderMead
extends Optimiser
{
 public Opt_NelderMead(int dim,double[] delta,Problem func)
 {
  super(dim,func);
  this.delta=delta;
 }

 public double[] optimise(double[] Start)
 {
  int i,j;
  double[][] Amoeba=new double[dim+1][dim+1];
  for (i=0;i<=dim;i++)
  {
   for (j=0;j<dim;j++) Amoeba[i][j]=Start[j];
   if (i<dim) Amoeba[i][i]+=delta[i];
   func.announce(Amoeba[i]);
  }
  for (i=0;i<=dim;i++) Amoeba[i][dim]=func.f(Amoeba[i]);
  
  double dist,center[]=new double[dim],ref[]=new double[dim+1],exp[]=new double[dim+1],con[]=new double[dim+1];
  int Hi,Lo,Hi2,finished;
  do
  {
//   System.out.println("x ("+Amoeba[0][0]+","+Amoeba[0][1]+":"+Amoeba[0][2]+"),("+Amoeba[1][0]+","+Amoeba[1][1]+":"+Amoeba[1][2]+"),("+Amoeba[2][0]+","+Amoeba[2][1]+":"+Amoeba[2][2]+")");
   finished=0;

  // "1. order"
   Hi=0;
   for (i=1;i<=dim;i++) if (Amoeba[i][dim]>Amoeba[Hi][dim]) Hi=i;

   if (Hi==0) Lo=Hi2=1; else Lo=Hi2=0;
   for (i=0;i<=dim;i++) if (i!=Hi)
   {
    if (Amoeba[i][dim]>Amoeba[Hi2][dim]) Hi2=i;
    if (Amoeba[i][dim]<Amoeba[Lo][dim]) Lo=i;
   }

  // "2. reflect"
   for (i=0;i<dim;i++)
   {
    center[i]=0;
    for (j=0;j<=dim;j++) if (j!=Hi) center[i]+=Amoeba[j][i];
    center[i]/=dim;
   }
   
  //Vorbestellung fuer 2 bis 5
   { 
    double tmp[]=new double[dim+1];
    for (i=0;i<dim;i++) tmp[i]=2*center[i]-Amoeba[Hi][i];
    func.announce(tmp);
    for (i=0;i<dim;i++) tmp[i]=3*center[i]-2*Amoeba[Hi][i];
    func.announce(tmp);
    for (i=0;i<dim;i++) tmp[i]=1.5*center[i]-0.5*Amoeba[Hi][i];
    func.announce(tmp);
    for (i=0;i<dim;i++) tmp[i]=0.5*center[i]+0.5*Amoeba[Hi][i];
    func.announce(tmp);
    for (i=0;i<=dim;i++) if (i!=Lo)
    {
     for (j=0;j<dim;j++) tmp[j]=Amoeba[Lo][j]+0.5*(Amoeba[i][j]-Amoeba[Lo][j]);
     func.announce(tmp);
    }
   }
  //ende der Vorbestellung
    
   for (i=0;i<dim;i++) ref[i]=2*center[i]-Amoeba[Hi][i];
   ref[dim]=func.f(ref);
   
   if ((ref[dim]>=Amoeba[Lo][dim]) && (ref[dim]<Amoeba[Hi2][dim]))
   {
    Amoeba[Hi]=ref;
    ref=new double[dim+1];
    finished=1;
   }
   
  // "3. expand"
   if ((finished==0) && (ref[dim]<Amoeba[Lo][dim]))
   {
    for (i=0;i<dim;i++) exp[i]=3*center[i]-2*Amoeba[Hi][i];
    exp[dim]=func.f(exp);
    
    if (exp[dim]<ref[dim])
    {
     Amoeba[Hi]=exp;
     exp=new double[dim+1];
    }
    else
    {
     Amoeba[Hi]=ref;
     ref=new double[dim+1];
    }
    finished=1;
   }
  
  // "4. contract"
   if ((finished==0) && (ref[dim]>=Amoeba[Hi2][dim]))
   {
  // "4a outside"
    if (ref[dim]<Amoeba[Hi][dim])
    {
     for (i=0;i<dim;i++) con[i]=1.5*center[i]-0.5*Amoeba[Hi][i];
     con[dim]=func.f(con);
     
     if (con[dim]<=ref[dim])
     {
      Amoeba[Hi]=con;
      con=new double[dim+1];
      finished=1;
     }
    }
  // "4b inside"
    else
    {
     for (i=0;i<dim;i++) con[i]=0.5*center[i]+0.5*Amoeba[Hi][i];
     con[dim]=func.f(con);
     
     if (con[dim]<Amoeba[Hi][dim])
     {
      Amoeba[Hi]=con;
      con=new double[dim+1];
      finished=1;
     }
    }
   }
   
  // "5. shrink"
   if (finished==0)
   {
    for (i=0;i<=dim;i++) if (i!=Lo)
    {
     for (j=0;j<dim;j++) Amoeba[i][j]=Amoeba[Lo][j]+0.5*(Amoeba[i][j]-Amoeba[Lo][j]);
     Amoeba[i][dim]=func.f(Amoeba[i]);
    }
   }

/*     
   for (i=0;i<dim;i++) Amoeba[Hi][i]=2*center[i]-Amoeba[Hi][i];
   Amoeba[Hi][dim]=func.f(Amoeba[Hi]);
   
   if (Amoeba[Hi][dim]<=Amoeba[Lo][dim])
   {
    for (i=0;i<dim;i++) Amoeba[Hi][i]=2*Amoeba[Hi][i]-center[i];
    Amoeba[Hi][dim]=func.f(Amoeba[Hi]);
   }
   else if (Amoeba[Hi][dim]>=Amoeba[Hi2][dim])
   {
    for (i=0;i<dim;i++) Amoeba[Hi][i]=(Amoeba[Hi][i]+center[i])/2;
    Amoeba[Hi][dim]=func.f(Amoeba[Hi]);
    
    if (Amoeba[Hi][dim]>=Amoeba[Hi2][dim])
    {
     for (i=0;i<dim;i++) Amoeba[Hi][i]=3*center[i]-2*Amoeba[Hi][i];
     for (i=0;i<=dim;i++) if (i!=Lo)
     {
      for (j=0;j<dim;j++) Amoeba[i][j]=Amoeba[Lo][j]+0.5*(Amoeba[i][j]-Amoeba[Lo][j]);
      Amoeba[i][dim]=func.f(Amoeba[i]);
     }
    }
   }*/
   
   
   dist=0;
   for (i=0;i<=dim;i++) if (i!=Lo)
   {
    double d2=0;
//Skalierung!!!
    for (j=0;j<dim;j++) d2+=(Amoeba[i][j]-Amoeba[Lo][j])*(Amoeba[i][j]-Amoeba[Lo][j])/(delta[j]*delta[j]);
    dist=Math.max(dist,Math.sqrt(d2));
   }
   
  } while (dist>0.01);
  
  return Amoeba[Lo];
 }
 
 private double[] delta;
}

class Opt_GradArmijo
extends Optimiser
{
 public Opt_GradArmijo(int dim,double[] delta,Problem func)
 {
  super(dim,func);
  this.delta=delta;
 }

 public double[] optimise(double[] Start)
 {
  double beta=0.7,sigma=0.5;
  double Grad[]=new double[dim],lGrad,n[]=new double[dim],Pos[]=new double[dim],Fs=func.f(Start),Fn,t,t2;
  int cnt;
  
  do
  {
   for (int i=0;i<dim;i++)
   {
    Start[i]+=delta[i];
    func.announce(Start);
    Start[i]-=delta[i];
   }

   lGrad=0;
   for (int i=0;i<dim;i++)
   {
    Start[i]+=delta[i];
    Grad[i]=(Fs-func.f(Start))/delta[i];lGrad+=Grad[i]*Grad[i];
    Start[i]-=delta[i];
   }
   lGrad=Math.sqrt(lGrad);
   if (lGrad<0.01) return Start;
   for (int i=0;i<dim;i++) n[i]=Grad[i];
   
   t=1;cnt=1;
   do
   {
    t*=beta;

    cnt--;
    if (cnt<=0)
    {
     t2=t;	
     for (int k=0;k<dim;k++)
     {
      for (int i=0;i<dim;i++) Pos[i]=Start[i]+t2*n[i];
      func.announce(Pos);
      t2*=beta;
     }
     cnt=dim;
    }

    for (int i=0;i<dim;i++) Pos[i]=Start[i]+t*n[i];
    Fn=func.f(Pos);
   }
   while (Fn>Fs-sigma*t*lGrad*lGrad);
   
   Fs=Fn;
   for (int i=0;i<dim;i++) Start[i]=Pos[i];
  }
  while (true);
  
 }

 double[] delta;
}

class Opt_EvolStrat
extends Optimiser
{
 public Opt_EvolStrat(int dim,double[] bounds,int my,int lambda,boolean lambdaplusmy,int maxGen,Problem func)
 {
  super(dim,func);
  this.bounds=bounds;
  this.my=my;this.lambda=lambda;
  if (lambdaplusmy) this.lambdaplusmy=1;else this.lambdaplusmy=0;
  this.maxGen=maxGen;
 }
/*
 private double[] Cholesky(double A[])
 {
  double L[]=new double[dim*dim];
  for (int i=0;i<dim;i++) for (int k=0;k<dim;k++)
  {
   if (k<i)
   {
    L[i*dim+k]=A[i*dim+k];
    for (int m=0;m<k;m++) L[i*dim+k]-=L[i*dim+m]*L[k*dim+m];
    L[i*dim+k]/=L[k*dim+k];
   }
   else if (k==i)
   {
    L[i*dim+i]=A[i*dim+i];
    for (int m=0;m<i;m++) L[i*dim+k]-=L[i*dim+m]*L[i*dim+m];
    L[i*dim+i]=Math.sqrt(L[i*dim+i]);
    if (L[i*dim+i]!=L[i*dim+i])
    {
     for (int kkk=0;kkk<dim*dim;kkk++) System.out.println(A[kkk]);
     System.exit(1);
    }
   }
   else L[i*dim+k]=0;
  }
  return L;
 }*/

 private double[] Rot(int i,int j,double w)
 {
  double T[]=new double[dim*dim];
  for (int ii=0;ii<dim;ii++) for (int jj=0;jj<dim;jj++)
  {
   if (((ii==i) && (jj==i)) || ((ii==j) && (jj==j))) T[ii*dim+jj]=Math.cos(w);
   else if ((ii==i) && (jj==j)) T[ii*dim+jj]=-Math.sin(w);
   else if ((ii==j) && (jj==i)) T[ii*dim+jj]=Math.sin(w);
   else if (ii==jj) T[ii*dim+jj]=1;
   else T[ii*dim+jj]=0;
  }
  return T;
 }

 private double[] MM(double[] A,double[] B)
 {
  double E[]=new double[dim*dim];
  for (int i=0;i<dim;i++) for (int j=0;j<dim;j++)
  {
   E[i*dim+j]=0;
   for (int k=0;k<dim;k++) E[i*dim+j]+=A[i*dim+k]*B[k*dim+j];
  }
  return E;
 }

 private double[] coord(double[] q)
 {
  double r[]=new double[dim];
  for (int i=0;i<dim;i++) r[i]=q[dim*dim+i];
  return r;
 }

 public double[] optimise(int GS)
 {
  double tau1=1/Math.sqrt(2*Math.sqrt((double)dim)),tau2=1/Math.sqrt(2*(double)dim),beta=0.0873;
  double avg;
  double[] best=null;
 
  double Pop[][]=new double[lambda][dim+dim*dim+1];
  double Parents[][]=new double[my][],Children[][]=new double[lambda][dim+dim*dim+1],Parents2[][];
  double Ranking[]=new double[lambda+lambdaplusmy*my];

  Random R=new Random(42345);
 
  if (GS==0) for (int i=0;i<lambda;i++)
  {
   for (int j=0;j<dim;j++) for (int k=0;k<dim;k++)
   {
    if (j==k) Pop[i][j*dim+k]=0.03*Math.abs(R.nextGaussian());else Pop[i][j*dim+k]=2*Math.PI*R.nextDouble();
   }
   for (int j=0;j<dim;j++) Pop[i][dim*dim+j]=R.nextDouble()*(bounds[2*j+1]-bounds[2*j])+bounds[2*j];
   func.announce(coord(Pop[i]));
  }
  if (GS==0) for (int i=0;i<lambda;i++) Pop[i][dim*dim+dim]=func.f(coord(Pop[i]));
  
  int Gen=0;
  
  if (GS>0)
  {
   Gen=GS-1;
   System.out.println("Lade Generation "+GS);
   try
   {
    ObjectInputStream is=new ObjectInputStream(new FileInputStream(new File("gen"+GS+".gen")));
    Pop=(double[][])is.readObject();
    is.close();
   }
   catch (Exception e) {System.out.println("Kann Generation "+GS+" nicht laden: "+e.toString());}
   if ((lambdaplusmy==1) && (Gen>1)) try
   {
    ObjectInputStream is=new ObjectInputStream(new FileInputStream(new File("gen"+GS+".par")));
    Parents=(double[][])is.readObject();
    is.close();
   }
   catch (Exception e) {System.out.println("Kann Generation "+GS+" nicht laden (Eltern): "+e.toString());}
  }
  
  do
  {

   //zur Sicherheit...
   {
    Gen++;
    try
    {
     ObjectOutputStream os=new ObjectOutputStream(new FileOutputStream(new File("gen"+Gen+".gen")));
     os.writeObject(Pop);
     os.close();
    }
    catch (Exception e) {System.out.println("Kann Generation "+Gen+" nicht speichern: "+e.toString());}
    if ((lambdaplusmy==1) && (Gen>1)) try
    {
     ObjectOutputStream os=new ObjectOutputStream(new FileOutputStream(new File("gen"+Gen+".par")));
     os.writeObject(Parents);
     os.close();
    }
    catch (Exception e) {System.out.println("Kann Generation "+Gen+" nicht speichern (Eltern): "+e.toString());}
   }	
  
   //Selection
   for (int i=0;i<lambda;i++) Ranking[i]=Pop[i][dim*dim+dim];
   if (lambdaplusmy==1)
   {
    if (Gen>1) for (int i=0;i<my;i++) Ranking[i+lambda]=Parents[i][dim*dim+dim];
    else for (int i=0;i<my;i++) Ranking[i+lambda]=Double.POSITIVE_INFINITY;
   }
   Arrays.sort(Ranking);
   int k=0;avg=0;
   Parents2=new double[my][];
   for (int i=0;i<lambda;i++) if ((Pop[i][dim*dim+dim]<=Ranking[my-1]) && (k<my)) {Parents2[k++]=Pop[i];avg+=Pop[i][dim*dim+dim];if (Pop[i][dim*dim+dim]==Ranking[0]) best=Pop[i];}
   if ((lambdaplusmy==1) && (Gen>1)) for (int i=0;i<my;i++) if ((Parents[i][dim*dim+dim]<=Ranking[my-1]) && (k<my)) {Parents2[k++]=Parents[i];avg+=Parents[i][dim*dim+dim];if (Parents[i][dim*dim+dim]==Ranking[0]) best=Parents[i];}
   Parents=Parents2;

   if ((Ranking[my-1]-Ranking[0]<0.0001/**Math.abs(avg)/my*/) || ((maxGen>0) && (Gen>=maxGen)))
    return coord(best);

   Pop=new double[lambda][dim+dim*dim+1];   
      
   for (int i=0;i<lambda;)
   {
   //Recombination
    int mom=Math.abs(R.nextInt())%my,dad=Math.abs(R.nextInt())%my;
    for (int j=0;j<dim;j++) Children[i][j*dim+j]=0.5*(Parents[mom][j*dim+j]+Parents[dad][j*dim+j]);
    for (int j=0;j<dim-1;j++) for (k=j+1;k<dim;k++) Children[i][j*dim+k]=0.5*((Parents[mom][j*dim+k]+Parents[dad][j*dim+k])%(4*Math.PI));
    for (int j=dim*dim;j<dim*dim+dim;j++) Children[i][j]=(R.nextDouble()<0.5)?Parents[mom][j]:Parents[dad][j];
   
   //Mutation
    for (int j=0;j<dim;j++) Pop[i][j*dim+j]=Children[i][j*dim+j]*Math.exp(tau1*R.nextGaussian()+tau2*R.nextGaussian());
    for (int j=0;j<dim-1;j++) for (k=j+1;k<dim;k++) Pop[i][j*dim+k]=(Children[i][j*dim+k]+beta*R.nextGaussian())%(2*Math.PI);

    double x[]=new double[dim],Mat[]=Rot(0,0,0);
    for (int j=0;j<dim-1;j++) for (k=j+1;k<dim;k++) Mat=MM(Mat,Rot(j,k,Pop[i][dim*j+k]));
    boolean outside=false;
    for (int j=0;j<dim;j++) x[j]=R.nextGaussian()*Pop[i][dim*j+j];
    for (int j=0;j<dim;j++)
    {
     Pop[i][j+dim*dim]=Children[i][j+dim*dim];
     for (k=0;k<dim;k++) Pop[i][j+dim*dim]+=x[k]*Mat[j*dim+k]*(bounds[2*j+1]-bounds[2*j]);
     outside|=(Pop[i][j+dim*dim]<bounds[2*j]) || (Pop[i][j+dim*dim]>bounds[2*j+1]);
    } 

    if (!outside) i++;
   }
   
   //Evaluation
   for (int i=0;i<lambda;i++) func.announce(coord(Pop[i]));
   for (int i=0;i<lambda;i++) Pop[i][dim*dim+dim]=func.f(coord(Pop[i]));
   
  } while (true);
  
 }

 public double[] optimise(double[] Start) {return optimise(0);}

 double[] bounds;
 int my,lambda,lambdaplusmy,maxGen;
}

class Opt_SimAnn
extends Optimiser
{
 public Opt_SimAnn(int dim,double[] bounds,Problem func)
 {
  super(dim,func);
  this.bounds=bounds;
 }

 public double[] optimise(double[] Start) 
 {
  double D[]=new double[dim],next[],best[]=(double[])Start.clone(),alpha=0.1,omega=2.1,T,f,g,h,db;
  for (int i=0;i<dim;i++) D[i]=(bounds[2*i+1]-bounds[2*i])/20;

  Random R=new Random(123456);
  int L=0,Acc=0,TSteps=0;
  boolean Progress=false,legal;

  //Initial T
  {
   double d=0;
   next=(double[])Start.clone();
   f=func.f(next);
   for (int i=0;i<30;)
   {
    do 
    {
     legal=true;
     for (int j=0;j<dim;j++) 
     {
      next[j]+=(2*R.nextDouble()-1)*D[j];
      if ((next[j]<bounds[2*j]) || (next[j]>bounds[2*j+1])) legal=false;
     }
    } 
    while (!legal);
    g=func.f(next);
    if (g>f) {d+=g-f;i++;}
    f=g;
   }
   db=0;for (int i=0;i<dim;i++) db+=D[i]/2;
   
   T=-d/(30*Math.log(0.8)*db);
  }
  
  h=f=func.f(Start);
  do
  {
   //generate new solution
   do
   {
    db=0;
    legal=true;
    for (int i=0;i<dim;i++) 
    {
     double x=(2*R.nextDouble()-1)*D[i];
     db+=Math.abs(x);
     next[i]=Start[i]+x;
     if ((next[i]<bounds[2*i]) || (next[i]>bounds[2*i+1])) legal=false;
    }
   }
   while (!legal);
   db/=dim;
   
   //accept?
   g=func.f(next);
   if ((g<f) || (R.nextDouble()<Math.exp(-(g-f)/(T*db))))
   {
    for (int i=0;i<dim;i++) D[i]=(1-alpha)*D[i]+alpha*omega*Math.abs(Start[i]-next[i]);
    Start=next;next=new double[dim];
    if (f<g) Progress=true;
    f=g;
    if (f<h) {best=(double[])Start.clone();h=f;}
    Acc++;
   }
   L++;
   
   //decrease Temp?
   if ((L>30) || (Acc>20))
   {
    if ((TSteps>250) && !Progress) return best;
    L=Acc=0;
    T*=0.93;
    TSteps++;
    Progress=false;
   }
   
  } while (true);
 }

 double[] bounds;
}

class Opt_LineSearch
extends Optimiser
{
 public Opt_LineSearch(int dim,double[] bounds,int Anz,Problem func)
 {
  super(dim,func);
  this.bounds=bounds;
  this.Anz=Anz;
 }

 public double[] optimise(double[] Start) 
 {
  double[][] Cube=new double[dim][3];
  double[] Pos=null;
  int[] Pts=new int[dim];
 
  for (int i=0;i<dim;i++)
  {
   Cube[i][0]=Start[i];
   Pts[i]=1;
  }
  
  func.announce(Start);
  for (int i=0;i<dim;i++)
  {
   Pos=(double[])Start.clone();
   for (int j=1;j<=Anz;j++)
   {
    Pos[i]=bounds[2*i]+j*(bounds[2*i+1]-bounds[2*i])/(Anz+1);
    func.announce(Pos);
   }
  }

  double vS=func.f(Start);
  for (int i=0;i<dim;i++) Cube[i][2]=vS;
  
  for (int i=0;i<dim;i++)
  {
   Pos=(double[])Start.clone();
   for (int j=1;j<=Anz;j++)
   {
    Pos[i]=bounds[2*i]+j*(bounds[2*i+1]-bounds[2*i])/(Anz+1);
    double v=func.f(Pos);
    if (v<Cube[i][2]) {Cube[i][2]=v;Pts[i]=2;Cube[i][1]=Pos[i];}
   }
  }
  
  for (int i=0;i<dim;i++)
  {
   Pos=(double[])Start.clone();
   double Basis=Cube[i][Pts[i]-1];
   for (int j=1;j<=Anz;j++)
   {
    Pos[i]=Basis+(j-Anz/2)*(bounds[2*i+1]-bounds[2*i])*2/((Anz+1)*Anz);
    func.announce(Pos);
   }
  }
  
  int cnt=0;
  for (int i=0;i<dim;i++)
  {
   Pos=(double[])Start.clone();
   double Basis=Cube[i][Pts[i]-1];
   for (int j=1;j<=Anz;j++)
   {
    Pos[i]=Basis+(j-Anz/2)*(bounds[2*i+1]-bounds[2*i])*2/((Anz+1)*Anz);
    double v=func.f(Pos);
    if (v<Cube[i][2]) {Cube[i][2]=v;Pts[i]=2;Cube[i][1]=Pos[i];}
   }
   cnt+=Pts[i];
  }
 
//  for (int i=0;i<dim;i++) System.out.println("==> "+Pts[i]+" "+Cube[i][Pts[i]-1]+" "+Cube[i][2]);
  
  if (cnt==dim) return Start;
  double bestv=vS,mixv;
  int besti=0;
  for (int i=0;i<dim;i++) if (Cube[i][2]<bestv) {bestv=Cube[i][2];besti=i;}
  for (int i=0;i<dim;i++) Pos[i]=Cube[i][Pts[i]-1];
  mixv=func.f(Pos);
//  System.out.println("==> "+mixv);
  if (mixv<bestv) return Pos;
  Start[besti]=Cube[besti][1];
  return Start;
     
 }
 
 double[] bounds;
 int Anz;
}

/*
class opt_test
{
 public static void main(String[] args)
 {
  Problem Pr=new Quadr();
  Opt_NelderMead O=new Opt_NelderMead(2,Pr);
  double[] x={0,0};
  double[] Min=O.optimise(x);
  System.out.println(Min[0]+" "+Min[1]+" "+Pr.Count);
 }
}*/