import java.util.*;
import java.io.*;
import java.net.*;
import java.text.*;

class SyncElem
implements Serializable
{
 public SyncElem(int Ty,int Ta,double[] Da) {Data=Da;Type=Ty;Task=Ta;}
 
 double Data[];
 int    Type,Task;
}

class SyncServer
{
 public SyncServer(int Port,int Len)
 {
  Wait=259200; //30 days
  
  serverSocket=null;
  try 
  {
   serverSocket=new ServerSocket(Port);
  } 
  catch (IOException e) 
  {
   System.out.println("Could not listen on port: "+Port);
   System.exit(1);
  }

  this.Len=Len;
  Aufgaben=new int[Len];Typen=new int[Len];STime=new long[Len];Pos=0;
  raus=new double[Len][];rein=new double[Len][];
  for (int i=0;i<Len;i++)
  {
   Aufgaben[i]=Typen[i]=0;STime[i]=0;rein[i]=raus[i]=null;
  }
 }
 
 public void order(int Typ,double Dat[])
 {
  Pos++;
  Aufgaben[Pos%Len]=Pos;Typen[Pos%Len]=Typ;raus[Pos%Len]=(double[])Dat.clone();rein[Pos%Len]=null;
  STime[Pos%Len]=0;
 }
 
 public double[] getResult(int Typ,double Dat[])
 {
  int x=-1;
  for (int i=0;i<Len;i++) if ((Typen[i]==Typ) && Arrays.equals(raus[i],Dat)) x=i;
  if (x==-1) {order(Typ,Dat);x=Pos%Len;}
  
  int WaitingTime=0;
  while (rein[x]==null) try 
  {
   Socket clientSocket=null;
   clientSocket=serverSocket.accept();
   ObjectOutputStream os=new ObjectOutputStream(clientSocket.getOutputStream());
   ObjectInputStream is=new ObjectInputStream(clientSocket.getInputStream());
   SyncElem E=(SyncElem)is.readObject();
   if (E.Task<0)
    {for (int i=0;i<Len;i++) if (Aufgaben[i]==-E.Task) rein[i]=E.Data;os.writeObject(E);}
   else
   {
    Date D=new Date();
    boolean sent=false;
    for (int i=x;(i<x+Len) && !sent;i++) if ((STime[i%Len]==0) && (Aufgaben[i%Len]>0))
    {
     E.Task=Aufgaben[i%Len];E.Type=0;E.Data=raus[i%Len];
     STime[i%Len]=D.getTime();
     sent=true;
     os.writeObject(E);
    }
    for (int i=x;(i<x+Len) && !sent;i++) if ((D.getTime()-STime[i%Len]>((i==x)?1000:1500)*(long)Wait) && (Aufgaben[i%Len]>0) && (rein[i%Len]==null))
    {
     System.out.println("Reassigned task "+Aufgaben[i%Len]+" after waiting "+(D.getTime()-STime[i%Len])/1000+" seconds.");
     E.Task=Aufgaben[i%Len];E.Type=0;E.Data=raus[i%Len];
     STime[i%Len]=D.getTime();
     sent=true;
     os.writeObject(E);
    }
    if (!sent)
    {
     E.Task=0;E.Type=15;E.Data=null;
     os.writeObject(E);
    }
   }
   is.close();
   os.close();
   clientSocket.close();
  }
  catch (Exception e)
  {
   System.out.println("getTask: Fehler: "+e.toString());
//   System.exit(1);
  }   

  return rein[x];
 }
  
 ServerSocket serverSocket;
 
 private int Aufgaben[],Typen[],Pos,Len;
 private long STime[];
 private double raus[][],rein[][];
  
 public int Wait;
}

class SyncClient
{
 public SyncClient(String server,int Port)
 {
  this.server=server;
  this.Port=Port;
  
  R=new Random();
 }
 
 public SyncElem getTask()
 {
  SyncElem E=null;
  try
  {
   do
   {
    Socket socket=null;
    E=new SyncElem(0,0,null);
    socket=new Socket(server,Port);
    ObjectOutputStream os=new ObjectOutputStream(socket.getOutputStream());
    os.writeObject(E);
    ObjectInputStream is=new ObjectInputStream(socket.getInputStream());
    E=(SyncElem)is.readObject();
    is.close();
    os.close();
    socket.close();
    if (E.Task==0) Thread.sleep((1000+R.nextInt(1000))*E.Type);
   } while (E.Task==0);
  }
  catch (SocketException e)
  {
   System.out.println("getTask: Socket-Fehler: "+e.toString());
   System.exit(1);
  }
  catch (Exception e)
  {
   System.out.println("getTask: Fehler: "+e.toString());
//   System.exit(1);
  }
  return E;
 }

 public void putResult(SyncElem E)
 {
  E.Task*=-1;
  try
  {
   Socket socket=null;
   socket=new Socket(server,Port);
   ObjectOutputStream os=new ObjectOutputStream(socket.getOutputStream());
   os.writeObject(E);
   ObjectInputStream is=new ObjectInputStream(socket.getInputStream());
   is.readObject();
   os.close();
   socket.close();
  }
  catch (SocketException e)
  {
   System.out.println("getTask: Socket-Fehler: "+e.toString());
   System.exit(1);
  }
  catch (Exception e)
  {
   System.out.println("getTask: Fehler: "+e.toString());
//   System.exit(1);
  }
 }

 int Port;
 String server;
 Random R;
}

