import java.util.*;
import java.io.*;

public class meister_de
{
 public static void main(String[] args)
 {
  try {System.setOut(new PrintStream(new FileOutputStream("meisterlog.txt",true)));} catch (Exception e) {}
  
  System.out.println("-------------------------------------------------------");
  
  //DE
  ModelParameters Params=new ModelParameters(
     0,			//q0	0 +++
     0.00066160831,	//de	1 ***
     0.001,		//du	2
     0.05,		//df	3
     0.001699470693,	//jd	4 ***
     0.1,		//jc	5
     0.1,		//jv	6 (SE of JobOffers)
     1.00136259593,	//R	7 ***
     0.998527457,	//beta	8
     3.0,		//gamma	9
     550);		//Scale 10

  double[] Bounds=
   { 0,10,				//q0	0
     0,1,				//de	1
     -0.001,0.03,			//du	2
     0,0.5,				//df	3
     0,1,				//jd	4
     0,20,				//jc	5
     0,0.5,				//jv	6
     0.5,2,				//R	7
     0.993,1,				//beta	8
     0.5,6,				//gamma	9
     700,2100};				//Scale 10

  int [] Stat=
  { 24,		//Periods p.a.
    3,		//1st relevant year (starting at 0)
    45,		//1st irrelevant year
    3,		//aggregation length
    0,		//yL "Brutto"
    5,		//wksu
    -1,		//assets
    10,		//delta log c
    -1,		//P(wksu=0)
    -1,		//P(wksu(t-1)=i)
    0,0,0,0};
    
   double[] Init=
   { 1,
     4861,   //=APW/12
     1};

  double Pos[][]=new double[100][11],Start[]=new double[11],best=Double.POSITIVE_INFINITY,delta[]=new double[11],bounds[]=new double[22];
  Random R=new Random();

  SyncServer SS=new SyncServer(4442,200);SS.Wait=18000;


  Params.P[2]=Params.P[3]=Params.P[5]=Params.P[6]=Params.P[8]=Params.P[10]=Double.POSITIVE_INFINITY;
  int k=0;
  for (int i=0;i<11;i++) if (Params.P[i]==Double.POSITIVE_INFINITY)
  {
   delta[k]=(Bounds[2*i+1]-Bounds[2*i])/100;
   bounds[2*k]=Bounds[2*i];bounds[2*k+1]=Bounds[2*i+1];
   Start[k]=(3*Bounds[2*i+1]+2*Bounds[2*i])/5;
   k++;
  }

  EstimateDist E=new EstimateDist(SS,Stat,Init,Params,50000,EstimateDist.loadArray("de_mmean_short.csv",210),Bounds,EstimateDist.loadArray("de_mvar_short.csv",210*210),15);


  Optimiser O1=new Opt_EvolStrat(6,bounds,24,160,true,30,E);
  Optimiser O2=new Opt_NelderMead(6,delta,E);

  System.out.println("--- EvolStrat (lambda+my=true, 24-160) ---");
  Start=O1.optimise(null);
  System.out.println("--- EvolStrat done! ---");
  for (int i=0;i<Start.length;i++) System.out.println("    "+Start[i]);
  
  System.out.println("--- NelderMead ---");
  Start=O2.optimise(Start);
  System.out.println("--- NelderMead done! ---");
  for (int i=0;i<Start.length;i++) System.out.println("    "+Start[i]);

 }
}