clear
set memory 40m
use "d:\dis\daten3\us_equiv_p.dta"
log using "d:\dis\daten3\us_deltae.log", replace

sort id year
gen self1=0
replace self1=1 if self==3
by id: egen everself=max(self1)

by id: gen wksel=wkse[_n-1] if (year-year[_n-1]==1)
by id: gen wksul=wksu[_n-1] if (year-year[_n-1]==1)
gen y=i11110/price

gen relevant1=0
replace relevant1=1 if (everself==0) & (d11101>=21) & (d11101<65) & (wksel>=48) & (wksul==0) & (wkse>=48) & (wksu==0)
by id: gen yl=y[_n-1]
gen relevant2=0
replace relevant2=1 if (relevant1==1) & (y>=0) & (yl>=0)

egen w=sum(w11102*relevant2)
egen w2=sum(w11102*w11102*relevant2/w/w)
egen my=sum(y*w11102*relevant2/w)
egen myl=sum(yl*w11102*relevant2/w)
gen deltae=my/myl
gen res=y-deltae*yl
egen mres=sum(res*w11102*relevant2/w)
egen var=mean(relevant2*(res-mres)*(res-mres)*w2/myl/myl)
inspect deltae var

sort d11102
by d11102: egen ws=sum(w11102*relevant2)
by d11102: egen w2s=sum(w11102*w11102*relevant2/ws/ws)
by d11102: egen mys=sum(y*w11102*relevant2/ws)
by d11102: egen myls=sum(yl*w11102*relevant2/ws)
by d11102: gen deltaes=mys/myls
by d11102: gen ress=y-deltaes*yl
by d11102: egen mress=sum(ress*w11102*relevant2/ws)
by d11102: egen vars=mean(relevant2*(ress-mress)*(ress-mress)*w2s/myls/myls)
by d11102: inspect deltaes vars

sort d11108
by d11108: egen we=sum(w11102*relevant2)
by d11108: egen w2e=sum(w11102*w11102*relevant2/we/we)
by d11108: egen mye=sum(y*w11102*relevant2/we)
by d11108: egen myle=sum(yl*w11102*relevant2/we)
by d11108: gen deltaee=mye/myle
by d11108: gen rese=y-deltaee*yl
by d11108: egen mrese=sum(rese*w11102*relevant2/we)
by d11108: egen vare=mean(relevant2*(rese-mrese)*(rese-mrese)*w2e/myle/myle)
by d11108: inspect deltaee vare

sort d11102 d11108
by d11102 d11108: egen wse=sum(w11102*relevant2)
by d11102 d11108: egen w2se=sum(w11102*w11102*relevant2/wse/wse)
by d11102 d11108: egen myse=sum(y*w11102*relevant2/wse)
by d11102 d11108: egen mylse=sum(yl*w11102*relevant2/wse)
by d11102 d11108: gen deltaese=myse/mylse
by d11102 d11108: gen resse=y-deltaese*yl
by d11102 d11108: egen mresse=sum(resse*w11102*relevant2/wse)
by d11102 d11108: egen varse=mean(relevant2*(resse-mresse)*(resse-mresse)*w2se/mylse/mylse)
by d11102 d11108: inspect deltaese varse

log close

