clear
set memory 40m
use "~/Desktop/Research/00 - EstLC/08-11-Journal of Applied Econometrics/V3/Estimation/newGroupsAndConstraints/original/us_equiv_p.dta"
log using "~/Desktop/Research/00 - EstLC/08-11-Journal of Applied Econometrics/V3/Estimation/newGroupsAndConstraints/04 - US outliers/us_lambda.log", replace

drop if (l11101==0) | (l11101>51) | (l11101==1) | (l11101==8) | (l11101==51) | (l11101==23) | (l11101==24) | (l11101==36) | (l11101==38)

sort id year
gen self1=0
replace self1=1 if self==3
by id: egen everself=max(self1)

by id: gen wksel=wkse[_n-1] if (year-year[_n-1]==1)
by id: gen wksul=wksu[_n-1] if (year-year[_n-1]==1)

gen relevant1=0
replace relevant1=1 if (everself==0) & (d11101>=21) & (d11101<65) & (wksel+wksul>=48) & (wksul==0) & (wkse+wksu>=48)
gen relevant2=0
replace relevant2=1 if (relevant1==1) & (wksu==0)

egen w=sum(w11102*relevant1)
egen lambda=sum(w11102*relevant2/w)
egen var=sum(w11102*w11102*relevant1/w/w*lambda*(1-lambda))
inspect lambda var

sort d11102
by d11102: egen ws=sum(w11102*relevant1)
by d11102: egen lambdas=sum(w11102*relevant2/ws)
by d11102: egen vars=sum(w11102*w11102*relevant1/ws/ws*lambdas*(1-lambdas))
by d11102: inspect lambdas vars

sort d11108
by d11108: egen we=sum(w11102*relevant1)
by d11108: egen lambdae=sum(w11102*relevant2/we)
by d11108: egen vare=sum(w11102*w11102*relevant1/we/we*lambdae*(1-lambdae))
by d11108: inspect lambdae vare

sort d11102 d11108
by d11102 d11108: egen wse=sum(w11102*relevant1)
by d11102 d11108: egen lambdase=sum(w11102*relevant2/wse)
by d11102 d11108: egen varse=sum(w11102*w11102*relevant1/wse/wse*lambdase*(1-lambdase))
by d11102 d11108: inspect lambdase varse

log close

