A=xlsread('~/Desktop/Research/00 - EstLC/08-11-Journal of Applied Econometrics/V3/Estimation/newGroupsAndConstraints/02 - edu/de_finalmente_short_edu2.xls');
W=A(:,1:end-1)';
Weights=A(:,end);

agemin=23;
agemax=64;
agedist=3;

killmin=1;killmax=size(W,2);
while W(6,killmin)<agemin
    killmin=killmin+1;
end;
while W(6,killmax)>agemax
    killmax=killmax+1;
end;

W=W(:,killmin:killmax);
Weights=Weights(killmin:killmax,:);
Weights=Weights/sum(Weights');

cases=size(W,2);
M=zeros(15*ceil((agemax-agemin+1)/agedist),cases);
AgeWeights=zeros(ceil((agemax-agemin+1)/agedist),1);

for c=1:cases
    m=floor((W(6,c)-agemin)/agedist);
    AgeWeights(m+1,1)=AgeWeights(m+1,1)+Weights(c,1);
    m=m*15;
    
    ul=round(W(3,c));
    if ul==0
        wp=0;
    elseif ul<=6
        wp=1;
    elseif ul<=12
        wp=2;
    elseif ul<24
        wp=3;
    else
        wp=4;
    end;    

%    M(m+1,c)=W(1,c);                          % yL "Brutto"
%    M(m+2,c)=W(2,c);                          % wksu
%    M(m+3,c)=log(W(4,c)/W(5,c));              % delta log c
%    if (W(2,c)>0) & (W(3,c)>0)               % P(wksu>0|wksu(t-1)>0)*P(wksu(t-1)>0)
%        M(m+3,c)=1; 
%    end;
%    M(m+4+wp,c)=W(2,c);                   % E(wksu|wksu(t-1))*P(wksu(t-1))
%    if (W(2,c)==0) & (W(3,c)>0)              % E(yL|wks(t-1)>0 & wks(t)=0)*P(wks(t-1)>0 & wks(t)=0)
%        M(m+10,c)=W(1,c); 
%    end;
%    M(m+11+wp,c)=log(W(4,c)/W(5,c));       % E(delta log c|wksu(t-1))*P(wksu(t-1))
%    M(m+16+wp,c)=1;                       % P(wksu(t-1)=i)

    M(m+1+wp,c)=W(1,c);                          % yL "Brutto"
    M(m+6+wp,c)=W(2,c);                          % wksu
    M(m+11+wp,c)=log(W(4,c)/W(5,c));              % delta log c
    if W(2,c)>0               % P(wksu>0|wksu(t-1)>0)*P(wksu(t-1)>0)
%        M(m+16+wp,c)=1; 
    end;
%    M(m+21+wp,c)=1;                       % P(wksu(t-1)=i)
end;

MWeight=zeros(size(M,1),1);
for i=1:ceil((agemax-agemin+1)/agedist)
    for j=1:15
        MWeight((i-1)*15+j,1)=AgeWeights(i,1);
    end;
end;

MMean=(M*Weights)./MWeight;
MVar=zeros(size(M,1),size(M,1));

rank(M)

fehlt=0;
for i=1:ceil((agemax-agemin+1)/agedist)
    for j=1:5
        rt=zeros(3,cases);
        for k=0:2
            rt(k+1,:)=M((i-1)*15+j+k*5,:)-MMean((i-1)*15+j+k*5);
        end;
%        fehlt=fehlt+3-rank(rt);
%        if rank(rt)<3
          %  fehlt=fehlt+3;
%            for k=0:2
%                M((i-1)*15+j+k*5,:)=zeros(1,cases);
%                MMean((i-1)*15+j+k*5,1)=0;
%            end;
%        end;

        less=0;
        while (rank(rt)<3-less) & (less<3)
            fehlt=fehlt+1;
            rt(3-less,:)=zeros(1,cases);
            M((i-1)*15+j+(2-less)*5,:)=zeros(1,cases);
            MMean((i-1)*15+j+(2-less)*5,1)=0;
            less=less+1;
        end;
    end;
end;
fehlt

for c=1:cases
%    MVar=MVar+(M(:,c)-MMean)*(M(:,c)-MMean)'*Weights(c,1);
    m=floor((W(6,c)-agemin)/agedist)*15;
    x=M(m+1:m+15,c)-MMean(m+1:m+15);
    y=x*x'*Weights(c,1);
    for i=1:15
        for j=1:15
            MVar(m+i,m+j)=MVar(m+i,m+j)+y(i,j);
        end;
    end;
end;        

rank(MVar)
%IMVar2=pinv(MVar);
%rank(IMVar2)

indizes=zeros(15*ceil((agemax-agemin+1)/agedist),1);
for i=15*ceil((agemax-agemin+1)/agedist):-1:1
    if MVar(i,i)==0
        i;
        indizes(i,1)=1;
        MVar=[MVar(1:i-1,1:i-1) MVar(1:i-1,i+1:end);MVar(i+1:end,1:i-1) MVar(i+1:end,i+1:end)];
    end;
end;


IMVar=inv(MVar);
%K=IMVar;
%L=chol(MVar);
for i=1:15*ceil((agemax-agemin+1)/agedist)
    if indizes(i)==1
        tmp=[IMVar(1:i-1,1:i-1) zeros(i-1,1);zeros(1,i)];
        if i<210
            tmp=[tmp [IMVar(1:i-1,i:end);zeros(1,size(IMVar,1)-i+1)];IMVar(i:end,1:i-1) zeros(size(IMVar,1)-i+1,1) IMVar(i:end,i:end)];
        end;
        IMVar=tmp;
    end;
end;

%for i=1:14
%    if rank(MVar((i-1)*25+1:(i-1)*25+25,(i-1)*25+1:(i-1)*25+25))<25-ones(1,25)*indizes((i-1)*25+1:(i-1)*25+25,1)
%        i
%        rank(MVar((i-1)*25+1:(i-1)*25+25,(i-1)*25+1:(i-1)*25+25))
%        25-ones(1,25)*indizes((i-1)*25+1:(i-1)*25+25,1)
%    end;
%end;


det(MVar)

csvwrite('~/Desktop/Research/00 - EstLC/08-11-Journal of Applied Econometrics/V3/Estimation/newGroupsAndConstraints/02 - edu/de_mvar_short_edu2.csv',IMVar);
csvwrite('~/Desktop/Research/00 - EstLC/08-11-Journal of Applied Econometrics/V3/Estimation/newGroupsAndConstraints/02 - edu/de_mmean_short_edu2.csv',MMean);