*code the youth variables

*generate a variable for the NUMBER OF SIBLINGS currently living in the household when the individual is 17
	local waves q r s t u v w x y z

	use "$datapath\pkind.dta", clear	  
	duplicates tag hhnr, generate(y_nrsibs99)
	rename pksex y_sex99
	lab var y_sex99 "sex of the child"
	lab var y_nrsibs99 "nr of siblings of youth living in hh in 99"
	replace y_nrsibs99=y_nrsibs99
	cd "$datapatha"
		sort hhnr
		keep hhnr persnr y_nrsibs99 y_sex99
		sort hhnr persnr
	save "$datapatha\pnrsibs.dta", replace
	cap saveold "$datapatha\pnrsibs.dta", replace

	local waves q r s t u v w x y z ba
	local t=0
	foreach x of local waves{
	use "$datapath\\`x'kind.dta", clear	  
	duplicates tag hhnr, generate(y_nrsibs0`t')
	rename `x'ksex y_sex0`t'
	lab var y_sex0`t' "sex of the child"
	lab var y_nrsibs0`t' "nr of siblings of youth living in hh in 0`t'"
	replace y_nrsibs0`t'=y_nrsibs0`t'
	cd "$datapatha"
		sort hhnr
		keep hhnr persnr y_nrsibs0`t' y_sex0`t'
		sort hhnr persnr
	save "$datapatha\\`x'nrsibs.dta", replace
	cap saveold "$datapatha\\`x'nrsibs.dta", replace 
	local t=`t'+1
	}
	
*********Merge information on the big five************************************

	use "$datapath\wpage17.dta", clear
	rename  wj9101 y_Pc1
	rename  wj9102 y_Pe1
	rename  wj9103 y_Pa1
	rename  wj9104 y_Po1
	rename  wj9105 y_Pn1
	rename  wj9106 y_Pa2
	rename  wj9107 y_Pc2
	rename  wj9108 y_Pe2
	rename  wj9109 y_Po2
	rename  wj9110 y_Pn2
	rename  wj9111 y_Pc3
	rename  wj9112 y_Pe3
	rename  wj9113 y_Pa3
	rename  wj9114 y_Po3
	rename  wj9115 y_Pn3
	
	recode y_Pc2 y_Pe3 y_Pa1 y_Pn1 y_Pn2 (7=1) (6=2) (5=3) (4=4) (3=5) (2=6) (1=7)
	label define bf 1 "Trifft voll zu" 7 "Trifft berhaupt nicht zu"
	label values y_Pc2 bf
	label values y_Pe3 bf
	label values y_Pa1 bf
	label values y_Pn1 bf
	label values y_Pn2 bf
	
	gen y_erhebj=2006
	keep hhnr persnr y_P*
	sort hhnr persnr 
	save "$datapatha\youth_P06.dta", replace
		
	use "$datapath\xpage17.dta", clear
	rename  xj9101 y_Pc1
	rename  xj9102 y_Pe1
	rename  xj9103 y_Pa1
	rename  xj9104 y_Po1
	rename  xj9105 y_Pn1
	rename  xj9106 y_Pa2
	rename  xj9107 y_Pc2
	rename  xj9108 y_Pe2
	rename  xj9109 y_Po2
	rename  xj9110 y_Pn2
	rename  xj9111 y_Pc3
	rename  xj9112 y_Pe3
	rename  xj9113 y_Pa3
	rename  xj9114 y_Po3
	rename  xj9115 y_Pn3
	
	recode y_Pc2 y_Pe3 y_Pa1 y_Pn1 y_Pn2 (7=1) (6=2) (5=3) (4=4) (3=5) (2=6) (1=7)
	label values y_Pc2 bf
	label values y_Pe3 bf
	label values y_Pa1 bf
	label values y_Pn1 bf
	label values y_Pn2 bf
	
	gen y_erhebj=2007	
	keep hhnr persnr y_P*
	sort hhnr persnr 
	save "$datapatha\youth_P07.dta", replace	
		
	use "$datapath\ypage17.dta", clear
	rename  yj9101 y_Pc1
	rename  yj9102 y_Pe1
	rename  yj9103 y_Pa1
	rename  yj9104 y_Po1
	rename  yj9105 y_Pn1
	rename  yj9106 y_Pa2
	rename  yj9107 y_Pc2
	rename  yj9108 y_Pe2
	rename  yj9109 y_Po2
	rename  yj9110 y_Pn2
	rename  yj9111 y_Pc3
	rename  yj9112 y_Pe3
	rename  yj9113 y_Pa3
	rename  yj9114 y_Po3
	rename  yj9115 y_Pn3
	
	recode y_Pc2 y_Pe3 y_Pa1 y_Pn1 y_Pn2 (7=1) (6=2) (5=3) (4=4) (3=5) (2=6) (1=7)
	label values y_Pc2 bf
	label values y_Pe3 bf
	label values y_Pa1 bf
	label values y_Pn1 bf
	label values y_Pn2 bf
	
	gen y_erhebj=2008
	keep hhnr persnr y_P*
	sort hhnr persnr 
	save "$datapatha\youth_P08.dta", replace
	
	use "$datapath\zpage17.dta", clear
	rename  zj9101 y_Pc1
	rename  zj9102 y_Pe1
	rename  zj9103 y_Pa1
	rename  zj9104 y_Po1
	rename  zj9105 y_Pn1
	rename  zj9106 y_Pa2
	rename  zj9107 y_Pc2
	rename  zj9108 y_Pe2
	rename  zj9109 y_Po2
	rename  zj9110 y_Pn2
	rename  zj9111 y_Pc3
	rename  zj9112 y_Pe3
	rename  zj9113 y_Pa3
	rename  zj9114 y_Po3
	rename  zj9115 y_Pn3
	
	recode y_Pc2 y_Pe3 y_Pa1 y_Pn1 y_Pn2 (7=1) (6=2) (5=3) (4=4) (3=5) (2=6) (1=7)
	label values y_Pc2 bf
	label values y_Pe3 bf
	label values y_Pa1 bf
	label values y_Pn1 bf
	label values y_Pn2 bf
		
	gen y_erhebj=2009
	keep hhnr persnr y_P*
	sort hhnr persnr 
	save "$datapatha\youth_P09.dta", replace
	
	use "$datapath\bapage17.dta", clear
	rename  baj9101 y_Pc1
	rename  baj9102 y_Pe1
	rename  baj9103 y_Pa1
	rename  baj9104 y_Po1
	rename  baj9105 y_Pn1
	rename  baj9106 y_Pa2
	rename  baj9107 y_Pc2
	rename  baj9108 y_Pe2
	rename  baj9109 y_Po2
	rename  baj9110 y_Pn2
	rename  baj9111 y_Pc3
	rename  baj9112 y_Pe3
	rename  baj9113 y_Pa3
	rename  baj9114 y_Po3
	rename  baj9115  y_Pn3
	
	recode y_Pc2 y_Pe3 y_Pa1 y_Pn1 y_Pn2 (7=1) (6=2) (5=3) (4=4) (3=5) (2=6) (1=7)
	label values y_Pc2 bf
	label values y_Pe3 bf
	label values y_Pa1 bf
	label values y_Pn1 bf
	label values y_Pn2 bf
		
	gen y_erhebj=2010
	keep hhnr persnr y_P*
	sort hhnr persnr 
	save "$datapatha\youth_P10.dta", replace
		
********Get information on cognitive skills of the youths*************************************
	use "$datapath\cogdj.dta", clear
	local cogvars analog rechenz matrize
	foreach var of local cogvars{
	rename `var' y_`var'
	}
	keep hhnr persnr y_*
	sort hhnr persnr y_*	 
	save "$datapatha\youth_cog.dta", replace
	
*********use the youth data and rename some variables*********************
	use "$datapath\bioage17.dta", clear
	local locvars  sverl serre sglue sand shart szwei ssozu sfaeh skntr senga
	foreach var of local locvars{
	rename bye`var' `var'
	rename `var' yLoc_`var'
	}
	renpfix by y_
	rename erhebj y_erhebj
	gen youth=1
	lab var youth "Individual is in youth dataset"
	sort hhnr persnr youth
	save "$datapatha\youth.dta", replace
	cap saveold "$datapatha\youth.dta", replace
	
	
*******MERGE********************************************************************************	
*Note when merging, all youths are already in the adult dataset because the bioparen file contains all youths as well
	merge hhnr persnr using "$datapatha\adults.dta"
	drop _merge	
	replace b_age=18 if y_erhebj==2010
	replace b_age=17 if y_erhebj==2011
	forvalues x=6/9{
	sort hhnr persnr
	merge hhnr persnr using "$datapatha\youth_P0`x'.dta", update
	erase "$datapatha\youth_P0`x'.dta"
	drop _merge
	}
	sort hhnr persnr
	merge hhnr persnr using "$datapatha\youth_P10.dta", update
	erase "$datapatha\youth_P10.dta"
	drop _merge
	sort hhnr persnr
	merge hhnr persnr using "$datapatha\youth_cog.dta", update
	erase "$datapatha\youth_cog.dta"
	drop _merge
	
*generate a variable for when an individual is both in the youth and in the adult dataset

	gen ya=0
	replace ya=1 if youth==1 & sample1!=.
	lab var ya "person in both the youth and the adult dataset"

****merge with the number of siblings that was generated from the "kind" files************************
local cdatafiles pnrsibs qnrsibs rnrsibs snrsibs tnrsibs unrsibs vnrsibs wnrsibs xnrsibs ynrsibs znrsibs banrsibs
	cap drop _merge
	cd "$datapatha"
	sort hhnr persnr
	foreach var of local cdatafiles{
	merge hhnr persnr using `var'.dta
	erase "`var'.dta"
      sort hhnr persnr 
	drop _merge
	}

*****************************allocate number of siblings and sex of the child***************************************************															
	gen y_nrsibs=.
	gen y_sex=.
	sort hhnr
	replace y_nrsibs=y_nrsibs00 if y_erhebj==2000
	replace y_sex=y_sex00 if y_erhebj==2000

	local t=0
	forvalues x=1/9{
	sort hhnr
	replace y_nrsibs=y_nrsibs0`t' if y_erhebj==200`x' & y_nrsibs==.
	replace y_sex=y_sex0`t' if y_erhebj==200`x' & y_sex==.
	drop y_nrsibs0`t'
	drop y_sex0`t'
	lab var y_sex "Gender of young adult"
	lab var y_nrsibs "Number of siblings of young adult"
	local t=`t'+1
	}
	
	sort hhnr
	replace y_nrsibs=y_nrsibs010 if y_erhebj==2010 & y_nrsibs==.
	replace y_sex=y_sex010 if y_erhebj==2010 & y_sex==.
	drop y_nrsibs010
	drop y_sex010

	replace b_sex=y_sex if b_sex==. & y_sex!=.
	
**************************************************allocate BULA*************************************************************************
	gen y_bula=.
	sort hhnr
	replace y_bula=b_bula
	lab var y_bula "region living in at time of interview"
	forvalues x=1/16{
	gen y_bula`x'=0
	replace y_bula`x'=1 if y_bula==`x'
	lab var y_bula`x' "dummy for region living in at time of interview"
	}

*************************replace all don't knows and no answers with missings******************************************************************
	qui mvdecode _all, mv(-1=.a \ -2=.b \ -3=.c) 

*****************************************************PARENTAL EDUCATION*************************************************************************************
sort youth

*generate mother's and father's education 
	replace y_mnr=persnr if y_mnr==.
	replace y_vnr=persnr if y_vnr==.

	gen y_meduc=.
	gen y_munemp=.
	sort y_mnr youth
	forvalues x=1/12{
	replace y_meduc=o_educ[_n-`x'] if youth==1 & youth[_n-`x']==0 & y_mnr==y_mnr[_n-`x'] & (y_meduc>o_educ[_n-`x'])
	replace y_munemp=o_unemp[_n-`x'] if youth==1 & youth[_n-`x']==0 & y_mnr==y_mnr[_n-`x'] & (y_munemp>o_unemp[_n-`x'])
	}
	lab var y_meduc "Maternal education"
	lab var y_munemp "Mother unemployed"

	gen y_feduc=.
	gen y_funemp=.
	sort y_vnr youth
	forvalues x=1/12{
	replace y_feduc=o_educ[_n-`x'] if youth==1 & youth[_n-`x']==0 & y_vnr==y_vnr[_n-`x'] & (y_feduc>o_educ[_n-`x'])
	replace y_funemp=o_unemp[_n-`x'] if youth==1 & youth[_n-`x']==0 & y_vnr==y_vnr[_n-`x'] & (y_funemp>o_unemp[_n-`x'])
	}
	lab var y_feduc "Paternal education"
	lab var y_funemp "Father unemployed"

*generate dummies for parental education
	
	forvalues x=1/4{
	gen y_feduc`x'=0
	replace y_feduc`x'=1 if y_feduc==`x' 
	replace y_feduc`x'=. if y_feduc==.
	lab var y_feduc`x' "father's education dummy"
	}

	forvalues x=1/4{
	gen y_meduc`x'=0
	replace y_meduc`x'=1 if y_meduc==`x' 
	replace y_meduc`x'=. if y_meduc==.
	lab var y_meduc`x' "mother's education dummy"
	}

*******************************************************************Broken**************************************************************************
	*proxy broken home by whether the father/mother is important in life
	gen y_broken=0
	replace y_broken=1 if (y_wiva>3 | y_wimu>3) & (y_wiva!=. & y_wimu!=.)
	replace y_broken=. if y_wiva==. | y_wimu==.
	lab var y_broken "either father or mother is not important in life"

***************************************************generate a dummy for the year in which the youth were 17*************************
	forvalues x=0/9{
	gen y_erhebj0`x'=0
	replace y_erhebj0`x'=1 if y_erhebj==200`x'
	lab var y_erhebj0`x' "youth was 17 in 200`x'"
	}

	forvalues x=10/11{	
	gen y_erhebj`x'=0
	replace y_erhebj`x'=1 if y_erhebj==20`x'
	lab var y_erhebj`x' "youth was 17 in 20`x'"
	}
	
****************************************************************************************************************************************
***************************************************************************************************************************************************************************+
********************************************************************code CURRENT schooling for the youth*********************************************************************
	gen yact_educ=.
	replace yact_educ=1 if y_schbes==4 | y_schbes==5 | y_schabs==5
	replace yact_educ=2 if y_schbes==1 | y_schabs==1 | y_schabs==6
	replace yact_educ=3 if y_schbes==2 | y_schabs==2 
	replace yact_educ=4 if y_schbes==3 | y_schabs==3 | y_schabs==4

	label define yacteduc 1 "Other" 2 "Haupt/drop" 3 "Reals/Mitt" 4 "Gymnasium"
	lab values yact_educ yacteduc

	forvalues x=1/4{
	gen yact_educ`x'=0
	replace yact_educ`x'=1 if yact_educ==`x'
	replace yact_educ`x'=. if yact_educ==.
	}

	lab var yact_educ1 "Other school"
	lab var yact_educ2 "Hauptschule/Hauptschulabschluss"
	lab var yact_educ3 "Realschulabschluss/Mittlere Reife or Realschule"
	lab var yact_educ4 "Abitur/Fachhochschulreife or Gymnasium"

******************************************************************************************************************************************************************************
	gen yo_educ=.
	replace yo_educ=1 if yact_educ==2
	replace yo_educ=2 if yact_educ==3
	replace yo_educ=3 if yact_educ==4
	replace yo_educ=1 if y_schzar==1 | y_schabs==6
	replace yo_educ=2 if y_schzar==2 
	replace yo_educ=3 if y_schzar==3 & (yact_educ==3| yact_educ==4 | yact_educ==1)
	replace yo_educ=4 if ((yact_educ==1 | yact_educ==4) & y_zafh==1) | ((yact_educ==1 | yact_educ==4) & y_zauni==1)
	replace yo_educ=4 if (yo_educ==3 & y_zafh==1) | ((yact_educ==1 | yact_educ==4) & y_zauni==1)

	forvalues x=1/4{
	gen yo_educ_`x'=0
	replace yo_educ_`x'=1 if yo_educ==`x'
	replace yo_educ_`x'=. if yo_educ==.
	}
	
	lab var yo_educ_1 "Hauptschule/dropout planned"
	lab var yo_educ_2 "Realschulabschluss/Mittlere Reife planned"
	lab var yo_educ_3 "Abitur/Fachhochschulreife planned"
	lab var yo_educ_4 "Uni/Fachhochschul degree aspired"

	label define yeduc 1 "Hauptschule/drop" 2 "Realschule/Mitt" 3 "Abitur/FHreif" 4 "Uni/FH"
	label values yo_educ yeduc
	
************************************************************code only two levels of education for bot adults and youths (FH/UNI and less)****************************
	gen o_fhuni_all=.
	replace o_fhuni_all=1 if (o_casmin==6 | o_casmin==7 | o_casmin==8 | o_casmin==9) & youth==0
	replace o_fhuni_all=0 if (o_casmin==2 | o_casmin==3 | o_casmin==4 | o_casmin==5) & youth==0	
	replace o_fhuni_all=1 if (o_casmin==6 | o_casmin==7 | o_casmin==8 | o_casmin==9) & youth==1
	replace o_fhuni_all=0 if (o_casmin==2 | o_casmin==3 | o_casmin==4 | o_casmin==5) & youth==1
	replace o_fhuni_all=0 if y_schzar==2 | y_schzar==1  & youth==1 & o_fhuni_all==.
	replace o_fhuni_all=1 if (y_schzar==3 | y_schzar==4)  & youth==1 & o_fhuni_all==.
	
	gen o_educ3_1=0
	replace o_educ3_1=1 if o_fhuni_all==0

	gen o_educ3_2=0
	replace o_educ3_2=1 if o_fhuni_all==1
	
***************************************************************************************************************************************************++

	gen y_gymempfeh=0
	replace y_gymempfeh=1 if y_empfeh==3
	replace y_gymempfeh=. if y_empfeh==.
	lab var y_gymempfeh "Empfehlung fr das Gymnasium"
	
	gen y_hauptempfeh=0
	replace y_hauptempfeh=1 if y_empfeh==1
	replace y_hauptempfeh=. if y_empfeh==.
	lab var y_hauptempfeh "Empfehlung fr die Hauptschule"
	
************************************************************************************************************************************+

**************************recode the answers from 2006/2007 *(The scale for locus of control was changed then)************************************************************
	local yloc yLoc_sverl yLoc_serre yLoc_sglue yLoc_sand yLoc_shart yLoc_szwei yLoc_ssozu yLoc_sfaeh yLoc_skntr yLoc_senga

	foreach var of varlist yLoc_sverl yLoc_serre yLoc_sglue yLoc_shart yLoc_sand yLoc_ssozu yLoc_sfaeh yLoc_skntr yLoc_senga {
	gen `var'o=`var' 
	local l`var' : variable label `var'
	label var `var'o "`l`var'', old coding"
	
	replace `var'=11 if `var'==7 | `var'==6
	replace `var'=12 if `var'==5 | `var'==4
	replace `var'=13 if `var'==3 | `var'==2
	replace `var'=14 if `var'==1

	replace `var'=1 if `var'==14 
	replace `var'=2 if `var'==13 
	replace `var'=3 if `var'==12 
	replace `var'=4 if `var'==11 
	}

	foreach var of varlist yLoc_szwei {
	replace `var'=11 if `var'==7 
	replace `var'=12 if `var'==6 | `var'==5
	replace `var'=13 if `var'==4 | `var'==3
	replace `var'=14 if `var'==2 | `var'==1

	replace `var'=1 if `var'==14 
	replace `var'=2 if `var'==13 
	replace `var'=3 if `var'==12 
	replace `var'=4 if `var'==11 
	}

	label define loc 1 "disagree completely" 4 "agree completely"
	foreach var of varlist yLoc_sverl yLoc_serre yLoc_sglue yLoc_shart yLoc_sand yLoc_ssozu yLoc_sfaeh yLoc_skntr yLoc_senga yLoc_szwei{		
	label values `var' loc
	}
	
*This is recoding all adults that otherwise have no obs in one of the answer categories (THIS IS FOR THE ADULT ESTIMATION WITH 7 CATEGORIES)
	foreach var of varlist Loc1 Loc9{	
	replace `var'=1 if `var'==2
	replace `var'=2 if `var'==3
	replace `var'=3 if `var'==4
	replace `var'=4 if `var'==5
	replace `var'=5 if `var'==6
	replace `var'=6 if `var'==7
	}
	
	foreach var of varlist Loc6{	
	replace `var'=1 if `var'==3
	replace `var'=2 if `var'==4
	replace `var'=3 if `var'==5
	replace `var'=4 if `var'==6
	replace `var'=5 if `var'==7
	}

**	
	foreach var of varlist Loc10{	
	replace `var'=6 if `var'==7
	}

*replace the b_age variable with info in case it is missing. 
	replace b_age=(2011-y_erhebj)+17 if youth==1 & b_age==.
	replace b_cohort1=1 if b_age>=26 & b_age<36
*we have some missings for the marriage variable in the youth sample and we assume they are not married	
	replace b_married=0 if b_married==.

*assign a zero to the cohort dummies if we are dealing with a youth

	replace b_age26_30=0 if youth==1
	replace b_age31_35=0 if youth==1
	replace b_age36_40=0 if youth==1

*generate agesq
gen b_agesq=b_age*b_age/100
	
*generate variables common to the youth and the adult sample (for the schooling equation)

	gen nr_siblings_all=.
	replace nr_siblings_all=b_nrsiblings if youth==0
	replace nr_siblings_all=y_nrsibs if youth==1
	replace nr_siblings_all=b_nrsiblings if youth==1 & nr_siblings_all==. 

*generate one variable for bundesland
	replace b_bula_all=y_bula if youth==1

	
*generate regions (south: Bavaria, Baden-Wrttemberg / north: Berlin, Bremen, Hamburg, Niedersachsen, SH // West: Hessen, NRW, RP, Saarl. //East: Brandenburg, Meck-Pomm, Saxionia, Sachsen-Anhalt, Thringen)
	gen south=0    
	replace south=1 if b_bula_all<3
	replace south=. if b_bula_all==.
	gen north=0
	replace north=1 if b_bula_all==3 | b_bula_all==5 | b_bula_all==6 | b_bula_all==9 | b_bula_all==15 
	replace north=. if b_bula_all==.
	gen west=0
	replace west=1 if b_bula_all==7 | b_bula_all==10 | b_bula_all==11 | b_bula_all==12 
	replace west=. if b_bula_all==.
	gen east=0
	replace east=1 if b_bula_all==4 | b_bula_all==8 | b_bula_all==13 | b_bula_all==14 | b_bula_all==16 
	replace east=. if b_bula_all==.
	
*replace b_eduwest variable with info from youth questionnaire for oyuth
	replace b_eduwest=. if youth==1
	replace b_eduwest=1 if east==0 & youth==1
	replace b_eduwest=0 if east==1 & youth==1
	
***********

*******************************************add unemployment rate in Bundesland in 2007***********************************
	/*source: Arbeitslosigkeit im Zeitverlauf, 2009, (bezogen auf alle zivilen Erwerbspersonen - in Prozent)
	Bundesagentur fr Arbeit*/	

      /*Bulanr		15	6	9	5	10	7	11	12	1	2	8	4	3	14	16	13	
	year	D	SH	H	Nie	Bre	NRW	Hes	RP	Saarl	BW	Bay	MVP	Bran	Ber	SA	Thr	Sach	
	2004	10.5  	9.8  	9.7  	9.6  	13.2  	10.2  	8.2  	7.7  	9.2  	6.2  	6.9  	20.4  	18.7  	17.7  	20.3  	16.7  	17.8  
	2005	11.7  	11.6  	11.3  	11.6  	16.8  	12.0  	9.7  	8.8  	10.7  	7.0  	7.8  	20.3  	18.2  	19.0  	20.2  	17.1  	18.3  
	2006	10.8  	10.0  	11.0  	10.5  	14.9  	11.4  	9.2  	8.0  	9.9  	6.3  	6.8  	19.0  	17.0  	17.5  	18.3  	15.6  	17.0  
	2007	9.0  	8.4  	9.2  	8.9  	12.7  	9.5  	7.6  	6.5  	8.4  	4.9  	5.3  	16.5  	14.9  	15.5  	16.0  	13.2  	14.7  
	2008	7.8  	7.6  	8.1  	7.7  	11.4  	8.5  	6.6  	5.6  	7.3  	4.1  	4.2  	14.1  	13.0  	13.9  	14.0  	11.2  	12.8  
	2009	8.2  	7.8  	8.6  	7.8  	11.8  	8.9  	6.8  	6.1  	7.7  	5.1  	4.8  	13.5  	12.3  	14.1  	13.6  	11.4  	12.9  
	2010 	7.7     7.5     8.2     7.5     12      8.7     6.4     5.7     7.5     4.9     4.5     12.7    12      13.6    12.5    9.8     11.8
	2011	7.1  	7.2  	7.8  	6.9  	11.6  	8.1  	5.9  	5.3  	6.8  	4.0  	3.8  	12.5  	10.7  	13.3  	11.6  	8.8  	10.6*/  																		


	gen b_unemprate=.
	
	replace b_unemprate=4.0 if b_bula==1	   & b_unemprate==.  &  o_bulainfo==11
	replace b_unemprate=3.8 if b_bula==2	   & b_unemprate==.  &  o_bulainfo==11 
	replace b_unemprate=13.3 if b_bula==3	   & b_unemprate==.  &  o_bulainfo==11 
	replace b_unemprate=10.7 if b_bula==4	   & b_unemprate==.  &  o_bulainfo==11 
	replace b_unemprate=11.6 if b_bula==5	   & b_unemprate==.  &  o_bulainfo==11 
	replace b_unemprate=7.8 if b_bula==6	   & b_unemprate==.  &  o_bulainfo==11 
	replace b_unemprate=5.9 if b_bula==7	   & b_unemprate==.  &  o_bulainfo==11 
	replace b_unemprate=12.5 if b_bula==8	   & b_unemprate==.  &  o_bulainfo==11 
	replace b_unemprate=6.9 if b_bula==9	   & b_unemprate==.  &  o_bulainfo==11 
	replace b_unemprate=8.1 if b_bula==10	   & b_unemprate==.  &  o_bulainfo==11 
	replace b_unemprate=5.3 if b_bula==11	   & b_unemprate==.  &  o_bulainfo==11 
	replace b_unemprate=6.8 if b_bula==12	   & b_unemprate==.  &  o_bulainfo==11 
	replace b_unemprate=10.6 if b_bula==13   & b_unemprate==.  &  o_bulainfo==11
	replace b_unemprate=11.6 if b_bula==14   & b_unemprate==.  &  o_bulainfo==11
	replace b_unemprate=7.5 if b_bula==15	   & b_unemprate==.  &  o_bulainfo==11
	replace b_unemprate=8.8 if b_bula==16    & b_unemprate==.  &  o_bulainfo==11		
	
	replace b_unemprate=4.9 if b_bula==1	   & b_unemprate==.  &  o_bulainfo==10
	replace b_unemprate=4.5 if b_bula==2	   & b_unemprate==.  &  o_bulainfo==10 
	replace b_unemprate=13.6 if b_bula==3	   & b_unemprate==.  &  o_bulainfo==10 
	replace b_unemprate=12 if b_bula==4	     & b_unemprate==.  &  o_bulainfo==10 
	replace b_unemprate=12 if b_bula==5	     & b_unemprate==.  &  o_bulainfo==10 
	replace b_unemprate=8.2 if b_bula==6	   & b_unemprate==.  &  o_bulainfo==10 
	replace b_unemprate=6.4 if b_bula==7	   & b_unemprate==.  &  o_bulainfo==10 
	replace b_unemprate=12.7 if b_bula==8	   & b_unemprate==.  &  o_bulainfo==10 
	replace b_unemprate=7.5 if b_bula==9	   & b_unemprate==.  &  o_bulainfo==10 
	replace b_unemprate=8.7 if b_bula==10	   & b_unemprate==.  &  o_bulainfo==10 
	replace b_unemprate=5.7 if b_bula==11	   & b_unemprate==.  &  o_bulainfo==10 
	replace b_unemprate=7.5 if b_bula==12	   & b_unemprate==.  &  o_bulainfo==10 
	replace b_unemprate=11.8 if b_bula==13   & b_unemprate==.  &  o_bulainfo==10
	replace b_unemprate=12.5 if b_bula==14   & b_unemprate==.  &  o_bulainfo==10
	replace b_unemprate=7.5 if b_bula==15	   & b_unemprate==.  &  o_bulainfo==10
	replace b_unemprate=9.8 if b_bula==16    & b_unemprate==.  &  o_bulainfo==10	
	
	replace b_unemprate=5.1 if b_bula==1	   & b_unemprate==.  &  o_bulainfo==9
	replace b_unemprate=4.8 if b_bula==2	   & b_unemprate==.  &  o_bulainfo==9 
	replace b_unemprate=14.1 if b_bula==3	   & b_unemprate==.  &  o_bulainfo==9 
	replace b_unemprate=12.3 if b_bula==4	   & b_unemprate==.  &  o_bulainfo==9 
	replace b_unemprate=11.8 if b_bula==5	   & b_unemprate==.  &  o_bulainfo==9 
	replace b_unemprate=8.6 if b_bula==6	   & b_unemprate==.  &  o_bulainfo==9 
	replace b_unemprate=6.8 if b_bula==7	   & b_unemprate==.  &  o_bulainfo==9 
	replace b_unemprate=13.5 if b_bula==8	   & b_unemprate==.  &  o_bulainfo==9 
	replace b_unemprate=7.8 if b_bula==9	   & b_unemprate==.  &  o_bulainfo==9 
	replace b_unemprate=8.9 if b_bula==10	   & b_unemprate==.  &  o_bulainfo==9 
	replace b_unemprate=6.1 if b_bula==11	   & b_unemprate==.  &  o_bulainfo==9 
	replace b_unemprate=7.7 if b_bula==12	   & b_unemprate==.  &  o_bulainfo==9 
	replace b_unemprate=12.9 if b_bula==13   & b_unemprate==.  &  o_bulainfo==9
	replace b_unemprate=13.6 if b_bula==14   & b_unemprate==.  &  o_bulainfo==9
	replace b_unemprate=7.8 if b_bula==15	   & b_unemprate==.  &  o_bulainfo==9
	replace b_unemprate=11.4 if b_bula==16   & b_unemprate==.  &  o_bulainfo==9

	replace b_unemprate=4.1 if b_bula==1	   & b_unemprate==.  &  o_bulainfo==8
	replace b_unemprate=4.2 if b_bula==2	   & b_unemprate==.  &  o_bulainfo==8 
	replace b_unemprate=13.9 if b_bula==3	   & b_unemprate==.  &  o_bulainfo==8 
	replace b_unemprate=13.0 if b_bula==4	   & b_unemprate==.  &  o_bulainfo==8 
	replace b_unemprate=11.4 if b_bula==5	   & b_unemprate==.  &  o_bulainfo==8 
	replace b_unemprate=8.1 if b_bula==6	   & b_unemprate==.  &  o_bulainfo==8 
	replace b_unemprate=6.6 if b_bula==7	   & b_unemprate==.  &  o_bulainfo==8 
	replace b_unemprate=14.1 if b_bula==8	   & b_unemprate==.  &  o_bulainfo==8 
	replace b_unemprate=7.7 if b_bula==9	   & b_unemprate==.  &  o_bulainfo==8 
	replace b_unemprate=8.5 if b_bula==10	   & b_unemprate==.  &  o_bulainfo==8 
	replace b_unemprate=5.6 if b_bula==11	   & b_unemprate==.  &  o_bulainfo==8 
	replace b_unemprate=7.3 if b_bula==12	   & b_unemprate==.  &  o_bulainfo==8 
	replace b_unemprate=12.8 if b_bula==13   & b_unemprate==.  &  o_bulainfo==8
	replace b_unemprate=14.0 if b_bula==14   & b_unemprate==.  &  o_bulainfo==8
	replace b_unemprate=7.6 if b_bula==15	   & b_unemprate==.  &  o_bulainfo==8
	replace b_unemprate=11.2 if b_bula==16   & b_unemprate==.  &  o_bulainfo==8

	replace b_unemprate=4.9 if b_bula==1	   & b_unemprate==.  &  o_bulainfo==7
	replace b_unemprate=5.3 if b_bula==2	   & b_unemprate==.  &  o_bulainfo==7 
	replace b_unemprate=15.5 if b_bula==3	   & b_unemprate==.  &  o_bulainfo==7 
	replace b_unemprate=14.9 if b_bula==4	   & b_unemprate==.  &  o_bulainfo==7 
	replace b_unemprate=12.7 if b_bula==5	   & b_unemprate==.  &  o_bulainfo==7 
	replace b_unemprate=9.2 if b_bula==6	   & b_unemprate==.  &  o_bulainfo==7 
	replace b_unemprate=7.6 if b_bula==7	   & b_unemprate==.  &  o_bulainfo==7 
	replace b_unemprate=16.5 if b_bula==8	   & b_unemprate==.  &  o_bulainfo==7 
	replace b_unemprate=8.9 if b_bula==9	   & b_unemprate==.  &  o_bulainfo==7 
	replace b_unemprate=9.5 if b_bula==10	   & b_unemprate==.  &  o_bulainfo==7 
	replace b_unemprate=6.5 if b_bula==11	   & b_unemprate==.  &  o_bulainfo==7 
	replace b_unemprate=8.4 if b_bula==12	   & b_unemprate==.  &  o_bulainfo==7 
	replace b_unemprate=14.7 if b_bula==13   & b_unemprate==.  &  o_bulainfo==7
	replace b_unemprate=16.0 if b_bula==14   & b_unemprate==.  &  o_bulainfo==7
	replace b_unemprate=8.4 if b_bula==15	   & b_unemprate==.  &  o_bulainfo==7
	replace b_unemprate=13.2 if b_bula==16   & b_unemprate==.  &  o_bulainfo==7
	
	replace b_unemprate=6.3 if b_bula==1 	 & b_unemprate==.   &  o_bulainfo==6
	replace b_unemprate=6.8 if b_bula==2 	 & b_unemprate==.   &  o_bulainfo==6 
	replace b_unemprate=17.5 if b_bula==3	 & b_unemprate==.   &  o_bulainfo==6 
	replace b_unemprate=17.0 if b_bula==4	 & b_unemprate==.   &  o_bulainfo==6 
	replace b_unemprate=14.9 if b_bula==5	 & b_unemprate==.   &  o_bulainfo==6 
	replace b_unemprate=11.0 if b_bula==6	 & b_unemprate==.   &  o_bulainfo==6 
	replace b_unemprate=9.2 if b_bula==7 	 & b_unemprate==.   &  o_bulainfo==6 
	replace b_unemprate=19.0 if b_bula==8	 & b_unemprate==.   &  o_bulainfo==6 
	replace b_unemprate=10.5 if b_bula==9	 & b_unemprate==.   &  o_bulainfo==6 
	replace b_unemprate=11.4 if b_bula==10 & b_unemprate==.	  &  o_bulainfo==6 
	replace b_unemprate=8.0 if b_bula==11	 & b_unemprate==.   &  o_bulainfo==6 
	replace b_unemprate=9.9 if b_bula==12	 & b_unemprate==.   &  o_bulainfo==6 
	replace b_unemprate=17.0 if b_bula==13 & b_unemprate==.	  &  o_bulainfo==6
	replace b_unemprate=18.3 if b_bula==14 & b_unemprate==.	  &  o_bulainfo==6
	replace b_unemprate=10.0 if b_bula==15 & b_unemprate==.	  &  o_bulainfo==6
	replace b_unemprate=15.6 if b_bula==16 & b_unemprate==.	  &  o_bulainfo==6
	
	replace b_unemprate=7.0 if b_bula==1	 & b_unemprate==.   &  o_bulainfo==5
	replace b_unemprate=7.8 if b_bula==2	 & b_unemprate==.   &  o_bulainfo==5 
	replace b_unemprate=19.0 if b_bula==3	 & b_unemprate==.   &  o_bulainfo==5 
	replace b_unemprate=18.2 if b_bula==4	 & b_unemprate==.   &  o_bulainfo==5 
	replace b_unemprate=16.8 if b_bula==5	 & b_unemprate==.   &  o_bulainfo==5 
	replace b_unemprate=11.3 if b_bula==6	 & b_unemprate==.   &  o_bulainfo==5 
	replace b_unemprate=9.7 if b_bula==7	 & b_unemprate==.   &  o_bulainfo==5 
	replace b_unemprate=20.3 if b_bula==8	 & b_unemprate==.   &  o_bulainfo==5 
	replace b_unemprate=11.6 if b_bula==9	 & b_unemprate==.   &  o_bulainfo==5 
	replace b_unemprate=12.0 if b_bula==10 & b_unemprate==.   &  o_bulainfo==5 
	replace b_unemprate=8.8 if b_bula==11	 & b_unemprate==.   &  o_bulainfo==5 
	replace b_unemprate=10.7 if b_bula==12 & b_unemprate==.   &  o_bulainfo==5 
	replace b_unemprate=18.3 if b_bula==13 & b_unemprate==.   &  o_bulainfo==5
	replace b_unemprate=20.2 if b_bula==14 & b_unemprate==.   &  o_bulainfo==5
	replace b_unemprate=11.6 if b_bula==15 & b_unemprate==.   &  o_bulainfo==5
	replace b_unemprate=17.1 if b_bula==16 & b_unemprate==.   &  o_bulainfo==5
	
	lab var b_unemprate "unemployment rate per Bundesland"
	replace b_unemprate=6.2 if b_bula==1	 & b_unemprate==.   &  o_bulainfo<5
	replace b_unemprate=6.9 if b_bula==2	 & b_unemprate==.   &  o_bulainfo<5 
	replace b_unemprate=17.7 if b_bula==3	 & b_unemprate==.   &  o_bulainfo<5 
	replace b_unemprate=18.7 if b_bula==4	 & b_unemprate==.   &  o_bulainfo<5 
	replace b_unemprate=13.2 if b_bula==5	 & b_unemprate==.   &  o_bulainfo<5 
	replace b_unemprate=9.7 if b_bula==6	 & b_unemprate==.   &  o_bulainfo<5
	replace b_unemprate=8.2 if b_bula==7	 & b_unemprate==.   &  o_bulainfo<5
	replace b_unemprate=20.4 if b_bula==8	 & b_unemprate==.   &  o_bulainfo<5 
	replace b_unemprate=9.6 if b_bula==9	 & b_unemprate==.   &  o_bulainfo<5 
	replace b_unemprate=10.2 if b_bula==10 & b_unemprate==.   &  o_bulainfo<5 
	replace b_unemprate=7.7 if b_bula==11	 & b_unemprate==.   &  o_bulainfo<5 
	replace b_unemprate=9.2 if b_bula==12	 & b_unemprate==.   &  o_bulainfo<5 
	replace b_unemprate=17.8 if b_bula==13 & b_unemprate==.   &  o_bulainfo<5
	replace b_unemprate=20.3 if b_bula==14 & b_unemprate==.   &  o_bulainfo<5
	replace b_unemprate=9.8 if b_bula==15	 & b_unemprate==.   &  o_bulainfo<5
	replace b_unemprate=16.7 if b_bula==16 & b_unemprate==.   &  o_bulainfo<5

*Unemployment rate since 1950 for education decision
#delimit;
	local c=2011;
	foreach x of numlist 7.1 7.7 8.2 7.2 8.4 10.2 11 9.4 9.3 8.5 8 8.4 9.6
	10.3 10.8 9.9 9.1 9 8 6.4 6.2 7.2 7.9 8.7 8.9 9 9.3 9.1 9.1 7.5 5.5
	3.8 3.8 4.3 4.5 4.6 4.7 2.6 1.2 1.1 0.8 0.7 0.9 1.5 2.1 0.7 0.7 0.8
	0.8 0.7 0.8 1.3 2.6 3.7 3.7 4.4 5.6 7.6 8.4 9.5 10.4 11 
	{;
	gen unemp_`c'=`x';
	local c=`c'-1;
	};

#delimit cr
*

	gen unemp_edu=.
	foreach x of numlist 1950/2011{
	replace unemp_edu=unemp_`x' if `x'==2011-b_age+17
	}
	
	replace o_lmparta=0 if o_empst==9

/**********************************give shorter variable names to youth locus of control for desriptives later on****************************************/

	gen  Q1 = yLoc_sverl
	gen  Q2 = yLoc_serre
	gen  Q3 = yLoc_sglue
	gen  Q4 = yLoc_sand 
	gen  Q5 = yLoc_shart
	gen  Q6 = yLoc_szwei
	gen  Q7 = yLoc_ssozu
	gen  Q8 = yLoc_sfaeh
	gen  Q9 = yLoc_skntr
	gen  Q10=yLoc_senga

	lab var Q1  "My life's course depends on me"
	lab var Q2  "I have not achieved what I deserve"
	lab var Q3  "Success is a matter of fate or luck"
	lab var Q4  "Others decide about my life"
	lab var Q5  "Success is a matter of hard work" 
	lab var Q6  "In case of difficulties, doubts about own abilities"
	lab var Q7  "Possibilities in life depend on social conditions"
	lab var Q8  "Abilities are more important than effort"
	lab var Q9  "Little control over what happens to me"
	lab var Q10 "Social involvement can help influence social conditions"

/***********************************generate separate schooling variables for later descriptive statistics***********************************************************************/
	/*generate separate schooling variables for males/females adult/youths*/
	gen fyschooling=.
	replace fyschooling=o_fhuni_all if youth==1 & b_sex==2 & b_eduwest==1
	lab var fyschooling "female youth schooling"
	gen myschooling=.
	replace myschooling=o_fhuni_all if youth==1 & b_sex==1 & b_eduwest==1	
         lab var myschooling "male youth schooling"
	gen faschooling=.
	replace faschooling=o_fhuni_all if youth==0 & b_sex==2 & b_eduwest==1 & b_cohort1==1
	lab var faschooling "female adult schooling"
	gen maschooling=.
	replace maschooling=o_fhuni_all if youth==0 & b_sex==1 & b_eduwest==1 & b_cohort1==1
	lab var maschooling "male adult schooling"

/*******************************************generate two factors, one for the youth sample, one for the adult sample********************************************************/
/*only use those youths and adults that are in both samples*/
	local flocy "yLoc_sverl yLoc_serre yLoc_sglue yLoc_shart yLoc_sand yLoc_ssozu yLoc_sfaeh yLoc_skntr yLoc_senga" 	
	local floca "Loc1 Loc2 Loc3 Loc4 Loc5 Loc6 Loc7 Loc8 Loc9 Loc10"	

	global factorlist flocy floca
	
	local u = 0

	foreach factor of global factorlist{
		local u = `u'+1
		local sc`u' "`factor'"
		local varlist "`varlist' ``sc`u'''"
	}

	      forvalues g=1/2{
		forvalues x=1/`u'{
			polychoric ``sc`x''' if b_sex==`g' & (b_cohort1==1 | youth==1) & b_eduwest==1 & yLoc_sverl!=. & Loc1!=.
			matrix define m`x'_`g'=r(R) 
			cou if b_sex==`g' & (b_cohort1==1 | youth==1) & b_eduwest==1 & yLoc_sverl!=. & Loc1!=.
			local n`x'_`g'=r(N)
			factormat m`x'_`g', n(`n`x'_`g'') pf factors(1)
			predict f`x'_`g' if b_sex==`g' & (b_cohort1==1 | youth==1) & b_eduwest==1 & yLoc_sverl!=. & Loc1!=., b	
				}
	      		}	
	*      
		forvalues x=1/`u'{
		rename f`x'_1 f`x'
		replace f`x'=f`x'_2 if b_sex==2
		drop f`x'_2
		}
*
	egen flocy=std(f1) if yLoc_sverl!=. & Loc1!=.
	egen floca=std(f2) if yLoc_sverl!=. & Loc1!=.
	drop f1 f2
	lab var flocy "standardized loc factor, youth sample (ya)"
	lab var floca "standardized loc factor, adult sample (ya)"	
	
		****
		lab var yLoc_sverl "My life's course depends on me"
		lab var yLoc_serre "I have not achieved what I deserve"
		lab var yLoc_sglue "Success is a matter of fate or luck"
		lab var yLoc_sand  "Others decide about my life"
		lab var yLoc_shart "Success is a matter of hard work" 
		lab var yLoc_szwei "In case of difficulties, doubts about own abilities"
		lab var yLoc_ssozu "Possibilities in life depend on social conditions"
		lab var yLoc_sfaeh "Abilities are more important than effort"
		lab var yLoc_skntr "Little control over what happens to me"
		lab var yLoc_senga "Social involvement can help influence social conditions"
		lab var o_fhuni_all "Tertiary education"
		lab var o_lnhrlywagea "Log hrly wage"
		lab var nr_siblings_all "Number of siblings"
		lab var b_broken "Broken home"
		lab var b_fedu_dk "Father's edu unknown"
		lab var b_fedu_hs "Father general secondary school"
		lab var b_fedu_rs "Father secondary intermediate"
		lab var b_fedu_gym "Father grammar school"
		lab var b_fedu_o "Father's edu 'other'"
		lab var b_fedu_do "Father dropout"
		lab var b_medu_dk "Mother's edu unknown"
		lab var b_medu_hs "Mother general secondary school"
		lab var b_medu_rs "Mother secondary intermediate"
		lab var b_medu_gym "Mother grammar school"
		lab var b_medu_o "Mother's edu 'other'"
		lab var b_medu_do "Mother dropout"
		lab var north "North"
		lab var south "South"
		lab var east "East"
		lab var west "West"
		lab var b_lcity "Childhood in large city"
		lab var b_mcity "Childhood in medium city"
		lab var b_scity "Childhood in small city"
		lab var b_country "Childhood in countryside"
		lab var y_gymempfeh "Recommendation: grammar school"
		lab var y_hauptempfeh "Recommendation: general secondary school"
		lab var b_age "Age"
		lab var b_unemprate "Local unemployment rate"
		lab var b_married "Married"
		lab var b_kids "Number of Children"
		lab var unemp_edu "Unemployment at schooling decision"
		lab var o_lmparta "Labor market participation"
		lab var o_lnhrlywagea "Log hourly wage"
		lab var o_hrlywagea "Hourly wage"
		lab var fyschooling "Higher education, females (youth sample)"
		lab var myschooling "Higher education, males (youth sample)"
		lab var faschooling "Higher education, females (adult sample)"
		lab var maschooling "Higher education, males (adult sample)"


***********************************************************************************************************************************************************


