/*---------------------------------------------------------------*/ 
/* April 2003 Program to compute CI for IRF from a VAR           */
/* using the simulation methods as described in Hamilton p.299   */
/*---------------------------------------------------------------*/ 

/*  Inputs:

	amat 	: VAR coefficients estimates from VAR excluding deterministic
	omhat	: VCV matrix estimated from VAR 
	yt   	: data
	fdet 	: deterministic flag
	reps 	: number of replications to be used
	lags	: number of lags used in the var
	r	: identification matrix for SF IRF
 	ino     : number of periods ahead for the IRF

    Output: 
	percentiles for IRF and of cumulative IRF

Procs only works if amat is non zero i.e. for a minimum of 1 lag
Proc is set up only for a VAR with 2 variables

*/

#include impuls.prc;
#include pctile3a.prc;

proc(8)=irfci(amat,omhat,y,fdet,reps,lags,r, ino);

local phat, xa, nf, nl, i, xa9, vcvste, irep, vcv, xxi, pii, 
	    vno, imp1, imp2, j, amati, stimp1, stimp2, vdy, cl,dl, d2,
        stimprep11,  stimprep12,  stimprep21,  stimprep22,
        cstimprep11,  cstimprep12,  cstimprep21,  cstimprep22,
	    jj, ci11, ci12, ci21, ci22, pct,cc, cci11, cci12, cci21, cci22;

pct=seqa(0.001,0.001,199)|seqa(0.200, 0.01, 60)|seqa(0.80, 0.001,200);

ci11=zeros(rows(pct),ino);
ci12=zeros(rows(pct),ino);
ci21=zeros(rows(pct),ino);
ci22=zeros(rows(pct),ino);
cci11=zeros(rows(pct),ino);
cci12=zeros(rows(pct),ino);
cci21=zeros(rows(pct),ino);
cci22=zeros(rows(pct),ino);

vno=cols(y);
@compute inv(xa'xa)@
nf=1+lags;
nl=rows(y);
xa=y[nf-1:nl-1,.];
if lags>1;
i=2;do until i > lags;
 xa9=y[nf-i:nl-i,.];
 xa=xa~xa9;
i=i+1; endo;
endif;

xxi=inv(xa'xa);

phat=vec(amat);
vcv=(omhat.*.xxi);

vcvste=chol(vcv)';

stimprep11=zeros(reps, ino);
stimprep12=zeros(reps, ino);
stimprep21=zeros(reps, ino);
stimprep22=zeros(reps, ino);
cstimprep11=zeros(reps, ino);
cstimprep12=zeros(reps, ino);
cstimprep21=zeros(reps, ino);
cstimprep22=zeros(reps, ino);

irep=1; do until irep>reps;
irep;

   pii=phat+vcvste*rndn(rows(phat),1);
   amati=pii[1:vno,1];	
   j=vno+1; do until j>rows(pii);
   amati=amati~pii[j:vno+j-1,.];
   j=j+vno+1; endo;
   {imp1}=impuls(amati, ino,1,0); @compute IRF give the new phi and amat matrix @
   {imp2}=impuls(amati, ino,2,0); 
   
   stimp1=zeros(cols(amati),ino);stimp2=stimp1;  @compute structural IRF given r @
   vdy=stimp1;
   i=1; do until i>ino;
   cl=(imp1[.,i]')|(imp2[.,i]');
   dl=cl'*(r); d2=dl*dl';
   vdy[1,i]=d2[1,1]; vdy[2,i]=d2[2,2]; 
   stimp1[.,i]=dl[1,.]'; stimp2[.,i]=dl[2,.]'; 
   i=i+1; endo;

   stimprep11[irep,.]=stimp1[1,.]; @response of first variable to first shock@
   stimprep12[irep,.]=stimp1[2,.]; @response of second variable to first shock@
   stimprep21[irep,.]=stimp2[1,.];
   stimprep22[irep,.]=stimp2[2,.];

   cstimprep11[irep,.]=cumsumc(stimp1[1,.]')'; @ cumulative response of first variable to first shock@
   cstimprep12[irep,.]=cumsumc(stimp1[2,.]')'; @ cumulative response of second variable to first shock@
   cstimprep21[irep,.]=cumsumc(stimp2[1,.]')';
   cstimprep22[irep,.]=cumsumc(stimp2[2,.]')';

irep=irep+1; 
endo;

pct=seqa(0.001,0.001,199)|seqa(0.200, 0.01, 60)|seqa(0.80, 0.001,200);

jj=1; do until jj>ino;

{cc}=pctile(stimprep11[.,jj],pct);
ci11[.,jj]=cc[.,2]; 

{cc}=pctile(stimprep12[.,jj],pct);
ci12[.,jj]=cc[.,2]; 

{cc}=pctile(stimprep21[.,jj],pct);
ci21[.,jj]=cc[.,2]; 

{cc}=pctile(stimprep22[.,jj],pct);
ci22[.,jj]=cc[.,2]; 


{cc}=pctile(cstimprep11[.,jj],pct);
cci11[.,jj]=cc[.,2]; 

{cc}=pctile(cstimprep12[.,jj],pct);
cci12[.,jj]=cc[.,2]; 

{cc}=pctile(cstimprep21[.,jj],pct);
cci21[.,jj]=cc[.,2]; 

{cc}=pctile(cstimprep22[.,jj],pct);
cci22[.,jj]=cc[.,2]; 

jj=jj+1; endo;    
   
retp(ci11, ci12, ci21, ci22, cci11, cci12, cci21, cci22);
endp;


