/* Procedure to compute the variance decomposition of a VAR. Uses the    */
/* outputs from Var.prc and impuls.prc  */

proc(1)=vardec(ino,stimp,k);
/*    Input:
        ino= number of lags in impuls
        stimp= impulse for the equation of interest
        k= number of endogenous in VAR
*/
/*   Output:
      vdi=matrix (ino x k) with the var decomp at each t
*/


local vdi, cvdi, varei,vdeyi,vi,stimpi,vdyi,varyi,i ;


vdi=zeros(ino,k);
cvdi=zeros(ino,k);
varei=zeros(k,1);
vdeyi=zeros(k,1);

vi=2;
do until vi>ino;

stimpi=stimp[1:vi,.];




vdyi=stimpi'*stimpi;
varyi=sumc(diag(vdyi));



i=1; do until i>k;

varei[i,.]=vdyi[i,i];
vdeyi[i,.]=varei[i,.]/varyi;

i=i+1; endo;

vdi[vi,.]=vdeyi';

vi=vi+1;
endo;


retp(vdi);
endp;

