/* GE mar95 proc to run a VAR with n variables, either with specified
   lag length or using a BIC lag length selector

   rewrite Sept 99 to allow for k=0 to be selected

*/

proc(5) = var(y,nfirst,nlast,k,fdet);

/*     Inputs
       y       :   data
       nfirst  :   first ob to use
       nlast   :   last ob to use
       k       :   Lag length (negative for automatic selection
       fdet    :   0=no constant, 1=constant

       Output

       amat    :   Coefficient estimates ((nk+1)xn matrix if fdet=1)
       seim    :   Standard errors for amat
       om      :   varaince covariance matrix of residuals
       res     :   residuals
       r2      :   R-square nx1

*/


local vno, maxlag, nf, nl, bic, nlag, xa, tss, rss, r2,
      i, xa9, amat, res, gtt, psel, xxi, om,
      seim, im, vim;

vno=cols(y);

@    This proc returns (nk+1) by n matrix of coefficients and se's
     The first row is the constant, then the next nxn block is the
     coefficients for L=1 etc @

if k<0;
maxlag=abs(k);
@  select lag length using BIC lag length selector @
nf=nfirst+maxlag+1;
nl=nlast;

bic=zeros(maxlag+1,1);
nlag=0; do until nlag>maxlag;
if fdet<2; xa=ones(nl-nf+1,1);
else;
xa=ones(nl-nf+1,1)~seqa(1,1,nl-nf+1);endif;
if nlag>0;
i=1;do until i > nlag;
 xa9=y[nf-i:nl-i,.];
 xa=xa~xa9;
i=i+1; endo;
endif;
if fdet==0; xa=xa[.,2:cols(xa)];endif;
amat=inv(xa'xa)*xa'y[nf:nl,.];
res=y[nf:nl,.]-xa*amat;
gtt=ln(rows(xa))/(rows(xa));
if fdet==0;
bic[nlag+1,1]=ln(det((res'res)/(rows(xa))))+(vno^2*nlag)*gtt;
elseif fdet==1;
bic[nlag+1,1]=ln(det((res'res)/(rows(xa))))+(vno+vno^2*nlag)*gtt;
endif;

nlag=nlag+1; endo;

psel=minindc(bic)-1;@ "psel";;psel;@
else;
psel=k;
endif;


@  do the VAR with psel lags @

nf=nfirst+psel;
nl=nlast;
if fdet<2; xa=ones(nl-nf+1,1); else;
xa=ones(nl-nf+1,1)~seqa(1,1,nl-nf+1); endif;
if psel>0;
i=1;do until i > psel;
 xa9=y[nf-i:nl-i,.];
 xa=xa~xa9;
i=i+1; endo;
if fdet==0; xa=xa[.,2:cols(xa)];endif;
endif;

if (psel+fdet)==0;
 amat=zeros(1,1);r2=0;res=y;seim=0;
 om=(res'res)/(rows(res));

else;

xxi=inv(xa'xa);
amat=xxi*xa'y[nf:nl,.];
res=y[nf:nl,.]-xa*amat;

@ compute standard errors @
om=(res'res)/(rows(res));
seim=amat;  r2=zeros(vno,1);
im=1; do until im>vno;
 vim=om[im,im].*xxi;
 seim[.,im]=sqrt(diag(vim));
 tss=(y[nf:nl,im]-meanc(y[nf:nl,im]))'(y[nf:nl,im]-meanc(y[nf:nl,im]));
 rss=res[.,im]'res[.,im];
 r2[im,1]=1-(rss/tss);
im=im+1; endo;
endif;

retp(amat,seim,om,res,r2);
endp;

/*
/* Debug */
y=rndn(100,2);
{b,se,om,res,r2}=var(y[.,1],1,100,1,1);
b~se;
*/

