#include s0.prc;
#include var.prc;
#include crlk.prc;
#include ers.prc;

proc(1) = cvurst(rsq,fdet);
local cvv, cv;

let cvv[5,10] =
     0.00   0.10   0.20   0.30   0.40   0.50   0.60   0.70   0.80   0.90
     3.34   3.41   3.54   3.76   4.15   4.79   5.88   7.84  12.12  25.69
     3.34   3.41   3.54   3.70   3.96   4.41   5.12   6.37   9.17  17.99
     5.70   5.79   5.98   6.38   6.99   7.97   9.63  12.60  19.03  39.62
     5.70   5.77   6.00   6.40   7.07   8.15  10.00  13.36  20.35  41.87;

if fdet<3; cvv=cvv[1:2,.];
elseif fdet==3;  cvv=cvv[1,.]|cvv[3,.];
elseif fdet==4; cvv=cvv[1,.]|cvv[4,.];
else; cvv=cvv[1,.]|cvv[5,.];
endif;

{cv}=crlk(rsq,cvv');
retp(cv);
endp;


proc(4)=urst(y,x,rhobar,fdet,k);
local n, m, rhoest, junk, zest, z, om, rsq,
      ddy, zone, qdy, zrho, d00, d10, d20,
      d01, d11, d21, t, st, st2, iom, dn0,
      dn1, sz0, szt0, nm0, sz1, szt1, nm1,
      beta0, beta1, b, se, sig0, res0, r2,
      siga, resa;

/*    Inputs

      y      :   univariate variable to be tested for unit root
      x      :   stationary covariates (Txm) vector
      rhobar :   alternative value for rho
      fdet   :   flag for case for deterministics, corresponds to cases in paper
            
*/

n=rows(y);
m=cols(x);

@ est R square and lag length if auto @

if fdet==1;
{rhoest}=rhoar(y,0,k); @estimate the largest root in y, proc is in ers.prc@
elseif  fdet>3;
{rhoest}=rhoar(y,2,k);
else;
{rhoest}=rhoar(y,1,k);
endif;

zest=(y[1,1])|(y[2:n,.]-y[1:n-1,.]); @rhoest*@
z=zest~x;
if fdet==1;
{om}=s0(z,1,n,k,0);
elseif fdet>3;
{om}=s0(z,1,n,k,2);
else;
{om}=s0(z,1,n,k,1);
endif;

rsq=om[1,2:m+1]*inv(om[2:m+1,2:m+1])*om[2:m+1,1]/om[1,1];

@ construct test statistic @

ddy=(y[1,1])|(y[2:n,.]-y[1:n-1,.]);
zone=ddy~x;

qdy=(y[1,1])|(y[2:n,.]-rhobar*y[1:n-1,.]);
zrho=qdy~x;

@ remove deterministic terms under null and alternative resp. @

d00=eye(m+1)|eye(m+1);
d10=d00;d10[1,1]=0;
d10[3,1]=1;
d20=zeros(m+1,m+1)|eye(m+1);
d20[3,1]=0;


d01=eye(m+1)|eye(m+1);
d11=d01;d11[1,1]=(1-rhobar);
d11[3,1]=rhobar;
d21=zeros(m+1,m+1)|eye(m+1);
d21[3,1]=(1-rhobar);

t=seqa(2,1,n-1);         
st=t'ones(n-1,1);
st2=t't;

iom=inv(om);

@ denominator of the deterministic terms @

dn0=d00*iom*d00'+(n-1)*d10*iom*d10'+d10*iom*(d20')*st
      +d20*iom*(d10')*st+d20*iom*(d20')*st2;

dn1=d01*iom*d01'+(n-1)*d11*iom*d11'+d11*iom*(d21')*st
      +d21*iom*(d11')*st+d21*iom*(d21')*st2;

@ numerator under H0 @
sz0=zone[2:n,.]'ones(n-1,1);
szt0=zone[2:n,.]'seqa(2,1,n-1);
nm0=d00*iom*zone[1,.]'+d10*iom*sz0+d20*iom*szt0;

@ numerator under H1 @
sz1=zrho[2:n,.]'ones(n-1,1);
szt1=zrho[2:n,.]'seqa(2,1,n-1);
nm1=d01*iom*zrho[1,.]'+d11*iom*sz1+d21*iom*szt1;

@ now for each case - the value for fdet is the case from the paper @
beta0=zeros(2*(m+1),1);
beta1=beta0;
if fdet==2;
beta0[1,1]=nm0[1,1]/dn0[1,1];
beta1[1,1]=nm1[1,1]/dn1[1,1];
elseif fdet==3;
beta0[1:m+1,1]=inv(dn0[1:m+1,1:m+1])*nm0[1:m+1,.];
beta1[1:m+1,1]=inv(dn1[1:m+1,1:m+1])*nm1[1:m+1,.];
elseif fdet==4;
beta0[1:m+2,1]=inv(dn0[1:m+2,1:m+2])*nm0[1:m+2,.];
beta1[1:m+2,1]=inv(dn1[1:m+2,1:m+2])*nm1[1:m+2,.];
elseif fdet==5;
beta0=inv(dn0)*nm0;
beta1=inv(dn1)*nm1;
endif;

@ construct detrended series @



zone[1,.]=zone[1,.]-beta0'd00;
zone[2:n,.]=zone[2:n,.]-ones(n-1,1).*beta0'd10-t.*beta0'd20;

zrho[1,.]=zrho[1,.]-beta1'd01;
zrho[2:n,.]=zrho[2:n,.]-ones(n-1,1).*beta1'd11-t.*beta1'd21;


@ run second stage VAR's to construct error covariances @

{b,se,sig0,res0,r2}=var(zone,1,n,k,0);
{b,se,siga,resa,r2}=var(zrho,1,n,k,0);

@ construct statistic @
st=n*(sumc(diag(inv(sig0)*(siga)))-(m+rhobar));

retp(st,rsq,rhoest,om);
endp;


@ debug @
/*
#include c:\uroot\stat\gss\mcbiv.prc;
m=1;
fdet=5;
nobs=100;
nmc=1000;

if fdet>1;
cbar=-13.5;
else;
cbar=-7;
endif;
c=0;
k=0;
r2=0.5;
rhobar=1+cbar/nobs;
rho=1+c/nobs;
lambda=eye(m+1);
lambda[1,2]=sqrt(r2);lambda[2,1]=lambda[1,2];
if m>1;
delt2=0.5;
lambda[1,2]=sqrt(r2-delt2^2);lambda[2,1]=lambda[1,2];
lambda[1,3]=(delt2);lambda[3,1]=lambda[1,3];
endif;
phi=zeros(m+1,m+1);
@phi[1,2]=-0.5;
phi[2,1]=0.3;@
a1=eye(m+1)-phi;
om=inv(a1)*lambda*inv(a1)';
delt=om[1,2]/sqrt(om[1,1]*om[2,2]);
"true rsq  = ";;r2=delt'delt;r2;

@rndseed 19936;@
a=zeros(nmc,1);cval=a;rr2=a;
imc=1; do until imc>rows(a);

{y,x}=mcbiv(rho,lambda,phi,nobs,0);


{a[imc,1],rsq}=urst(y,x,rhobar,fdet,k);
{cval[imc,1]}=cvurst(rsq,fdet);
rr2[imc,1]=rsq;
imc=imc+1; endo;
" ";
" est R-sq  ";;meanc(a.<cval);
{cv}=cvurst(r2,fdet);
" true R-sq ";;meanc(a.<cv);



*/
