/*  GE rewrite of URST proc to compute the test for a cointegrating vector
    having a unit root (null of no cointegration) using x data as
    stationary covariates */




#include s0.prc;
#include var.prc;
#include crlk.prc;


proc(1) = cvurst(rsq,fdet);
local cvv, cv;

let cvv[5,10] =
     0.00   0.10   0.20   0.30   0.40   0.50   0.60   0.70   0.80   0.90
     3.34   3.41   3.54   3.76   4.15   4.79   5.88   7.84  12.12  25.69
     3.34   3.41   3.54   3.70   3.96   4.41   5.12   6.37   9.17  17.99
     5.70   5.79   5.98   6.38   6.99   7.97   9.63  12.60  19.03  39.62
     5.70   5.77   6.00   6.40   7.07   8.15  10.00  13.36  20.35  41.87;

if fdet<3; cvv=cvv[1:2,.];
elseif fdet==3;  cvv=cvv[1,.]|cvv[3,.];
elseif fdet==4; cvv=cvv[1,.]|cvv[4,.];
else; cvv=cvv[1,.]|cvv[5,.];
endif;

{cv}=crlk(rsq,cvv');
retp(cv);
endp;


proc(2)=urstc(y,x,gam,rhobar,fdet,k);
local n, m, rhoest, junk, zest, z, om, rsq,xest,
      ddy, zone, qdy, zrho, d00, d10, d20,
      d01, d11, d21, t, st, st2, iom, dn0,
      dn1, sz0, szt0, nm0, sz1, szt1, nm1,
      beta0, beta1, b, se, sig0, res0, r2,
      siga, resa;

/*    Inputs

      y      :   dependent variable in cointegrating vector
      x      :   known I(1) covariates (Txm) vector
      gam    :   cointegrating vector gamma from paper
      rhobar :   alternative value for rho
      fdet   :   flag for case for deterministics,
                   corresponds to cases in paper
      k      :   number of lags
*/

n=rows(y);
m=cols(x);

@ est R square under the null and lag length if auto @

y=y-gam'x;				@ construct cointegrating vector @
zest=0|(y[2:n,.]-y[1:n-1,.]);      	@ don't use x1 for the estimation of rsq@
xest=0|(x[2:n,.]-x[1:n-1,.]);
z=xest~zest;


if fdet>3;
{om}=s0(z,1,n,k,2);
else;
{om}=s0(z,1,n,k,1);
endif;

rsq=om[m+1,1:m]*inv(om[1:m,1:m])*om[1:m,m+1]/om[m+1,m+1];      

@ construct test statistic @

x=x[1,1]|(x[2:n,.]-x[1:n-1,.]);

ddy=(y[1,1])|(y[2:n,.]-y[1:n-1,.]);
zone=x~ddy;

qdy=(y[1,1])|(y[2:n,.]-rhobar*y[1:n-1,.]);
zrho=x~qdy;

@ remove deterministic terms under null and alternative resp. @
d00=eye(m+1)|eye(m+1);
d10=zeros(m+1,m+1)|eye(m+1);


d01=eye(m+1)|eye(m+1);
d11=zeros(m+1,m+1)|eye(m+1); d11[m+1,m+1]=(1-rhobar);
d11[rows(d11),cols(d11)]=rhobar;
d21=zeros(m+1,m+1)|zeros(m+1,m+1);
d21[rows(d21),cols(d21)]=(1-rhobar);

t=seqa(2,1,n-1);
st=t'ones(n-1,1);
st2=t't;

iom=inv(om);

@ denominator of the deterministic terms @

dn0=d00*iom*d00'+(n-1)*d10*iom*d10';

dn1=d01*iom*d01'+(n-1)*d11*iom*d11'+d11*iom*(d21')*st
      +d21*iom*(d11')*st+d21*iom*(d21')*st2;


@ numerator under H0 @
sz0=zone[2:n,.]'ones(n-1,1);
szt0=zone[2:n,.]'seqa(2,1,n-1);
nm0=d00*iom*zone[1,.]'+d10*iom*sz0;

@ numerator under H1 @
sz1=zrho[2:n,.]'ones(n-1,1);
szt1=zrho[2:n,.]'seqa(2,1,n-1);
nm1=d01*iom*zrho[1,.]'+d11*iom*sz1+d21*iom*szt1;

@ now for each case - the value for fdet is the case from the paper @
beta0=zeros(2*(m+1),1);
beta1=beta0;
if fdet==1;
beta0[1,1]=nm0[1,1]/dn0[1,1];
beta1[1,1]=nm1[1,1]/dn1[1,1];
elseif fdet==2;
beta0[1:m+1,1]=inv(dn0[1:m+1,1:m+1])*nm0[1:m+1,.];
beta1[1:m+1,1]=inv(dn1[1:m+1,1:m+1])*nm1[1:m+1,.];
elseif fdet==3;
beta0[1:2*m+1,1]=inv(dn0[1:2*m+1,1:2*m+1])*nm0[1:2*m+1,.];
beta1[1:2*m+1,1]=inv(dn1[1:2*m+1,1:2*m+1])*nm1[1:2*m+1,.];
elseif fdet==4;
beta0=inv(dn0)*nm0;
beta1=inv(dn1)*nm1;
endif;


@ construct detrended series @

zone[1,.]=zone[1,.]-beta0'd00;
zone[2:n,.]=zone[2:n,.]-ones(n-1,1).*beta0'd10;

zrho[1,.]=zrho[1,.]-beta1'd01;
zrho[2:n,.]=zrho[2:n,.]-ones(n-1,1).*beta1'd11-t.*beta1'd21;


@ run second stage VAR's to construct error covariances @

{b,se,sig0,res0,r2}=var(zone,1,n,k,0);
{b,se,siga,resa,r2}=var(zrho,1,n,k,0);

@ construct statistic @
st=n*(sumc(diag(inv(sig0)*(siga)))-(m+rhobar));

retp(st,rsq);
endp;


@ debug @
/*
#include c:\uroot\stat\gss\mcbiv.prc;
m=1;
fdet=5;
nobs=100;
nmc=1000;

if fdet>1;
cbar=-13.5;
else;
cbar=-7;
endif;
c=0;
k=0;
r2=0.5;
rhobar=1+cbar/nobs;
rho=1+c/nobs;
lambda=eye(m+1);
lambda[1,2]=sqrt(r2);lambda[2,1]=lambda[1,2];
if m>1;
delt2=0.5;
lambda[1,2]=sqrt(r2-delt2^2);lambda[2,1]=lambda[1,2];
lambda[1,3]=(delt2);lambda[3,1]=lambda[1,3];
endif;
phi=zeros(m+1,m+1);
@phi[1,2]=-0.5;
phi[2,1]=0.3;@
a1=eye(m+1)-phi;
om=inv(a1)*lambda*inv(a1)';
delt=om[1,2]/sqrt(om[1,1]*om[2,2]);
"true rsq  = ";;r2=delt'delt;r2;

@rndseed 19936;@
a=zeros(nmc,1);cval=a;rr2=a;
imc=1; do until imc>rows(a);

{y,x}=mcbiv(rho,lambda,phi,nobs,0);
x=recserar(x,0,1);

{a[imc,1],rsq}=urstc(y,x,1,rhobar,fdet,k);
{cval[imc,1]}=cvurst(rsq,fdet);
rr2[imc,1]=rsq;
imc=imc+1; endo;
" ";
" est R-sq  ";;meanc(a.<cval);
{cv}=cvurst(r2,fdet);
" true R-sq ";;meanc(a.<cv);
*/



