/*   GE feb99
     This program computes the BIC choice of lag length for
     computing spectral densities at frequency zero for
     unit root testing
*/

proc(1) = urbic1(y,fdet,maxp);

/*  Inputs     :      y      - the data
                      fdet   - flag for deterministics
                      maxp   - maximum lag length
    Outputs    :      pstar  - BIC lag choice
*/

local n, bic, p, dy, z, yp, ip, zzi, zy, b,
      u, s, x, pstar;


n=rows(y); bic=zeros(maxp+1,1);

p=0; do until p>(maxp);
dy = 0|(y[2:n,1]-y[1:(n-1),1]);
z=y[(1+maxp):(n-1),1]; yp=y[(2+maxp):n,1]-y[(1+maxp):n-1,1];
 if fdet==1; x=ones(rows(z),1);
 elseif fdet==2; x=ones(rows(z),1)~seqa(1,1,rows(z));
 endif;
 if p>0;
   ip=0; do until ip>=p-1;
   z=z~dy[(1+maxp-ip):(n-1-ip),1];
   ip=ip+1; endo;
 endif;
 if fdet>0; z=z~x; endif;
zzi=invpd(z'z); zy=z'yp;
b=zzi*zy;
u=yp-z*b; s=(u'u)/(rows(u));
bic[p+1,1]=ln(s)+p*ln(rows(u))/rows(u);    /*## BIC VERSION ## */
p=p+1; endo;
@bic;@
pstar=minindc(bic)-1;
retp(pstar);
endp;

/*   GE feb99
     This program computes the AIC choice of lag length for
     computing spectral densities at frequency zero for
     unit root testing
*/

proc(1) = uraic1(y,fdet,maxp);

/*  Inputs     :      y      - the data
                      fdet   - flag for deterministics
                      maxp   - maximum lag length
    Outputs    :      pstar  - AIC lag choice
*/

local n, bic, p, dy, z, yp, ip, zzi, zy, b,
      u, s, x, pstar;


n=rows(y); bic=zeros(maxp+1,1);

p=0; do until p>(maxp);
dy = 0|(y[2:n,1]-y[1:(n-1),1]);
z=y[(1+maxp):(n-1),1]; yp=y[(2+maxp):n,1]-y[(1+maxp):n-1,1];
 if fdet==1; x=ones(rows(z),1);
 elseif fdet==2; x=ones(rows(z),1)~seqa(1,1,rows(z));
 endif;
 if p>0;
   ip=0; do until ip>=p-1;
   z=z~dy[(1+maxp-ip):(n-1-ip),1];
   ip=ip+1; endo;
 endif;
 if fdet>0; z=z~x; endif;
zzi=invpd(z'z); zy=z'yp;
b=zzi*zy;
u=yp-z*b; s=(u'u)/(rows(u));
bic[p+1,1]=ln(s)+p*2/rows(u);    /*## AIC VERSION ## */
p=p+1; endo;
@bic;@
pstar=minindc(bic)-1;
retp(pstar);
endp;

/*   GE feb99
     This program computes the MAIC choice of lag length for
     computing spectral densities at frequency zero for
     unit root testing
     Source : Ng and Perron (1998)
*/

proc(1) = urmaic(y,maxp);

/*  Inputs     :      y      - the data (GLS detrended)
                      maxp   - maximum lag length
    Outputs    :      pstar  - MAIC lag choice
*/

local n, bic, p, dy, z, yp, ip, zzi, zy, b,
      u, s, ct, pstar;


n=rows(y); bic=zeros(maxp+1,1);

p=0; do until p>(maxp);
dy = 0|(y[2:n,1]-y[1:(n-1),1]);
z=y[(1+maxp):(n-1),1]; yp=y[(2+maxp):n,1]-y[(1+maxp):n-1,1];
 if p>0;
   ip=0; do until ip>=p-1;
   z=z~dy[(1+maxp-ip):(n-1-ip),1];
   ip=ip+1; endo;
 endif;
zzi=invpd(z'z); zy=z'yp;
b=zzi*zy;
u=yp-z*b; s=(u'u)/(rows(u));
ct=(b[1,1]^2)*(z[.,1]'z[.,1])/s;
bic[p+1,1]=ln(s)+2*(p+ct)/rows(u);    /*## MAIC VERSION ## */
p=p+1; endo;
@bic;@
pstar=minindc(bic)-1;
retp(pstar);
endp;


/*
@ debug @
#include c:\gauss\gtsp\detrend.prc;
@rndseed 7192;@
fdet=1; nmc=100;
a1=zeros(nmc,1);
i=1; do until i>nmc;
eps=rndn(1001,1);eps=eps[2:rows(eps),.]+0.7*eps[1:rows(eps)-1,.];
@eps=recserar(eps,0,0.4);@
y=recserar(eps,0,1);
{yd}=detrend(y,fdet,2,1-7/rows(y));
a1[i,1]=urmaic(yd,4);
i=i+1; endo;
" < 1";;meanc(a1.<0.9);
" < 2";;meanc(a1.<1.9);
" < 3";;meanc(a1.<2.9);
  */
