@ unitcidf.prc  JHS 9/7/90 (modified 9/18/91)
   proc to compute confidence insterval for local-to-unit root parameter c,
    given a value of a ADF test statistic.
   Calculations and theory are described in J. Stock, "Confidence Intervals
   for the Largest Autoregressive Root ..."
   Note that these intervals combine disjoint confidence intervals when the
   correct interval would be disjoint (this simplifies the algorithm).
@
proc(1) = unitci(tdf,clevel,cv);
@
 tdf = value of test statistic
  clevel = desired significance level for test -- so the confidence interval
           will be 100(1-clevel)%
  cv = matrix of tabulated critical values read in fmt form
 output: 2-dim vector (c0, c1) -- the 100*clevel% confidence interval for c
        based on critical values in the lookup table saved as the matrix cv.
@
 local *;
 alpha0=0.5*(1-clevel);
 sel0=(fix(1000*cv[1,.]'+.01).==fix(1000*alpha0+.01));
 sel1=(fix(1000*cv[1,.]'+.01).==fix(1000*(1-alpha0)+.01));
 i0=sumc(seqa(1,1,cols(cv)).*sel0);

 i1=sumc(seqa(1,1,cols(cv)).*sel1);
 cc=cv[2:rows(cv),1]; cv0=cv[2:rows(cv),i0]; cv1=cv[2:rows(cv),i1];
 d1=(cv0.<tdf); d2=(cv1.>tdf); dd=d1.*d2;
 if i0==i1;    @ return median -- 0-width CI @
  if sumc(d1)>0 and sumc(d2)>0;
   jj=selif(seqa(1,1,rows(cc)),d1); j0=maxc(jj); j1=j0+1;
  elseif sumc(d1)==0; c0=-99.99; c1=c0; goto done;
  elseif sumc(d2)==0; c0=99.99; c1=c0; goto done;
  endif;
 elseif sumc(dd)>0; @ nonempty CI @
  jj=selif(seqa(1,1,rows(cc)),dd); j0=maxc(jj); j1=minc(jj);
 else; @ empty confidence interval -- outside the range covered by cv @
  if sumc(d1)==0; c0=-99.99; c1=-99.99;
  elseif sumc(d2)==0; c0=99.99; c1=99.99;
  endif;
  goto done;
 endif;
 if j0<rows(cc);
  wt0=(tdf-cv0[j0,1])/(cv0[j0+1,1]-cv0[j0,1]);
   c0=(1-wt0)*cc[j0,1] + wt0*cc[j0+1,1];
 else; wt0=0; c0=99.99; endif;
 if j1>1;
  wt1=(tdf-cv1[j1-1,1])/(cv1[j1,1]-cv1[j1-1,1]);
   c1=(1-wt1)*cc[j1-1,1] + wt1*cc[j1,1];
 else; wt1=0; c1=-99.99; endif;
done:
retp(c1|c0);
endp;


@ ---------- How to run UNITCI -------------- @
@  first read in tables of critical values @
@load path="fmt";@
 @ demeaned dickey-fuller statistic: @
  load  path=fmt cvdf3_a;
  cvdf_a=cvdf3_a[1,.]|sortc(cvdf3_a[2:rows(cvdf3_a),.],1);
 @ detrended dickey-fuller statistic: @
  load  path=fmt cvdf3_b;
  cvdf_b=cvdf3_b[1,.]|sortc(cvdf3_b[2:rows(cvdf3_b),.],1);
@ Next evaluate the unitci proc.  HERE ARE SOME EXAMPLES: @
 format 8,3;
/*
"  95% confidence interval for c, based on demeaned tdf, value of tdf = -3.0:";
 cc=unitci(-3.0,0.95,cvdf_a); cc';
 " ";
" 0% central confidence interval for c, based on demeaned tdf, value = -3.0";
"   (note that the 0% central confidence interval delivers the median-unbiased";
"   estimator of c):";
 cc=unitci(-3.0,0.0,cvdf_a); cc';
*/

