/*------------------------------------------------*/
/*  Proc to create test for stationarity          */
/* Follows Stock Handbook chapter                 */
/*------------------------------------------------*/

@ Input y   data                @
@   w   estimation of VCV at frequency zero @
@   fdet 1 for mean, 2 for trend        @


proc(1)=statest(y,w,fdet);

local n, ydtd, psy, lm , x, xxi, xy, b, i;

n=rows(y);


if fdet == 1; x=ones(n,1); elseif fdet == 2; x=ones(n,1)~seqa(1,1,n);
   else; x=zeros(n,1); endif;
if sumc(sumc(x)).ne.0;
 if cols(x)==1;
  ydtd=y-meanc(y);
 elseif cols(x)==2;
  xxi=invpd(x'x); xy=x'y; b=xxi*xy; ydtd=y-x*b;
 endif;
else; ydtd=y;endif;


psy=zeros(rows(y),1);

i=1;
do until i>rows(y);
  psy[i,1]=(sumc(ydtd[1:i,.]))^2;
i=i+1;
endo;

lm=(sumc(psy))/((n^2)*w);

retp(lm);
endp;


