/*----------------------------------------------*/
/* Procedure to compute the sum of covariance   */
/* spectral density estimator for ppp project   */
/* note than computes the S0 of the variable    */
/* itself not the quasi difference              */
/*----------------------------------------------*/

proc(2)= s0cov2(y,nlags);

local s0hat,weights,ilags,y1,x1, b,z,
       gamx, skhat;

if nlags<0; nlags=fix(6*((rows(y)/100)^.25)); endif;

if nlags>0;
   weights=ones(nlags,1);weights=1-cumsumc(weights)/(nlags+1);
   z=y;
   gamx=zeros(nlags+1,1);
   ilags=0; do until ilags>nlags;
      gamx[ilags+1,1]=(z[(ilags+1):rows(z),.]'*z[1:(rows(z)-ilags),.])/rows(y);
   ilags=ilags+1; endo;
   s0hat=gamx[1,1]+2*sumc(gamx[2:rows(gamx),.].*weights);
   skhat=gamx[1,1];
elseif nlags==0;
   z=y;
   gamx=zeros(1,1);
   gamx[1,1]=(z[1:rows(z),.]'*z[1:rows(z),.])/rows(y);
   s0hat=gamx[1,1];
endif;

retp(gamx[1,1],s0hat);
endp;
