/* GE mar95 proc to estimate the spectral density matrix of data using
   the AR method.
*/

proc(1) = s0(y,nfirst,nlast,k,fdet);

/*     Inputs
       y       :   data
       nfirst  :   first ob to use
       nlast   :   last ob to use
       k       :   Lag length (negative for automatic selection
       fdet    :   0=no constant, 1=constant

       Output

       s0      :   nxn matrix of the spectral density at freq zero
                   (scaled by 2*pi)

*/


local vno, maxlag, nf, nl, bic, nlag, xa,
      i, xa9, amat, res, gtt, psel, xxi, sig,
      a1, im, om;

vno=cols(y);

@    This proc returns (nk+1) by n matrix of coefficients and se's
     The first row is the constant, then the next nxn block is the
     coefficients for L=1 etc @

if k<0;
maxlag=abs(k);
@  select lag length using BIC lag length selector @
nf=nfirst+maxlag+1;
nl=nlast;

bic=zeros(maxlag+1,1);
nlag=0; do until nlag>maxlag;
if fdet==1; xa=ones(nl-nf+1,1);
else;
xa=ones(nl-nf+1,1)~seqa(1,1,nl-nf+1);endif;
if nlag>0;
i=1;do until i > nlag;
 xa9=y[nf-i:nl-i,.];
 xa=xa~xa9;
i=i+1; endo;
endif;
amat=inv(xa'xa)*xa'y[nf:nl,.];
res=y[nf:nl,.]-xa*amat;
gtt=ln(rows(xa))/(rows(xa));
bic[nlag+1,1]=ln(det((res'res)/(rows(xa))))+(2+vno*nlag)*gtt;

nlag=nlag+1; endo;

psel=minindc(bic)-1;@ "psel";;psel;@
else;
psel=k;
endif;


@  do the VAR with psel lags @

nf=nfirst+psel;
nl=nlast;
if fdet<2; xa=ones(nl-nf+1,1); else;
xa=ones(nl-nf+1,1)~seqa(1,1,nl-nf+1); endif;
if psel>0;
i=1;do until i > psel;
 xa9=y[nf-i:nl-i,.];
 xa=xa~xa9;
i=i+1; endo;
if fdet==0; xa=xa[.,2:cols(xa)];endif;
endif;

if (psel+fdet)==0;
 res=y;
 sig=(res'res)/(rows(res));

else;

xxi=inv(xa'xa);
amat=xxi*xa'y[nf:nl,.];
res=y[nf:nl,.]-xa*amat;

endif;

@ compute spectral density  @
sig=(res'res)/(rows(res));
a1=eye(vno);
if k>0;
if fdet==1; amat=amat[2:rows(amat),.];
elseif fdet==2; amat=amat[3:rows(amat),.];
endif;
im=1; do until im>k;
 a1=a1-amat[vno*(im-1)+1:vno*im,.]';
im=im+1; endo;
else;
a1=eye(vno);
endif;
om=inv(a1)*sig*(inv(a1)');

retp(om);
endp;

   /*
/* Debug */
#include c:\uroot\stat\gss\mcbiv.prc;
rsqaa=0.1|0.3|0.5|0.7|1;rsqaa=0.7;
delt=sqrt(1-rsqaa);
rho=1;
k=2;
fdet=1;
sig=eye(2);
sig[1,2]=delt[1,1];sig[2,1]=sig[1,2];
phi=zeros(2,2);phi[1,1]=0.4;phi[2,2]=0.3;       "Phi";phi;
nst=0;nobs=1000;    aa1=eye(2)-phi;aa1;" ";
{y,x}=mcbiv(rho,sig,phi,nobs,nst);
zest=(y[1,1])|(y[2:nobs,.]-1*y[1:nobs-1,.]);
z=x~zest;
{om}=s0(z,1,nobs,k,fdet);
rsq=1-om[2,1]*inv(om[1,1])*om[1,2]/om[2,2];
d=om[1,2]/sqrt(om[1,1]*om[2,2]);
rsqa=1-d*d;
rsqaa~rsq;
delt~d;
*/
