/* GE jun96 proc to compute the confidence interval on the largest
   autoregressive root of a series using the inversion of a
   seqence of point optimal tests
*/
#include c:\ces\gss\crlk.prc;
#include itestsr.prc;
#include poi.prc;

proc(1)=poici(y,ltl,utl,distl,distu,psel);

local cvl, cvu, junk, w1, lf, uf, i, alp0, rf, zr, cil, ciu,
      alpl, alpu, al, au, civ, civ1, ci;

/*      INPUTS
        y       : Tx1 data series
        ltl     : Size in lower tail (fraction, eg 5% is lt=0.05)
        utl     : Size in upper tail (fraction, eg 5% is ut=0.05)
                note: coverage = 1 - lt - ut
        distl   : Lower direction test statistic percentiles
        distu   : Upper direction test statistic percentiles

        OUTPUTS
        ci      : upper and lower bounds on c
*/

@ need to choose correct column of distl,distu
    calls proc crlk.prc written for ces project
    This linearly interpolates after selecting adjacent rows @

{cvl}=crlk(ltl,distl');cvl=cvl';@cvl=cvl[2:rows(cvl),.];@
{cvu}=crlk(utl,distu');cvu=cvu';@cvu=cvu[2:rows(cvu),.];  @
{junk,w1}=adf(y,1,psel);

lf=zeros(rows(distl)-1,1);uf=lf;
i=1; do until i>rows(lf);
alp0=1+distl[i+1,1]/rows(y);
alpl=1+distl[i+1,2]/rows(y);
alpu=1+distu[i+1,2]/rows(y);
@ compute test statistic @
{al}=poi(y,1,alp0,alpl,w1);
{au}=poi(y,1,alp0,alpu,w1);

if al.<cvl[i,1]; lf[i,1]=1; endif;   @distl[i+1,1]~alp0~alpl~al~cvl[i,1];@
if au.<cvu[i,1]; uf[i,1]=1; endif;   @distl[i+1,1]~alp0~alpu~au~cvu[i,1];@
i=i+1; endo;

rf=(lf+uf).>0;
civ1=selif(distl[2:rows(distl),1],(1-rf).>0);@civ1';@
zr=0;
cil=minc(civ1); if cil==miss(zr,0);cil=-40; endif;
ciu=maxc(civ1); if ciu==miss(zr,0);ciu=6; endif;
ci=cil|ciu;
retp(ci);
endp;
        /*
@ debug @
#include poicit.prc;
output file=temp reset;
load path=fmt distl;load path=fmt distu;
alp=0.8;
a=zeros(1,2);
rseed=round(abs(rndn(1,1)*1000));rseed=30047;
rndseed rseed;
imc=1; do until imc>rows(a);
eps=rndn(100,1);
u0s=rndn(1,1);
u0=u0s*sqrt(1/(1-alp*alp));
y=recserar(eps,u0,alp);
{ci}=poici(y,0.075,0.025,distl,distu,0);
@{ci1}=poicit(y,0.075,0.035,distl,distu,0,-10);@
a[imc,1]=ci[1,1];
a[imc,2]=ci[2,1];
imc=imc+1; endo;
@meanc(a[.,1].>-10);
meanc(a[.,2].<-10);@ci';
      */
