/* GE april 1996 program to compute POI test for all c0, cbar */



proc(1)=tvar(y,fdet,rho0);
local nobs, dy, qy0, dyt, sqy0, zt, zt0, b0hat,
      qy0t;


nobs=rows(y);
@---------- null estimate of the variance------------- @
 dy=y[2:rows(y),1]-rho0*y[1:(rows(y)-1),1];
 if rho0<1;
 qy0=(y[1,1]*sqrt(1-rho0*rho0))|dy;
 else;
 qy0=(y[1,1])|dy;
 endif;

 @-deterministics-@
 if rho0==1;
  if fdet==1;
    dyt=dy;
  elseif fdet==2;
    dyt=dy-meanc(dy);    @ OLS detrending under null @
  endif;
    sqy0=(dyt'dyt)/nobs;
 elseif rho0<1;
  if fdet==1;
   zt=(1-rho0)*ones(rows(dy),1); zt0=sqrt(1-rho0*rho0)|zt;
  elseif fdet==2;
   zt=(1-rho0)*ones(rows(dy),1) ~ (rho0+(1-rho0)*seqa(2,1,rows(dy)));
   zt0=(sqrt(1-rho0*rho0)*ones(1,2))|zt;
  endif;
   b0hat=invpd(zt0'*zt0)*(zt0'*qy0); qy0t=qy0-zt0*b0hat;
   sqy0=(qy0t'*qy0t)/nobs;

 else;
  if fdet==1;
   zt=(1-rho0)*ones(rows(dy),1); zt0=1|zt;
  elseif fdet==2;
   zt=(1-rho0)*ones(rows(dy),1) ~ (rho0+(1-rho0)*seqa(2,1,rows(dy)));
   zt0=ones(1,2)|zt;
  endif;
   b0hat=invpd(zt0'*zt0)*(zt0'*qy0); qy0t=qy0-zt0*b0hat;
   sqy0=(qy0t'*qy0t)/nobs;

 endif;

retp(sqy0);
endp;



proc(1)=poi(y,fdet,rho0,rhot,w2);
local tv0, tva, fti;

tv0=tvar(y,fdet,rho0);
tva=tvar(y,fdet,rhot);
@fti=rows(y)*((tva-(rhot*tv0))./w2);@
fti=rows(y)*((tva-((rhot/rho0)*tv0))./w2);
retp(fti);
endp;
/*
@ debug @
#include c:\gauss\src\pctile1a.prc;
rndseed 93939;
@ debug @
nobs=100;
fdet=1;
alp0=1+(3)/nobs;
alp1=1+(3.477)/nobs;
alp2=1+(-1)/nobs;
a=zeros(100,3);
i=1; do until i>rows(a);
alp=1+(3)/nobs;
eps=rndn(nobs,1);
if alp<1;
u0=rndn(1,1)*sqrt(1/(1-alp*alp));
else; u0=0; endif;
yt=recserar(eps,u0,alp);
{a[i,1]}=poi(yt,fdet,alp0,alp1,1);
@{a[i,2]}=poi(yt,fdet,alp0,alp2,1);@
i=i+1; endo;
@meanc((a[.,1].<-3.251)+(a[.,1].>7.0907));
meanc((a[.,2].<-0.94)+(a[.,2].>3.38387));
meanc((a[.,1].<-2.45)+(a[.,2].<-1.57));@
{junk,a1}=pctile(a[.,1]);
a1';
@{junk,a1}=pctile(a[.,2]);
a1';@
*/
