#include cfpt1.prc;
#include cfpt1u.prc;
#include cfpt2.prc;
#include cfpt2u.prc;

library pgraph;
/* GE AUg 97 proc to compute the p-value for the PT statistic
   The numerical integration uses Simpsons Rule with n nodes
   and the infinite integral is approximated with and integral
   to b.


  Inputs:

    stat      -    value of the computed statistic for SB
    c         -    true value of c where root = 1-c/T  (scalar)
    fdet      -    detrending flag = 1 for constant, 2 for constant and trend
    x0        -    if 0 has X(0)=0 otherwise from unconditional dist

   Output

    pvalue    - P[ PT < stat ] given true c as dgp
*/


proc(1) = p_pt(stat,c,cbar,fdet,x0);
local b, n, h, u, theta, x, cf, i, c1, ic,
      c2, g0, g1, g2, g3, ss, s1, s2, fx;


@ range of theta to consider @
if fdet==1;
if c<2.5;
b=40;
elseif c<3;
b=25;
elseif c<12;
b=25;
elseif c<17;
b=30;
elseif c<33;
b=40;
else;
b=50;
endif;
else;
b=55;
endif;

n=5000;                         @ number of nodes for Simpsons Rule @
h=b/(2*n);                      @ width of each section being approximated @
u=seqa(1,1,2*n)*h;              @ sequence of values between approx's @
theta=(u.*u);
x=stat;                         @ value of the statistic @

@ construct characteristic function @
if x0==0;
if fdet==1;
cf=cfpt1(theta,c,cbar);
else;
cf=cfpt2(theta,c,cbar);
endif;
else;
if fdet==1;
cf=cfpt1u(theta,c,cbar);
else;
cf=cfpt2u(theta,c,cbar);
endif;
endif;

@ Get the signs right @
i=2; do until i>rows(theta);
c1=abs(cf[i-1,1]+cf[i,1]);
c2=abs(cf[i-1,1]-cf[i,1]);
if c1<=c2; cf[i,1]=-1*cf[i,1]; endif;
i=i+1; endo;


@ Computation of g(u,x) for given x  @
@ use change of variables so that g(0)=0 @
g0=1-exp((-sqrt(-1)*(x/(cbar*cbar))).*theta);
g1=sqrt(-1).*u;
g2=(2.*g0)./g1;
g3=real(g2.*cf)./pi;

    @   xy(u,g3);@   @ graphs function to be integrated @


/* Compute Integral using Simpsons rule */
ss=reshape(g3,rows(g3)/2,2);
s1=(ss[.,1]'ones(rows(ss),1));
s2=(ss[.,2]'ones(rows(ss),1));
fx=(4*s1+2*s2+g3[rows(g3),1])*(h/3);

retp(fx);
endp;


@ debug @
/*tt1=hsec;
c=0|5|10|15|20; c=0;
x0=0;      @ set to 0 for X(0)=0, 1 for unconditional dist @
fdet=1;
cbar=-7;
zc0=zeros(rows(c),1);
ic=1; do until ic>rows(c);
zc0[ic,1]=p_pt(18.101,c[ic,1],cbar,fdet,x0);  @ 2.8476 5.7045 @
ic=ic+1; endo;
format /RDN 12,8;
c~zc0;
  */
@tt2=hsec;ttd=tt2-tt1; etstr(ttd);@

@ Critical Values  - Demeaned case                              @
@ cbar = -7                                                    @
@  true c       2.5      5       50       95        97.5    b   @
@   -1       @
@    0                 3.3054 @
@    5       @
@    10      @
@    15      @
@    20      @
@ Critical Values  - Detrended case                             @
@ cbar = -13.5                                                  @
@  true c       2.5      5       50       95        97.5    b   @
@   -1                                                          @
@    0                 5.7045                                   @
@    5     @
@    10    @
@    15    @
@    20          @
