#include cfdf10.prc;
#include cfdf00.prc;
#include cfdf20.prc;
library pgraph;
/* GE AUg 97 proc to compute the p-value for the DF-rho statistic */

proc(1) = p_df(stat,c,fdet);
local b, n, h, u, theta, x, cf, i, c1, ic,
      c2, g3, ss, s1, s2, fx;


@ range of theta to consider @
if c<3;
if stat<-20;
b=10;
elseif stat<-10;
b=15;
elseif stat<-2;
b=20;
else;
b=25;
endif;
elseif c<12;
b=20;
elseif c<13;
b=25;
elseif c<33;
b=30;
else;
b=35;
endif;
b=70;
n=5000;
h=b/(2*n);
u=seqa(1,1,2*n)*h;
theta=(u.*u);
x=stat;

@ construct characteristic function @
if fdet==1;
cf=cfdf10(theta,c,x);
elseif fdet==0;
cf=cfdf00(theta,c,x);
else;
cf=cfdf20(theta,c,x);
endif;



@ Get the signs right @
i=2; do until i>rows(theta);
c1=abs(cf[i-1,1]+cf[i,1]);
c2=abs(cf[i-1,1]-cf[i,1]);
if c1<=c2; cf[i,1]=-1*cf[i,1]; endif;
i=i+1; endo;


/* Computation of g(u,x) for given x  */
g3=(2*imag(cf))./(pi.*u);

@        xy(u,g3);@
ss=reshape(g3,rows(g3)/2,2);


/* Compute Integral using Simpsons rule */
s1=(ss[.,1]'ones(rows(ss),1));
s2=(ss[.,2]'ones(rows(ss),1));
fx=(4*s1+2*s2+g3[rows(g3),1])*(h/3);
fx=0.5+fx;

retp(fx);
endp;


@ debug @
/*tt1=hsec;
c=0|5|10|15|20;c=10;
fdet=1;
zc0a=zeros(rows(c),1);
ic=1; do until ic>rows(c);
zc0a[ic,1]=p_df(-2,c[ic,1],fdet);  @ -6.4334 @
ic=ic+1; endo;
format /RDN 12,8;
c~zc0a;
*/
@tt2=hsec;ttd=tt2-tt1; etstr(ttd);@

