/*  linreg.prc - does OLS and returns beta,t(beta) */

proc(5) = linreg(y,x,fdet,h0,arlag);

local zzi, zy, bn, res, ybar, tss, rss, ess, vb, tb, r2,
      om ,se;
if fdet == 1;
 x=ones(rows(x),1)~x;
 elseif fdet == 2;
 x=ones(rows(x),1)~seqa(1,1,rows(x))~x;
 else;
 x=x;
endif;

zzi=invpd(x'x); zy=x'y;
bn=zzi*zy;
res=y-x*bn;
if fdet == 0;
 ybar=y;
 else;
 ybar=y-meanc(y);
endif;

tss=ybar'ybar;
rss=res'res;
ess=tss-rss;
if arlag == 0;
vb=(rss/(rows(res)-cols(x)))*zzi;
else;
{om} = arvcv(x,res,1,rows(x),arlag);
vb=rows(x)*zzi*om*zzi;
endif;
se=sqrt(diag(vb));
tb=(bn-h0)./(sqrt(diag(vb)));
r2=1-(rss/tss);

retp(bn,tb,se,r2,res);
endp;
@---------------------------------------------------------------@
proc(4) = linreg1(y,x,fdet,h0,ls);

local zzi, zy, bn, res, ybar, tss, rss, ess, vb, tb, r2,
      y1, s2, xxi, vb2, lsi, se;
/*
if fdet == 1;
 x=ones(rows(x),1)~x;
 elseif fdet == 2;
 x=ones(rows(x),1)~seqa(1,1,rows(x))~x;
 else;
 x=x;
endif;
  */
@ GLS transformation @
y1=ls*y;
x=ls*x;

zzi=invpd(x'x); zy=x'y1;
bn=zzi*zy;
res=y1-x*bn;
if fdet == 0;
 ybar=y;
 else;
 ybar=y-meanc(y);
endif;
tss=ybar'ybar;
rss=res'res;
ess=tss-rss;
s2=rss/(rows(res)-cols(x));
tb=(bn-h0)./(sqrt(diag(zzi)));
se=sqrt(diag(zzi));
r2=1-(rss/tss);
retp(bn,se,r2,res);
endp;


@---------------------------------------------------------------@
proc(1) = linreg2(y,x,fdet,h0);

local zzi, zy, bn, res;
/*
if fdet == 1;
 x=ones(rows(x),1)~x;
 elseif fdet == 2;
 x=ones(rows(x),1)~seqa(1,1,rows(x))~x;
 else;
 x=x;
endif;
  */
zzi=invpd(x'x); zy=x'y;
bn=zzi*zy;
res=y-x*bn;

retp(res);
endp;
@---------------------------------------------------------------@
proc(3) = linreg3(y,x,fdet,h0,ls);

local zzi, zy, bn, res, ybar, tss, rss, ess, vb, tb, r2,
      x1, y1, s2;
/*
if fdet == 1;
 x=ones(rows(x),1)~x;
 elseif fdet == 2;
 x=ones(rows(x),1)~seqa(1,1,rows(x))~x;
 else;
 x=x;
endif;
  */
@ GLS transformation @
if rows(ls)>1;
    @ using known ls @
@ls=inv(ls);@
y1=ls*y;
x1=ls*x;
else;
    @ estimated vcv @
@ not programmed yet@
endif;

zzi=invpd(x1'x1); zy=x1'y1;
bn=zzi*zy;
res=y-x*bn;
if fdet == 0;
 ybar=y;
 else;
 ybar=y-meanc(y);
endif;

tss=ybar'ybar;
rss=res'res;
ess=tss-rss;
s2=rss/(rows(res)-cols(x));
vb=invpd(x1'x1);
tb=(bn-h0)./(sqrt(diag(vb)));
r2=1-(rss/tss);

retp(y1,x,res);
endp;




/*
@ debug @
h0=0|(0.5);
bn=zeros(100,2);vb=bn;
i=1; do until i>100;
x=rndn(100,1);
y=0.5*x+rndn(100,1)/2;
{a1,a2}=linreg(y,x,1,h0);
bn[i,.]=a1';
vb[i,.]=a2';
i=i+1; endo;
meanc(bn);
meanc(vb.>1.645);*/
