@ ITESTSr.PRC
  a compendium of unit root test procedures
@

@ SPECD.PRC
  Construct spectral density estimator at freq zero
@
proc specd(y,itype,nlags);
local dy, s0hat, nobs, n1, nt, y1, x1, ilags,
      b, u, seesq, c1, weights, z, gamx, kmax,
      rhohat, alphahat, sthat, st, xx9, n2t;


@ ********* AR spectral estimator ******@
if nlags==0;
 if itype<3;
  dy=y[2:rows(y),.]-y[1:(rows(y)-1),.];
  s0hat=stdc(dy);
 elseif itype==3; s0hat=stdc(y)|rows(y);
 endif;
else;
 if itype==1;
  nobs=rows(y);
  if nlags<0; nlags=fix(4*((nobs/100)^.33)); endif;
  n1=nlags+2;nt=nobs-n1+1;
  y1=y[n1:nobs,.];
  x1=ones(nt,1)~y[(n1-1):(nobs-1),.];
  ilags=1;do until ilags > nlags ;
   x1=x1~(y[(n1-ilags):(nobs-ilags),1]-y[(n1-ilags-1):(nobs-ilags-1),1]) ;
  ilags=ilags+1; endo ;
  b=invpd(x1'*x1)*(x1'*y1);
  u=y1-x1*b;seesq=(u'*u)/(rows(u)-nlags-2);
  c1=1/(1-sumc(b[3:rows(b),1])); s0hat=abs(c1)*(seesq^.5);
  @format 8,4;seesq b[2,1] sumc(b[3:rows(b),.]) c1 s0hat;@

@ ******* sum-of-covariances spectral estimator - quasidifferences *******@
 elseif itype==2;
  if nlags<0; nlags=fix(6*((rows(y)/100)^.25)); endif;
  weights=ones(nlags,1);weights=1-cumsumc(weights)/(nlags+1);
  y1=y[2:rows(y),.];x1=ones(rows(y)-1,1)~y[1:(rows(y)-1),.];
  b=invpd(x1'*x1)*(x1'*y1); z=y1-x1*b;
  gamx=zeros(nlags+1,1);ilags=0; do until ilags>nlags;
    gamx[ilags+1,1]=(z[(ilags+1):rows(z),.]'*z[1:(rows(z)-ilags),.])/rows(y);
  ilags=ilags+1; endo;
  s0hat=gamx[1,1]+2*sumc(gamx[2:rows(gamx),.].*weights);
  s0hat=sqrt(abs(s0hat));
  @format 8,4;nlags rows(gamx) gamx[1,1] s0hat; weights'; gamx';@
  s0hat=sqrt(abs(s0hat));

@ ******* sum-of-covariances spectral estimator - first differences *******@
 elseif itype==3;
  z=y;
  if nlags<0;        @ Automatic 'plug-in' Andrews/Parzen kernel @
   kmax=abs(nlags);
   rhohat=(z[2:rows(z),.]'*z[1:(rows(z)-1),.])
           /(z[1:(rows(z)-1),.]'*z[1:(rows(z)-1),.]);
   alphahat=4*rhohat*rhohat/((1-rhohat)^4);
   sthat=2.6614*((alphahat*rows(z))^(0.2));
   st=minc(sthat|(kmax*(rows(z)/100)^(0.2)));
   if floor(st)>1; xx9=cumsumc(0|ones(floor(st),1)); xx9=xx9/st;
   else; xx9=0; endif;
   weights = (1-6*(xx9.*xx9)+6*abs(xx9.^3)).*(xx9.<=0.5)
          + 2*((1-abs(xx9)).^3).*(xx9.>0.5);
  @rhohat sthat st (2*sumc(weights)-weights[1,1]); xx9~weights;@
  else;
    weights=cumsumc(0|ones(nlags+1,1)); weights=rev(weights);
    weights=weights./weights[1,.];
  endif;
  n2t=rows(z)/((2*sumc(weights))-weights[1,1]);
  gamx=zeros(rows(weights),1);ilags=0; do until ilags==rows(weights);
    gamx[ilags+1,1]=(z[(ilags+1):rows(z),.]'*z[1:(rows(z)-ilags),.])/rows(z);
  ilags=ilags+1; endo;
  s0hat=gamx.*weights; s0hat=2*sumc(s0hat)-s0hat[1,1];
  s0hat=sqrt(abs(s0hat));
  @format 8,4;nlags rows(gamx) gamx[1,1] s0hat; weights'; gamx';@

 endif;
endif;
retp(s0hat);
endp;

@ Detrend           JHS 4/25/90
   Detrends data
@
proc detrend(y,fdet);
local z, xxi, xy, b, x,n;
n=rows(y);
if fdet == 1; x=ones(n,1); elseif fdet == 2; x=ones(n,1)~seqa(1,1,n);
   else; x=zeros(n,1); endif;
if sumc(sumc(x)).ne.0;
 if cols(x)==1;
  z=y-meanc(y);
 elseif cols(x)==2;
  xxi=invpd(x'x); xy=x'y; b=xxi*xy; z=y-x*b;
 endif;
else; z=y;endif;
retp(z);
endp;

@ Detrndsb           JHS 4/25/90
   Detrends data using Sargan-Bhargava detrending
@
proc detrndsb(y,x);
local n, z;
n=rows(y);
if sumc(sumc(x)).ne.0;
 if cols(x)==1;
  z=y-meanc(y);
 elseif cols(x)==2;
  z = y - ((x[.,2]-1)/(n-1))*y[n,1] - ((n-x[.,2])/(n-1))*y[1,1]
          - (meanc(y)-.5*(y[1,1]+y[n,1]));
 endif;
else; z=y; endif;
retp(z);
endp;

@ Dtrndgls      GE Aug 92
    Detrends using GLS detrending
@
proc(1) = dtrndgls(y,fdet);
local nobs, yd, rhot, qy, qya, zt, zta, b0hat;
 nobs=rows(y);
  if fdet==0;
  @ no deterministic     @
  yd=y;
 elseif fdet==1;
  @ deterministic = (1)  @
  rhot=1+(-7)/rows(y);
 qy=y[2:rows(y),1]-rhot*y[1:(rows(y)-1),1];
 qya=y[1,1]|qy;
  zt=(1-rhot)*ones(rows(qy),1); zta=1|zt;
@  zta=(1|zeros(rows(zt),1)) ~ zta;@
  b0hat=invpd(zta'*zta)*(zta'*qya);
  yd=y-ones(rows(y),1)*b0hat;
 elseif fdet==2;
  @ deterministic = (1,t) @
 rhot=1+(-13.5)/rows(y);
 qy=y[2:rows(y),1]-rhot*y[1:(rows(y)-1),1];
 qya=y[1,1]|qy;
  zt=(1-rhot)*ones(rows(qy),1) ~ (rhot+(1-rhot)*seqa(2,1,rows(qy)));
  zta=(1~1)|zt;
  b0hat=invpd(zta'*zta)*(zta'*qya);
  yd=y-(ones(nobs,1)~seqa(1,1,nobs))*b0hat;
 endif;
 retp(yd);
 endp;


@ ------------------- Unit Root Test Statistics ---------------------------@

@ ADF                    JHS 4/20/90
 computes Dickey-Fuller test statistics
  y = data series, x = deterministic terms (matrix), p = no. of lags of diffs
@
proc(3)= ADF(y,fdet,p);
local n, x, nlags, dy, z, yp, ip, zzi, zy,
      b, u, s, ao, a1, nrhohat, c, what, t;
n=rows(y);
if fdet == 1; x=ones(n,1); elseif fdet == 2; x=ones(n,1)~seqa(1,1,n);
   else; x=zeros(n,1); endif;
if p<0; nlags=fix(4*((n/100)^.33)); endif;
dy = 0|(y[2:n,1]-y[1:(n-1),1]);
z=y[(1+p):(n-1),1]; yp=y[(2+p):n,1]-y[(1+p):(n-1),1];
if sumc(sumc(x)).ne.0; z=z~x[(2+p):n,.]; endif;
ip=0; do until ip>=p;
  z=z~dy[(1+p-ip):(n-1-ip),1];
ip=ip+1; endo;
zzi=invpd(z'z); zy=z'yp;
b=zzi*zy;
u=yp-z*b; s=(u'u)/(rows(u)-cols(z));
if sumc(sumc(x)).ne.0; ao=sumc(b[1:1+cols(x),1]); else; ao=b[1,1]; endif;
a1=sumc(b)-ao;
nrhohat=rows(u)*(b[1,1])/(1-a1);
c=b[1,1];
what=s/((1-a1)*(1-a1));
t=(b[1,1])/sqrt(s*zzi[1,1]);
@yp[1:10,.]~z[1:10,.];@
retp(c|t,b,what);
endp;
/*
a=zeros(2,100); i=1; do until i>cols(a);
ut=rndn(101,1);ut=ut[2:101,1]+0.5*ut[1:100,1];
y=recserar(ut,0,0.85);
{a[.,i],junk}=adf(y,1,8);
i=i+1; endo; meanc(a[2,.]'.<-2.86); */

@ PARK1           JHS 4/20/90
  A Park-type test
@
proc park1(y,x);
local n, z, zc, park;
n=rows(y);
z=detrend(y,x);
zc=cumsumc(z);
park=sumc(zc.*zc)/sumc(z.*z);park=park/(n*n);
retp(park);
endp;


@ RS          JKS 4/20/90
   RS statistic:  rescaled range
@
proc rs(y,what);
local n, z, dz, rs;
n=rows(y);
z=y;
dz=z[2:rows(z),1]-z[1:(rows(z)-1),1];
rs=(maxc(z)-minc(z))/sqrt(n);
retp(rs./what);
endp;


@ MSB          JKS 4/20/90
   MSB statistic:  Modified Sargan-Bhargava
@
proc msb(y,what);
local n, z, msb9;
n=rows(y);
z=y;
msb9=(z'z)/(n*n);
msb9=sqrt(msb9)./what;
retp(msb9);
endp;


@ SB          JKS 4/20/90
   SB statistic:  inverse of Sargan-Bhargava statistic
@
proc sb(y,what);
local n, z, dz, sb9;
n=rows(y);
z=y;
dz=z[2:n,.]-z[1:(n-1),.];
sb9=(z'z)/(n*n);
sb9=sqrt(sb9)./what;
retp(sb9);
endp;


@ ZALPH --   Phillips-Perron Zalpha test   JHS 4/25/90
@
proc zalph(y,what);
local nobs, yc0, yc1, w2, alpp, ut, nobs9,
      shatsq, z1, sigdiff, z2;
nobs=rows(y);
yc0=y[2:nobs,.];
yc1=y[1:(nobs-1),.];
 w2=what.*what;
 alpp=(yc1'yc0)/(yc1'yc1) ;
 ut=yc0-alpp*yc1;nobs9=rows(ut);
 shatsq=(ut'ut)/nobs9;
 z1=nobs*(alpp-1)*ones(rows(what),1);
 sigdiff=w2-shatsq*ones(rows(what),1);
 z2=(0.5*(nobs^2)/sumc(yc1.*yc1)).*sigdiff;
retp(z1-z2);
endp;


@ MZALPH                    JHS 4/25/90
   Modified Phillips-Perron Z(alpha) -- set up in g(.) form
@
proc mzalph(z,what);
local nobs, zalph1;
nobs=rows(z);
what=what.*what;
z=(z/sqrt(nobs));
zalph1=0.5*(((z[nobs,1]*z[nobs,1])./what)-1)./(meanc(z.*z)./what);
retp(zalph1);
endp;


@ mZALPH    GE jun92 modified JHS 4/25/90
   Modified Phillips-Perron Z(alpha) -- set up in g(.) form
@
proc lmzalph(z,what);
local nobs, zalph1;
nobs=rows(z);
what=what.*what;
z=z/sqrt(nobs);
zalph1=0.5*(((z[nobs,1]*z[nobs,1])-(z[1,1]*z[1,1])./what)-1)
                        ./(meanc(z.*z)./what);
retp(zalph1);
endp;


@ g2          JHS 4/25/90
    g2 test -- mean of logarithm of abs value
@
proc g2(y,x);
local z, g2;
z=detrend(y,x);
z=z/sqrt(rows(z));
g2=meanc(ln(abs(z)));
retp(g2);
endp;


@ g3         JHS 4/25/90
     g3 test -- weighted sum, with third argument being exponent
@
proc g3(y,x,wexp);
local z, n, w9, g3;
z=detrend(y,x);
n=rows(z);z=z/sqrt(n);
w9=ones(n,1);
if wexp/=0; w9=cumsumc(w9);w9=w9/n;
 if wexp/=1; w9=w9.^wexp; endif;
endif;
g3=meanc(w9.*z);g3=ln(g3*g3);
retp(g3);
endp;


@------------------ Critical Values for selected test stats --------------- @

@ ADFC        JHS 4/20/90
    Exact critical values for ADF
@
proc adfc(x);
local n,typex,y,out9,iy;
n=rows(x); typex=(sumc(sumc(x)).ne.0)*cols(x);
if typex==0;
 let y[5,9] =
  0   0.01  .025  0.05  0.10 0.90 0.95 .975 0.99
 25  -2.66 -2.26 -1.95 -1.60 0.92 1.33 1.70 2.16
 50  -2.62 -2.25 -1.95 -1.61 0.91 1.31 1.66 2.08
100  -2.60 -2.24 -1.95 -1.61 0.90 1.29 1.64 2.03
250  -2.58 -2.23 -1.95 -1.62 0.89 1.29 1.63 2.01
 ;
elseif typex==1;
 let y[3,9] =
  0   0.01  .025  0.05  0.10 0.90 0.95 .975 0.99
 25  -3.75 -3.33 -3.00 -2.63 -0.37  0.00 0.34 0.72
 50  -3.58 -3.22 -2.93 -2.60 -0.40 -0.03 0.29 0.66;
 ;
elseif typex==2;
 let y[3,9] =
  0   0.01  .025  0.05  0.10 0.90 0.95 .975 0.99
 25  -4.38 -3.95 -3.60 -3.24 -1.14 -0.80 -0.50 -0.15
 50  -4.15 -3.80 -3.50 -3.18 -1.19 -0.87 -0.58 -0.24
 ;
else; "Error in X matrix configuration"; endif;

out9=y[rows(y),.];iy=1; do until iy>rows(y);
 if y[iy,1]==n; out9=y[iy,.]; endif;
iy=iy+1; endo;
retp(out9[1,2:cols(out9)]');
endp;

/*
@ PARK1C     JHS 4/20/90
  critical values for park1 test
@
proc park1c(x);
local n, typex, y, out9,iy;
n=rows(x);
typex = x[1,1]*cols(x);
if typex==0;
 let y[4,12]=
    0      0.0250   0.0500   0.1000   0.2000   0.3000   0.5000   0.7000
           0.8000   0.9000   0.9500   0.9750
   50      0.0137   0.0204   0.0298   0.0564   0.0869   0.1462   0.2037
           0.2323   0.2677   0.2968   0.3146
  100      0.0157   0.0213   0.0306   0.0559   0.0863   0.1421   0.1993
           0.2275   0.2652   0.2942   0.3102
  200      0.0140   0.0190   0.0294   0.0539   0.0800   0.1383   0.1932
           0.2239   0.2629   0.2890   0.3063
 ;
elseif typex==1;
 let y[3,9]=
    0   0.01   0.0250 0.0500 0.1000 0.9000 0.9500 0.9750 0.99
   50   0.000  0.0078 0.0101 0.0150 0.0871 0.0912 0.0939 0.00
   90   0.000  0.0080 0.0114 0.0149 0.0879 0.0914 0.0940 0.00 ;
endif;
out9=y[rows(y),.];iy=1; do until iy>rows(y);
 if y[iy,1]==n; out9=y[iy,.]; endif;
iy=iy+1; endo;
out9=y[1,2:cols(y)]|out9[1,2:cols(y)];
retp(out9');
endp;
  */
@ RSC     JHS 4/20/90
  critical values for rescaled range statistic
@
proc rsc(x);
local out9, n, typex, iy, y;
n=rows(x);
typex = x[1,1]*cols(x);
if typex==0;
 let y[4,12]=
   0       0.0250   0.0500   0.1000   0.2000   0.3000   0.5000   0.7000
           0.8000   0.9000   0.9500   0.9750
  50       0.7652   0.8377   0.9223   1.0458   1.1469   1.3477   1.6073
           1.7889   2.0835   2.3623   2.6431
 100       0.7949   0.8714   0.9595   1.0819   1.1863   1.3831   1.6305
           1.8301   2.0906   2.3998   2.6621
 200       0.8403   0.9044   0.9770   1.1217   1.2225   1.4449   1.6845
           1.8497   2.1424   2.3676   2.5835
  ;
elseif typex==1;
 let y[1,12]=
  0  0.0250  0.0500  0.1000  0.2000  0.3000  0.5000  0.7000  0.8000  0.9000
     0.9500  0.9750 ;
endif;
out9=y[rows(y),.];iy=1; do until iy>rows(y);
 if y[iy,1]==n; out9=y[iy,.]; endif;
iy=iy+1; endo;
out9=y[1,2:cols(y)]|out9[1,2:cols(y)];
retp(out9');
endp;

@ MSBC     JHS 4/20/90
  critical values for Modified Sargan-Bhargava statistic
@
proc MSBC(x);
local n, out9, y, iy, typex;
n=rows(x);
typex = x[1,1]*cols(x);
if typex==0;
 let y[4,12]=
     0     0.0250   0.0500   0.1000   0.2000   0.3000   0.5000   0.7000
           0.8000   0.9000   0.9500   0.9750
    50     0.0473   0.0591   0.0781   0.1192   0.1638   0.3104   0.6006
           0.8168   1.2380   1.6949   2.1632
   100     0.0446   0.0560   0.0737   0.1126   0.1580   0.2897   0.5500
           0.8027   1.2881   1.8226   2.3235
   200     0.0437   0.0546   0.0740   0.1135   0.1630   0.2854   0.5253
           0.7851   1.2176   1.6712   2.0293
  ;
elseif typex==1;
 let y[2,12]=
   0       0.0250   0.0500   0.1000   0.2000   0.3000   0.5000   0.7000
           0.8000   0.9000   0.9500   0.9750
   50      0.17405  0.19144  0.21426  0.24894 0.27957  0.34302 0.42787
           0.49094  0.58267  0.66777  0.74723
  ;
else;
 let y[2,12]=
   0       0.0250   0.0500   0.1000   0.2000   0.3000   0.5000   0.7000
           0.8000   0.9000   0.9500   0.9750
   50      0.15250  0.16449  0.18050  0.20415  0.22418  0.26325  0.30843
           0.34229  0.39049  0.433341 0.47113
  ;

endif;
if typex==0;
out9=sqrt(y[rows(y),.]);iy=1; do until iy>rows(y);
 if y[iy,1]==n; out9=sqrt(y[iy,.]); endif;
iy=iy+1; endo;
out9=y[1,2:cols(y)]|out9[1,2:cols(y)];
else;
out9=(y[rows(y),.]);iy=1; do until iy>rows(y);
 if y[iy,1]==n; out9=sqrt(y[iy,.]); endif;
iy=iy+1; endo;
out9=y[1,2:cols(y)]|out9[1,2:cols(y)];
endif;
retp(out9');
endp;


@---------------------------- debugging program ------------------------- @
/*
n=200;
x=ones(n,1);
format 8,4;imc=1; do until imc>10;
 e=rndn(n,1); y=cumsumc(e);
 s0hat=specd(y,1,0);
 v=y/s0hat;
 " ";
 t1=sb(y,x);       "  SB:     " imc s0hat t1';
 t1=msb(v,x);      "  MSB:    " imc s0hat t1';
 t1=adf(y,x,0);    "  ADF:    " imc s0hat t1';
 t1=zalph(y,x,0);  "  Zalph:  " imc s0hat t1';
 t1=mzalph(v,x);   "  MZalph: " imc s0hat t1';
 t1=rs(y,x);       "  RS:     " imc s0hat t1';
 t1=g2(y,x);       "  g2:     " imc s0hat t1';
 t1=g3(y,x,1);     "  g3:     " imc s0hat t1';
imc=imc+1;endo;
*/
/*
imc=1; do until imc>10; format 12,6;
u=rndn(1000,1);
y=recserar(u,u[1,1],0.75);
s0hat=specd(y,3,-20);s0hat';
imc=imc+1;endo;
*/



