/* GE mar95 proc to compute impulse responses for a VAR system */


proc(1)=impuls(amat,nir,eqq,fdet);

@      amat     : A(L) matrix in form coming out of VAR.PRC
       nir      : Number of periods to calculate implulse response
       eqq      : number of equation to be shocked
       fdet     : Number of deterministics in VAR estimation
@
local n, k, shck, yi, rir, yis, yi1 ;

amat=amat[fdet+1:rows(amat),.];      @ remove constant vector @
n=cols(amat);
k=rows(amat)/n;

@ compute impulse response for each of the n shocks @

shck=zeros(n,1);shck[eqq,1]=1;
yi=zeros(n,k)~shck;
 rir=1; do until rir>nir-1;
   yis=yi[.,cols(yi)-k+1:cols(yi)];
   yis=rev(yis')';
   yi1=amat'vec(yis);
   yi=yi~yi1;
 rir=rir+1; endo;

retp(yi[.,k+1:cols(yi)]);
endp;

/*
@ Debug @
nir=20;eqq=1;ahat=0|0.5;
{oo}=impuls(ahat,nir,eqq,1);
eps=rndn(10,1);
y=recserar(eps,eps[1,1],0.5);
epss=eps~(0|eps[1:rows(eps)-1,1]);
ys=epss*oo[.,1:2]';
epsss=epss~(0|0|eps[1:rows(eps)-2,.]);
yss=epsss*oo[.,1:3]';
y~ys~yss;
*/
@{oo}=impuls(bhat,3,1,1)@


