
@ Dtrndgls      GE Aug 92
    Detrends using GLS detrending
@
proc(1) = dtrndgls(y,fdet);
local nobs, yd, rhot, qy, qya, zt, zta, b0hat;
 nobs=rows(y);
  if fdet==0;
  @ no deterministic     @
  yd=y;
 elseif fdet==1;
  @ deterministic = (1)  @
  rhot=1+(-7)/rows(y);
 qy=y[2:rows(y),1]-rhot*y[1:(rows(y)-1),1];
 qya=y[1,1]|qy;
  zt=(1-rhot)*ones(rows(qy),1); zta=1|zt;
@  zta=(1|zeros(rows(zt),1)) ~ zta;@
  b0hat=invpd(zta'*zta)*(zta'*qya);
  yd=y-ones(rows(y),1)*b0hat;
 elseif fdet==2;
  @ deterministic = (1,t) @
 rhot=1+(-13.5)/rows(y);
 qy=y[2:rows(y),1]-rhot*y[1:(rows(y)-1),1];
 qya=y[1,1]|qy;
  zt=(1-rhot)*ones(rows(qy),1) ~ (rhot+(1-rhot)*seqa(2,1,rows(qy)));
  zta=(1~1)|zt;
  b0hat=invpd(zta'*zta)*(zta'*qya);
  yd=y-(ones(nobs,1)~seqa(1,1,nobs))*b0hat;
 endif;
 retp(yd);
 endp;
@-------------------------------------------------------------------------@
@ ADF                    JHS 4/20/90 rewritten GE 92
 computes Dickey-Fuller test statistics
  y = data series, x = 0,1,2 is no det, mean, mean and time,
   p = no. of lags of diffs
@
proc(2)= ADF(y,fdet,p);
local n, x, nlags, dy, z, yp, ip, zzi, zy,
      b, u, s, ao, a1, nrhohat, c, what, t;
n=rows(y);
if fdet == 1; x=ones(n,1); elseif fdet == 2; x=ones(n,1)~seqa(1,1,n);
   else; x=zeros(n,1); endif;
if p<0; nlags=fix(4*((n/100)^.33)); endif;
dy = 0|(y[2:n,1]-y[1:(n-1),1]);
z=y[(1+p):(n-1),1]; yp=y[(2+p):n,1]-y[(1+p):(n-1),1];
if sumc(sumc(x)).ne.0; z=z~x[(2+p):n,.]; endif;
ip=0; do until ip>=p;
  z=z~dy[(1+p-ip):(n-1-ip),1];
ip=ip+1; endo;
zzi=invpd(z'z); zy=z'yp;
b=zzi*zy;
u=yp-z*b; s=(u'u)/(rows(u)-cols(z));
if sumc(sumc(x)).ne.0; ao=sumc(b[1:1+cols(x),1]); else; ao=b[1,1]; endif;
a1=sumc(b)-ao;
nrhohat=rows(u)*(b[1,1])/(1-a1);
c=b[1,1];
what=s/((1-a1)*(1-a1));
t=(b[1,1])/sqrt(s*zzi[1,1]);
@yp[1:10,.]~z[1:10,.];@
retp((nrhohat)|t,what);
endp;

@-------------------------------------------------------------------------@
@ RHO                    JHS 4/20/90 rewritten GE 92
 computes estimate of largest root
  y = data series, fdet = 0,1,2 is no det, mean, mean and time,
   p = no. of lags of diffs
@
proc(1)= rhoar(y,fdet,p);
local n, x, nlags, dy, z, yp, ip, zzi, zy,
      b, u, s, ao, a1, nrhohat, c, what, t;
n=rows(y);
if fdet == 1; x=ones(n,1); elseif fdet == 2; x=ones(n,1)~seqa(1,1,n);
   else; x=zeros(n,1); endif;
if p<0; nlags=fix(4*((n/100)^.33)); endif;
dy = 0|(y[2:n,1]-y[1:(n-1),1]);
z=y[(1+p):(n-1),1]; yp=y[(2+p):n,1]-y[(1+p):(n-1),1];
if sumc(sumc(x)).ne.0; z=z~x[(2+p):n,.]; endif;
ip=0; do until ip>=p;
  z=z~dy[(1+p-ip):(n-1-ip),1];
ip=ip+1; endo;
zzi=invpd(z'z); zy=z'yp;
b=zzi*zy;
u=yp-z*b; s=(u'u)/(rows(u)-cols(z));
if sumc(sumc(x)).ne.0; ao=sumc(b[1:1+cols(x),1]); else; ao=b[1,1]; endif;
a1=sumc(b)-ao;
nrhohat=rows(u)*(b[1,1])/(1-a1);
c=b[1,1];
what=s/((1-a1)*(1-a1));
t=(b[1,1])/sqrt(s*zzi[1,1]);
@yp[1:10,.]~z[1:10,.];@
retp(b[1,1]+1);
endp;


@--------------------------------------------------------------------------@
@ JS/GE proc Aug92 to estimate PT statistic @
proc (1)=penv3r(y,fdtrend,rhot,what);
 local nobs, dy, qy, qya, sdy, sqy, dyt, zt,
       zta, b0hat, qyat, ft, w2, fti;
 nobs=rows(y);
 dy=y[2:rows(y),1]-y[1:(rows(y)-1),1];
 qy=y[2:rows(y),1]-rhot*y[1:(rows(y)-1),1];
 qya=y[1,1]|qy;
 if fdtrend==0;
  @ no deterministic     @
  sdy=(dy'*dy)/nobs; sqy=(qya'*qya)/nobs;
 elseif fdtrend==1;
  @ deterministic = (1)  @
  dyt=dy;    @ OLS detrending under null @
  zt=(1-rhot)*ones(rows(qy),1); zta=1|zt;
 elseif fdtrend==2;
  @ deterministic = (1,t) @
  dyt=dy-meanc(dy);    @ OLS detrending under null @
  zt=(1-rhot)*ones(rows(qy),1) ~ (rhot+(1-rhot)*seqa(2,1,rows(qy)));
  zta=(1~1)|zt;
 endif;
 if fdtrend>=1;
  sdy=(dyt'*dyt)/nobs;
  b0hat=invpd(zta'*zta)*(zta'*qya); qyat=qya-zta*b0hat;
  sqy=(qyat'*qyat)/nobs;
 endif;
 ft=nobs*(sqy-sdy);
 w2=what.*what;
 fti=nobs*((sqy-rhot*sdy)./w2);
retp(fti);
endp;
