/*   5/92 proc to lookup and interpolate critical values from
     a matrix.  Takes test stat value and matrix as arguments
     and lineraly interpolates down first column, returning
     entire sequence (ie interpolated row) of critical values


     Input :  xs  -  value of test statistic
              cvm -  critical value matrix where column one
                     contains values of xs and subsequent
                     columns critical values for various size

     Output:  cv  -  interpolated row of critical values
*/

proc (1) = crlk(xs,cvm);

  local cv, rn, rl, sc;

@ ----- work out between which rows xs occurs -----------@
 if xs<cvm[1,1]; cv=cvm[1,2:cols(cvm)];
   elseif  xs>cvm[rows(cvm),1]; cv=cvm[rows(cvm),2:cols(cvm)];
   else;
   rn=minindc(abs(xs*ones(rows(cvm),1)-(cvm[.,1])));
   if xs>cvm[rn,1]; rl=rn; else; rl=rn-1 ; endif;


@ ------ do the interpolation ---------------------------@

   if xs==cvm[rn,1]; cv=cvm[rn,2:cols(cvm)];
     else;
     sc=(xs-cvm[rl,1])/(cvm[rl+1,1]-cvm[rl,1]);
     cv=cvm[rl,2:cols(cvm)]+sc*(cvm[rl+1,2:cols(cvm)]-cvm[rl,2:cols(cvm)]);
   endif;

endif;

retp(cv);
endp;

/*
@  debug  @
xs1=3.34;xs2=3.3;
{cv1}=crlk(xs1,cvm);
{cv2}=crlk(xs2,cvm);
xs1;cv1;
xs2;cv2;
  */

/*  lint.prc GE Oct92 program to do linear interpolations */
/*
proc(1) = lint(x,yv,xv);
local yl, yu, xl, xu, ye;

/*   inputs :
        x    = value between known points
        yv   = vector (lower then upper) of value to be est at known points
        xv   = vector (lower then upper) of value at known points
     output
        y    = y value corresponding to the x input
*/

    yl=yv[1,1];     yu=yv[2,1];
    xl=xv[1,1];     xu=xv[2,1];
    ye=yu - (yu-yl)*((xu-x)/(xu-xl));
    retp(ye);
    endp;
/*
 /* debug */
x=1;
xv=0|2;
yv=3|5;
lint(x,yv,xv);
*/  */
