/* Feb 99. Program to compute the CI for the Pt statistic through
the use of the characteristic function

Input:
    x       : Value for Pt statistic
    fdet        : 0 for no constant, 1 for constant
    lpv     : lower tail for CI
    upv     : upper tail for CI
    cbar    : Alternative for c
    x0      : initial condition. If x0=0 initial condition is 0,
            otherwise x(0) is from unconditional distribution
Output
    ci  : c1|c2 confidence rejon
    pv1 : lower p-value for c1
    pv2 : upper p-value fro c2

Note: the step in the second round search is optimal only
for that particular first round step: need to changed if the
first round is changed.

*/

#include p_pt.prc;
#include crlk.prc;

proc(3)=ci_pt(x,fdet,lpv,upv,cbar,x0);

local   cr, pvmat, ic, sel1, i0, cr1, i1, cr2 ,c1,c2, pvmatold,
        step,i,ll, pv1, pv2,pv11,pv22 ;


cr=seqa(-10,10,10);  @NOTE: if c is too small p_df give as a results     @
                @ a p-value of 0.5 no matter the value of the test@

pvmat=0;

ic=1; do until ic>rows(cr);
pvmat=pvmat|p_pt(x,cr[ic,1],cbar,fdet,x0); pvmat[ic+1,1]~cr[ic,1];

if pvmat[ic+1,1] >=1; break;
   else; ic=ic+1;
endif;
endo;

pvmat=pvmat[2:rows(pvmat),.];
cr=cr[1:rows(pvmat),1];

pvmat=pvmat~cr;


sel1=(floor(1000*pvmat[.,1]).<fix((1000*lpv)));
i0=sumc(ones(rows(pvmat),1).*sel1);              @ row for chosen size @
c1=crlk(lpv,pvmat[i0:i0+1,.]);
pv11=p_pt(x,c1,cbar,fdet,x0);


sel1=(floor(1000*pvmat[.,1]).<fix((1000*upv)));
i1=sumc(ones(rows(pvmat),1).*sel1);i1;              @ row for chosen size @
c2=crlk(upv,pvmat[i1:i1+1,.]);
pv22=p_pt(x,c2,cbar,fdet,x0);

pvmatold=pvmat;

/*------------second round--------*/
step=5;
ll=3;

i=1; do until i>10;
" round #";;i;

cr1=pvmat[i0:i0+1,2];
cr2=pvmat[i1:i1+1,2];
cr=seqa(cr1,step,ll)|seqa(cr2,step,ll);

pvmat=zeros(rows(cr),1);
ic=1; do until ic>rows(cr);
pvmat[ic,1]=p_pt(x,cr[ic,1],cbar,fdet,x0);  x~pvmat[ic,1]~cr[ic,1];
ic=ic+1; endo;


pvmat=pvmat~cr;
sel1=(floor(1000*pvmat[.,1]).<fix((1000*lpv)));
i0=sumc(ones(rows(pvmat),1).*sel1);              @ row for chosen size @
c1=crlk(lpv,pvmat[i0:i0+1,.]);
pv11=pv11|p_pt(x,c1,cbar,fdet,x0);

sel1=(floor(1000*pvmat[.,1]).<fix((1000*upv)));
i1=sumc(ones(rows(pvmat),1).*sel1);i1;              @ row for chosen size @
c2=crlk(lpv,pvmat[i1:i1+1,.]);
pv22=pv22|p_pt(x,c2,cbar,fdet,x0);


if abs(pv11[rows(pv11),.]-lpv)<0.005
  and abs(pv22[rows(pv22),.]-upv)<0.005;
break;
else; i=i+1;
step=step/2;
endif;
endo;


cr1=crlk(lpv,pvmat[i0:i0+1,.]);
cr2=crlk(upv,pvmat[i1:i1+1,.]);
pv1=p_pt(x,cr1,cbar,fdet,x0);
pv2=p_pt(x,cr2,cbar,fdet,x0);

retp(cr1|cr2,pv1,pv2);

endp;


@debug@
/*x=10;
dfet=1;
lpv=0.025;
upv=0.975;
cbar=-10;
x0=0;

{ cc,pp1,pp2}=ci_pt(x,fdet,lpv,upv,cbar,x0);
 */












