/* GE Jan98 (revision of Aug97 program)

   Proc to compute characteristic function for QT stat for
   null of unitroot and alternative (cbar) models.
   Statistics have GLS detrending with X(0)=0 assumed (ERS)
   as appropriate when a constant and time trend are included
   in the specification.  This version has X(0) from unconditional dist.

   Format:

    {cf}=cfpt2u(theta,c,cbar);

   Inputs:

    theta     -    nx1 vector of values of theta in E[exp{i*theta*stat}]
    c         -    true value of c where root = 1-c/T  (scalar)
    cbar      -    value for c for the detrending

   Output

    cf        - characteristic function of MSB(cbar) at each theta
                (nx1) vector

   This procedure is designed to be run by p_pt.prc
   results checked against MC results in MPTU2.PRC and PENV3R.PRC

*/

proc(1)=cfpt2u(theta,c,cbar);
local th1, bet, ba, t1, eb, e2b, s11, s12,
      s13, s22, s23, s33, s14, s24, s34, s44,
      lam, d, l11, l12, l13, l14, l31, l21,
      l41, l22, l23, l32, l24, l42, l34, l43,
      l33, l44, a11, a12, a13, a14, a21, a22,
      a23, a24, a31, a32, a33, a34, a41, a42,
      a43, a44, p1, p2, p3, p4, dn, cf;

th1=sqrt(-1).*theta;
bet=sqrt(c*c-2.*th1);
ba=bet-c;
t1=(-1*ba/2);
t1=exp(t1);

eb=exp(-1*bet);
e2b=exp(-2*bet);

if c>0;
s11=1/(2*c);
s12=eb./(2*c);
s13=(1-eb)./(2*c*bet);
s22=((1-e2b)./(2*bet))+(e2b/(2*c));
s23=(0.5+((bet./(2*c))-1).*eb + (0.5-(bet/(2*c))).*e2b)./(bet.*bet);
s33=(1+(0.5/c)-(1.5/bet)+((2/bet)-(1/c)).*eb+((0.5/c)-(0.5/bet)).*e2b);
s33=s33./(bet.*bet);
else;
s11=(1-e2b)./(2*bet);
s22=(1-bet^2+(2/3)*bet^3-(bet+1).*(bet+1).*e2b)./(2*bet^5);
s12=(bet-1+(bet+1).*e2b)./(2*bet^3);
endif;

if c>0;
s11=1/(2*c);
s12=eb./(2*c);
s13=(1-eb)./(2*c*bet);
s22=((1-e2b)./(2*bet))+(e2b/(2*c));
s23=(0.5+((bet./(2*c))-1).*eb + (0.5-(bet/(2*c))).*e2b)./(bet.*bet);
s33=(1+(0.5/c)-(1.5/bet)+((2/bet)-(1/c)).*eb+((0.5/c)-(0.5/bet)).*e2b);
s33=s33./(bet.*bet);
s14=(1-(bet+1).*eb)./(2*c*bet^2);
s24=(c*(bet-1)+bet.*eb+(c-bet).*(bet+1).*e2b)./(2*c*bet^3);
s34=((1./(2*c*bet^3))-(1./(2*bet^4))).*(1-eb).*(1-(bet+1).*eb);
s34=s34+(bet-1+eb)./(2*bet^3);
s44=((1/(2*c))-(1./(2*bet))).*((1-(bet+1).*eb)^2)./(bet^4);
s44=s44+(((bet^3)/3)+1-(bet^2)/2-(bet+1).*eb)./(bet^5);

else;
s22=(1-e2b)./(2*bet);
s44=(1-bet^2+(2/3)*bet^3-(bet+1).*(bet+1).*e2b)./(2*bet^5);
s24=(bet-1+(bet+1).*e2b)./(2*bet^3);
endif;

lam=zeros(4,4);
d=(1-cbar)/(1+(cbar*cbar/3)-cbar);
lam[2,2]=(1-cbar)*(1-d);
lam[2,4]=-3*(1-cbar)*(1-d);
lam[4,2]=lam[2,4];
lam[4,4]=9*(1-cbar)*(1-d)-3*cbar*cbar;
lam[1,1]=(cbar*cbar/4)+(1-cbar)*(1-d)/4;
lam[1,2]=(1-cbar)*(1-d)/2;
lam[2,1]=lam[1,2];
lam[1,3]=-cbar*cbar;
lam[3,1]=lam[1,3];
lam[1,4]=(3*cbar*cbar/2)-3*(1-cbar)*(1-d)/2;
lam[4,1]=lam[1,4];
lam=lam/(cbar*cbar);

l11=2*(lam[1,1].*th1)-ba;
l12=2*lam[1,2].*th1;
l13=2*lam[1,3].*th1;
l14=2*lam[1,4].*th1;
l31=l13;l21=l12;l41=l14;
l22=2*(lam[2,2].*th1)+ba;
l23=2*lam[2,3].*th1;l32=l23;
l24=2*lam[2,4].*th1;l42=l24;
l34=2*lam[3,4].*th1;l43=l34;
l33=2*lam[3,3].*th1;
l44=2*lam[4,4].*th1;

if c>0;
 a11=1-(s11.*l11+s12.*l12+s13.*l13+s14.*l14);
 a12=-1*(s11.*l12+s12.*l22+s13.*l23+s14.*l24);
 a13=-1*(s11.*l13+s12.*l23+s13.*l33+s14.*l34);
 a14=-1*(s11.*l14+s12.*l24+s13.*l34+s14.*l44);

 a21=-1*(s12.*l11+s22.*l12+s23.*l13+s24.*l14);
 a22=1-(s12.*l12+s22.*l22+s23.*l23+s24.*l24);
 a23=-1*(s12.*l13+s22.*l23+s23.*l33+s24.*l34);
 a24=-1*(s12.*l14+s22.*l24+s23.*l34+s24.*l44);

 a31=-1*(s13.*l11+s23.*l12+s33.*l13+s34.*l14);
 a32=-1*(s13.*l12+s23.*l22+s33.*l23+s34.*l24);
 a33=1-(s13.*l13+s23.*l23+s33.*l33+s34.*l34);
 a34=-1*(s13.*l14+s23.*l24+s33.*l34+s34.*l44);

 a41=-1*(s14.*l11+s24.*l12+s34.*l13+s44.*l14);
 a42=-1*(s14.*l12+s24.*l22+s34.*l23+s44.*l24);
 a43=-1*(s14.*l13+s24.*l23+s34.*l33+s44.*l34);
 a44=1-(s14.*l14+s24.*l24+s34.*l34+s44.*l44);

p1=a22.*(a33.*a44-a43.*a34)-a23.*(a32.*a44-a42.*a34)+a24.*(a32.*a43-a42.*a33);
p2=a21.*(a33.*a44-a43.*a34)-a23.*(a31.*a44-a41.*a34)+a24.*(a31.*a43-a41.*a33);
p3=a21.*(a32.*a44-a42.*a34)-a22.*(a31.*a44-a41.*a34)+a24.*(a31.*a42-a41.*a32);
p4=a21.*(a32.*a43-a42.*a33)-a22.*(a31.*a43-a41.*a33)+a23.*(a31.*a42-a41.*a32);

dn=a11.*p1-a12.*p2+a13.*p3-a14.*p4;

else;

 a11=1-(s22.*l22+s24.*l42);
 a12=-1*(s22.*l24+s24.*l44);

 a21=-1*(s24.*l22+s44.*l42);
 a22=1-(s24.*l24+s44.*l44);

dn=(a11.*a22-a21.*a12);

endif;

cf=(t1)./sqrt(dn);

retp(cf);
endp;


/*
@  debug @
@#include cfsb1.prc;@
theta=1;
c=5;
cbar=-10;
q1=cfsbo2(theta,c);q1;
@q2=cfsb(theta,c); q2;@
@format /RDN 15,8;
q1-q2;@
  */
