/* GE Jan98 (revision of Aug97 program)

   Proc to compute characteristic function for QT stat for
   null of unitroot and alternative (cbar) models.
   Statistics have GLS detrending with X(0)=0 assumed (ERS)
   as appropriate when a constant and time trend are included
   in the specification.

   Format:

    {cf}=cfpt2(theta,c,cbar);

   Inputs:

    theta     -    nx1 vector of values of theta in E[exp{i*theta*stat}]
    c         -    true value of c where root = 1-c/T  (scalar)
    cbar      -    value for c for the detrending

   Output

    cf        - characteristic function of MSB(cbar) at each theta
                (nx1) vector

   This procedure is designed to be run by p_pt.prc
   results checked against MC results in MPT2.PRC and PENV3R.PRC

*/

proc(1)=cfpt2(theta,c,cbar);
local th1, bet, ba, t1, eb, e2b, s22, s33,
      s23, lam, d, l22, l23, l32, l33, a11,
      a12, a21, a22, dn, cf;

th1=sqrt(-1).*theta;
bet=sqrt(c*c-2.*th1);
ba=bet-c;
t1=(-1*ba/2);
t1=exp(t1);

eb=exp(-1*bet);
e2b=exp(-2*bet);

s22=(1-e2b)./(2*bet);
s33=(1-bet^2+(2/3)*bet^3-(bet+1).*(bet+1).*e2b)./(2*bet^5);
s23=(bet-1+(bet+1).*e2b)./(2*bet^3);

lam=zeros(2,2);
d=(1-cbar)/(1+(cbar*cbar/3)-cbar);
lam[1,1]=(1-cbar)*(1-d);
lam[1,2]=-3*(1-cbar)*(1-d);
lam[2,1]=lam[1,2];
lam[2,2]=9*(1-cbar)*(1-d)-3*cbar*cbar;
lam=lam/(cbar*cbar);

l22=2*(lam[1,1].*th1)+ba;
l23=2*lam[1,2].*th1;l32=l23;
l33=2*lam[2,2].*th1;

 a11=1-(s22.*l22+s23.*l32);
 a12=-1*(s22.*l23+s23.*l33);

 a21=-1*(s23.*l22+s33.*l32);
 a22=1-(s23.*l23+s33.*l33);

dn=(a11.*a22-a21.*a12);

cf=(t1)./sqrt(dn);

retp(cf);
endp;


/*
@  debug @
@#include cfsb1.prc;@
theta=1;
c=5;
cbar=-10;
q1=cfsbo2(theta,c);q1;
@q2=cfsb(theta,c); q2;@
@format /RDN 15,8;
q1-q2;@
  */
