/* GE Jan98 (revision of Aug97 program)

   Proc to compute characteristic function for PT stat for
   null of unitroot and alternative (cbar) models.
   Statistics have GLS detrending under the alternative cbar
   as appropriate when a constant is included
   in the specification.
   This version has X(0)=0

   Format:

    {cf}=cfpt1(theta,c);

   Inputs:

    theta     -    nx1 vector of values of theta in E[exp{i*theta*stat}]
    c         -    true value of c where root = 1-c/T  (scalar)
    cbar      -    alternative value for c for detrending

   Output

    cf        - characteristic function of MSB(cbar) at each theta
                (nx1) vector

   This procedure is designed to be run by p_qt.prc

*/


proc(1)=cfpt1(theta,c,cbar);
local th1, bet, ba, t1, eb, e2b, dn,
      l11, l12, l13, l23, l33, l22, s11, s12, s13,
      s22, s23, s33, a11, a12, a13, a21, a22, a23,
      a31, a32, a33, m1, cf;


th1=sqrt(-1).*theta;
bet=sqrt(c*c-2.*th1);
ba=bet-c;
t1=(-1*ba/2);
t1=exp(t1);

eb=exp(-1*bet);
e2b=exp(-2*bet);

s11=(1-e2b)./(2*bet);
s12=(0.5-1*eb+0.5*e2b)./(bet.*bet);
s22=(bet-1.5+2.*eb-0.5*e2b)./(bet.*bet.*bet);

l22=2*(-1/cbar).*th1+ba;
l23=0.*th1;
l33=l23;


 a11=1-(s11.*l22+s12.*l23);
 a12=-1*(s11.*l23+s12.*l33);
 a21=-1*(s12.*l22+s22.*l23);
 a22=1-(s12.*l23+s22.*l33);
 dn=a11.*a22-a12.*a21;

cf=(t1)./sqrt(dn);

retp(cf);
endp;


/*
@  debug @
#include cfqt0.prc;
theta=seqa(1,1,10);
c=0;
cbar=-10;
q1=cfqt(theta,c,cbar);
q2=cfqt0(theta,cbar);
format /RDN 15,8;
q1-q2;
*/
