/* GE Jan98 (revision of Aug97 program)

   Proc to compute characteristic function for DF rho stat for
   null of unit root models.
   Statistics have OLS detrending
   as appropriate when a constant and time trend are included
   in the specification.

   Format:

    {cf}=cfdf2(theta,c,x);

   Inputs:

    theta     -    nx1 vector of values of theta in E[exp{i*theta*stat}]
    c         -    true value of c where root = 1-c/T  (scalar)
    x         -    value of the  statistic

   Output

    cf        - characteristic function of MSB(cbar) at each theta
                (nx1) vector

*/

proc(1)=cfdf20(theta,c,x);
local th1, bet, ba, t1, eb, e2b, s11, s12,
      s13, s22, s23, s33, s14, s24, s34, s44,
      s32, l11, l12, l13, l14, l31, l21, l41,
      l22, l23, l32, l24, l42, l34, l43, l33,
      l44, a11, a12, a13, a14, a21, a22, a23,
      a24, a31, a32, a33, a34, a41, a42, a43,
      a44, p1, p2, p3, p4, dn, cf;


th1=sqrt(-1).*theta;
bet=sqrt(c*c-2*x.*th1);
ba=bet-c;
t1=((th1-ba)./2);
t1=exp(t1);

eb=exp(-1*bet);
e2b=exp(-2*bet);


if bet[1,1]==0;
s22=1;s23=1/2;s33=1/3;
s44=2/15;s34=5/24;s24=1/3;
else;
s22=(1-e2b)./(2*bet);
s23=(1-2*eb+e2b)./(2*bet.*bet);
s33=(bet-1.5+2.*eb-0.5*e2b)./(bet.*bet.*bet);
s32=s23;
s44=(1-bet^2+(2/3)*bet^3-(bet+1).*(bet+1).*e2b)./(2*bet^5);
s24=(bet-1+(bet+1).*e2b)./(2*bet^3);
s34=(bet^2-bet-1+2*(bet+1).*eb-(bet+1).*e2b)./(2*bet^4);
endif;

l22=(-1.*th1)+ba;
l23=-2.*th1;l32=l23;
l24=6.*th1;l42=l24;
l34=(12*x-12).*th1;l43=l34;
l33=(12-8*x).*th1;
l44=-24*x.*th1;

 a11=1-(s22.*l22+s23.*l32+s24.*l42);
 a12=-1*(s22.*l23+s23.*l33+s24.*l43);
 a13=-1*(s22.*l24+s23.*l34+s24.*l44);

 a21=-1*(s23.*l22+s33.*l32+s34.*l42);
 a22=1-(s23.*l23+s33.*l33+s34.*l43);
 a23=-1*(s23.*l24+s33.*l34+s34.*l44);

 a31=-1*(s24.*l22+s34.*l32+s44.*l42);
 a32=-1*(s24.*l23+s34.*l33+s44.*l43);
 a33=1-(s24.*l24+s34.*l34+s44.*l44);

dn=a11.*(a22.*a33-a23.*a32)-a12.*(a21.*a33-a31.*a23)+a13.*(a21.*a32-a31.*a22);

cf=(t1)./sqrt(dn);

retp(cf);
endp;


/*
@  debug @
@#include cfsb1.prc;@
theta=1;
c=5;
cbar=-10;
q1=cfsbo2(theta,c);q1;
@q2=cfsb(theta,c); q2;@
@format /RDN 15,8;
q1-q2;@
  */
