/* Proc to compute characteristic function for DF T(p-1) stat under
   0LS detrending with y0=0  */

proc(1)=cfdf10(theta,c,x);
local th1, bet, ba, t1, eb, e2b, s11, s12,
      s22, s23, s33, l22, l23, l33, a22, a23,
      a32, a33, dn, cf;

th1=sqrt(-1).*theta;
bet=sqrt(c*c-2*x.*th1);
ba=bet-c;
t1=((th1-ba)./2);
t1=exp(t1);

eb=exp(-1*bet);
e2b=exp(-2*bet);

if bet[1,1]==0;
s22=1;s23=1/2;s33=1/3;
else;
s22=(1-e2b)./(2*bet);
s23=(0.5-1*eb+0.5*e2b)./(bet.*bet);
s33=(bet-1.5+2.*eb-0.5*e2b)./(bet.*bet.*bet);
endif;


l22=-1.*th1+ba;
l23=th1;
l33=-2*(x).*th1;

 a22=1-(s22.*l22+s23.*l23);
 a23=-1*(s22.*l23+s23.*l33);
 a32=-1*(s23.*l22+s33.*l23);
 a33=1-(s23.*l23+s33.*l33);
 dn=(a22.*a33-a32.*a23);

cf=(t1)./sqrt(dn);

retp(cf);
endp;


  /*
@  debug @
#include cfdfu.prc;
theta=seqa(1,1,10);
c=0;
q1=cfdf1(theta,c,-14.1);
q2=cfdfu(theta,c,-14.1);
format /RDN 15,8;
q1-q2;
*/
