/* Proc to compute characteristic function for DF T(p-1) stat under
   0LS detrending with y0=0  */

proc(1)=cfdf00(theta,c,x);
local th1, bet, ba, t1, eb, e2b, s11, s12,
      s22, s23, s33, l22, l23, l33, a22, a23,
      a32, a33, dn, cf;

th1=sqrt(-1).*theta;
bet=sqrt(c*c-2*x.*th1);
ba=bet-c;
t1=((th1-ba)./2);
t1=exp(t1);

eb=exp(-1*bet);
e2b=exp(-2*bet);

if bet[1,1]==0;
s22=1;
else;
s22=(1-e2b)./(2*bet);
endif;


l22=-1.*th1+ba;

 dn=1-s22.*l22;

cf=(t1)./sqrt(dn);

retp(cf);
endp;


  /*
@  debug @
#include cfdfu.prc;
theta=seqa(1,1,10);
c=0;
q1=cfdf1(theta,c,-14.1);
q2=cfdfu(theta,c,-14.1);
format /RDN 15,8;
q1-q2;
*/
