/*  GE 9 june 92 procedure to estimate deltahat for the pt project.


Input:
        xt    :    x variables (include constant)
        ut    :    residuals estimated from the OLS regression
        nfirst:    starting observation (don't need to take into account
                    the number of lags in BIC as this is automatic)
        nlast :    final observation
        maxlag:    total lags for BIC to search
Output:
        Omega :    the estimated variance covariance matrix

*/

proc(1) = arvcv(xt,ut,nfirst,nlast,maxlag);

local dxa9, nf, nl, bic, nlag, xa, i, xa9,
      amat, res, gtt, psel, omega, sig2, kk,
      a1;

@ xt includes constant @
dxa9=xt.*ut;

@ choose lag length for var using SBIC   @
nf=nfirst+maxlag+1;
nl=nlast;

if maxlag==0;
else;
bic=zeros(maxlag,1);
nlag=1; do until nlag>maxlag;
xa=ones(nl-nf+1,1);
i=1;do until i > nlag;
 xa9=dxa9[nf-i:nl-i,.];
 xa=xa~xa9;
i=i+1; endo;
amat=inv(xa'xa)*xa'dxa9[nf:nl,.];
res=dxa9[nf:nl,.]-xa*amat;
gtt=ln(rows(xa))/(rows(xa));
bic[nlag,1]=ln(det((res'res)/rows(xa)))+2*nlag*gtt;

nlag=nlag+1; endo;
psel=minindc(bic);
endif;

@  create A(1) and Sigma  @
if maxlag==0;
dxa9=dxa9-ones(rows(dxa9),2)*meanc(dxa9);
omega=(dxa9[nf:nl,.]'dxa9[nf:nl,.])/(nl-nf+1);
else;
xa=ones(nl-nf+1,1);
i=1;do until i > psel;
 xa9=dxa9[nf-i:nl-i,.];
 xa=xa~xa9;
i=i+1; endo;
amat=inv(xa'xa)*xa'dxa9[nf:nl,.];@ "amat ";amat;@
res=dxa9[nf:nl,.]-xa*amat;
sig2=(res'res)/(rows(xa)-cols(xa));
kk=cols(xt);
i=1; do until i>psel;
if i==1;a1=amat[2:kk+1,.];
else;
a1=a1+amat[kk*(i-1)+2:kk*i+1,.];
endif;
i=i+1; endo;
a1=eye(kk)-a1;@ "a1  ";a1;@
@"sig2";sig2;@

@ create Omega @
omega=(inv(a1')*sig2*inv(a1')');@omega;@
endif;


retp(omega);
endp;

             /*
/* debug */
output file=test2 reset;
nmc=1000;
a=zeros(nmc,5);
rndseed 1092;
delt=(-0.9)|(-0.5)|0|0.5|(0.9);
j=1; do until j>rows(delt);
i=1; do until i>nmc;
{y,x}=mcg(1,delt[j,1],100,1);
a[i,j]=deltahat(x,y,1,100,1);
i=i+1; endo;
j=j+1; endo;
delt~meanc(a);
output off;*/ /*
rndseed 995;
{y,x}=mcg(1,-0.9,100,1);@y=recserar(y,0,0.4);@
a=deltahat(x,y,4,100,1);
" ";a;        */
