/*----------------------------------------------------------------*/
/* Program to compute ADf test . This is part of itestsr.prc     */
/* modified on october 1998                                      */
/*----------------------------------------------------------------*/

@ ------------------- Unit Root Test Statistics ---------------------------@

@ ADF                    JHS 4/20/90
 computes Dickey-Fuller test statistics using BIC to pick lags
  y = data series, x = deterministic terms (matrix), p = no. of lags of diffs
output is ZDF

@
proc(5)= ADF2(y,fdet,p);
local n, x, nlags, dy, z, yp, ip, zzi, zy,
      b, u, s, ao, a1, nrhohat, what, t, maxlag, nfirst, nl,
        nf, bic, nlag , gtt, psel,seb;
n=rows(y);

if p<0;
maxlag=abs(p);
@  select lag length using BIC lag length selector @
@nfirst=1;
nf=nfirst+maxlag+1;
nl=n;@

bic=zeros(maxlag,1);
nlag=1; do until nlag>maxlag;

if fdet == 1; x=ones(n,1); elseif fdet == 2; x=ones(n,1)~seqa(1,1,n);
   else; x=zeros(n,1); endif;

dy = 0|(y[2:n,1]-y[1:(n-1),1]);
z=y[(1+nlag):(n-1),1]; yp=y[(2+nlag):n,1]-y[(1+nlag):(n-1),1];
if sumc(sumc(x)).ne.0; z=z~x[(2+nlag):n,.]; endif;
ip=0; do until ip>=nlag;
  z=z~dy[(1+nlag-ip):(n-1-ip),1];
ip=ip+1; endo;
zzi=invpd(z'z); zy=z'yp;
b=zzi*zy;
u=yp-z*b; s=(u'u)/(rows(u)-cols(z));

gtt=ln(rows(z))/(rows(z));
bic[nlag,1]=ln(det((u'u)/(rows(z))))+(2+nlag)*gtt;
nlag=nlag+1; endo;
psel=minindc(bic);
else;
psel=p;
endif;

@  do the adf test with psel lags @

if fdet == 1; x=ones(n,1); elseif fdet == 2; x=ones(n,1)~seqa(1,1,n);
   else; x=zeros(n,1); endif;

dy = 0|(y[2:n,1]-y[1:(n-1),1]);
z=y[(1+psel):(n-1),1]; yp=y[(2+psel):n,1]-y[(1+psel):(n-1),1];
if sumc(sumc(x)).ne.0; z=z~x[(2+psel):n,.]; endif;
ip=0; do until ip>=psel;
  z=z~dy[(1+psel-ip):(n-1-ip),1];
ip=ip+1; endo;
zzi=invpd(z'z); zy=z'yp;
b=zzi*zy;
u=yp-z*b; s=(u'u)/(rows(u)-cols(z));
if sumc(sumc(x)).ne.0; ao=sumc(b[1:1+cols(x),1]); else; ao=b[1,1]; endif;
a1=sumc(b)-ao;
nrhohat=rows(u)*(b[1,1])/(1-a1);
what=s/((1-a1)*(1-a1));
t=(b[1,1])/sqrt(s*zzi[1,1]);
@yp[1:10,.]~z[1:10,.];@
seb=sqrt(s*zzi);
retp(nrhohat|t,what,psel,b,seb);
endp;
/*
a=zeros(2,100); i=1; do until i>cols(a);
ut=rndn(101,1);ut=ut[2:101,1]+0.5*ut[1:100,1];
y=recserar(ut,0,0.85);
{a[.,i],junk}=adf(y,1,8);
i=i+1; endo; meanc(a[2,.]'.<-2.86); */

@------------------ Critical Values for selected test stats --------------- @

@ ADFC        JHS 4/20/90
    Exact critical values for ADF
@
proc adfc(x);
local n, typex, y, out9, iy;
n=rows(x); typex=(sumc(sumc(x)).ne.0)*cols(x);
if typex==0;
 let y[5,9] =
  0   0.01  .025  0.05  0.10 0.90 0.95 .975 0.99
 25  -2.66 -2.26 -1.95 -1.60 0.92 1.33 1.70 2.16
 50  -2.62 -2.25 -1.95 -1.61 0.91 1.31 1.66 2.08
100  -2.60 -2.24 -1.95 -1.61 0.90 1.29 1.64 2.03
250  -2.58 -2.23 -1.95 -1.62 0.89 1.29 1.63 2.01
 ;
elseif typex==1;
 let y[3,9] =
  0   0.01  .025  0.05  0.10 0.90 0.95 .975 0.99
 25  -3.75 -3.33 -3.00 -2.63 -0.37  0.00 0.34 0.72
 50  -3.58 -3.22 -2.93 -2.60 -0.40 -0.03 0.29 0.66;
 ;
elseif typex==2;
 let y[3,9] =
  0   0.01  .025  0.05  0.10 0.90 0.95 .975 0.99
 25  -4.38 -3.95 -3.60 -3.24 -1.14 -0.80 -0.50 -0.15
 50  -4.15 -3.80 -3.50 -3.18 -1.19 -0.87 -0.58 -0.24
 ;
else; "Error in X matrix configuration"; endif;

out9=y[rows(y),.];iy=1; do until iy>rows(y);
 if y[iy,1]==n; out9=y[iy,.]; endif;
iy=iy+1; endo;
retp(out9[1,2:cols(out9)]');
endp;




