clearvars
close all
date_string = '20210529';
fpath = ['.\results_theory\',date_string,'\'];
figpath = '.\paper\figs\';

R0 = 3;
% distancing parameters
TR_target = 0.9;  
TR_relax = 1.5;
weeks_R0 = 2;
weeks_dist_fall = 3;
weeks_dist_keep = 8;
weeks_dist_rise = 3;
% vaccination parameters
eff_vacc = 0.95;                            
frac_vacc = 0.75;
weeks_vacc = 12;

%% load results
% no containment
results_no = load([fpath, 'multigroup_L5']);

% distancing only
fname_dist = ['dist_TR_target',num2str(TR_target*10),'_relax',num2str(TR_relax*10),...
    '_fall',num2str(weeks_dist_fall),'W_keep',num2str(weeks_dist_keep),'W_rise',num2str(weeks_dist_rise),'W'];
results_dist = load([fpath,'multigroup_L5_', fname_dist]);

% vaccination only
wbeg_vacc_only = 4; 
fname_vacc = ['vacc_pct',num2str(frac_vacc*100),'_eff',num2str(eff_vacc*100),...
    '_Wbeg', num2str(wbeg_vacc_only),'_', num2str(weeks_vacc),'W'];
results_vacc = load([fpath,'multigroup_L5_', fname_vacc]);

% combined
wbeg_vacc = weeks_R0 + weeks_dist_fall + weeks_dist_keep/2 + 0*weeks_dist_rise + 1;
fname_dist_vacc = ['dist_TR_target',num2str(TR_target*10),'_relax',num2str(TR_relax*10),...
        '_fall',num2str(weeks_dist_fall),'W_keep',num2str(weeks_dist_keep),'W_rise',num2str(weeks_dist_rise),'W',...
        '_vacc_pct',num2str(frac_vacc*100),'_eff',num2str(eff_vacc*100),...
        '_Wbeg', num2str(wbeg_vacc),'_', num2str(weeks_vacc),'W'];
results_dist_vacc = load([fpath,'multigroup_L5_', fname_dist_vacc]);
results_oldfirst = load([fpath,'multigroup_L5_', fname_dist_vacc,'_oldfirst']);

% single group
results_L1 = load([fpath, 'ER']); 

%% plot four seperate figures
Tplot = 500;
% no containment
[h1,hl] = fn_plot_theory_dc(results_no.dcT_avg, Tplot);
set(hl,'visible','off')
figname1 = 'theory_multigroup_L5_dcT_main';

% distancing only
[h2,hl] = fn_plot_theory_dc(results_dist.dcT_avg, Tplot);
set(hl,'visible','off')
figname2 = 'theory_multigroup_L5_dist_dcT_main';

% distancing only
[h3,hl] = fn_plot_theory_dc(results_vacc.dcT_avg, Tplot);
set(hl,'visible','off')
figname3 = 'theory_multigroup_L5_vacc_dcT_main';

% combined
[h4,hl] = fn_plot_theory_dc(results_dist_vacc.dcT_avg, Tplot);
set(hl,'visible','off')
figname4 = 'theory_multigroup_L5_dist_vacc_dcT_main';

saveas(h1,[figpath, figname1,'.png'])
saveas(h2,[figpath, figname2,'.png'])
saveas(h3,[figpath, figname3,'.png'])
saveas(h4,[figpath, figname4,'.png'])

close all

%% plot distancing TR
[h_dist_TR] = fn_plot_theory_TR(results_dist.TR, Tplot);
saveas(h_dist_TR,[figpath, 'theory_dist_TR.png'])

%% single vs. multiple groups, no containment
Tplot = 200;
dcT_plot = [results_no.dcT_avg; results_L1.dcT_avg];
[hcomp,hl] = fn_plot_theory_dc(dcT_plot, Tplot);
hl.String = {'Multigroup','Single group'};
figname = 'theory_cmp_single_multigroup_dcT';
saveas(hcomp,[figpath, figname,'.png'])

%% random vaccination vs. decreasing age order
Tplot = 250;
results_random = results_dist_vacc;
dcT_plot = [results_random.dcT_avg; results_oldfirst.dcT_avg];
[hagg,hl] = fn_plot_theory_dc(dcT_plot, Tplot);
ylim(gca, [0, 0.35])
hl.String = {'Random vaccination','Decreasing age order'};
figname = ['theory_cmp_random_oldfirst_dist_vacc_pct',num2str(frac_vacc*100),'_eff',num2str(eff_vacc*100),...
        '_Wbeg', num2str(wbeg_vacc),'_', num2str(weeks_vacc),'W_dcT'];
saveas(hagg,[figpath, figname,'.png'])

% -----each group-----
dclT_random = diff(results_random.clT,1,2);  % clT is L by T by nsimul
dclT_avg_random = mean(dclT_random,3); % L by T
dclT_oldfirst = diff(results_oldfirst.clT,1,2);  % clT is L by T by nsimul
dclT_avg_oldfirst = mean(dclT_oldfirst,3); % L by T
for j = 1:5
    dcT_plot = [dclT_avg_random(j,:); dclT_avg_oldfirst(j,:)];
    [hj,hl] = fn_plot_theory_dc(dcT_plot, Tplot);
    ylim(gca, [0, 0.35])
    hl.String = {'Random vaccination','Decreasing age order'};
    fnamej = ['theory_cmp_random_oldfirst_dist_vacc_pct',num2str(frac_vacc*100),'_eff',num2str(eff_vacc*100),...
        '_Wbeg', num2str(wbeg_vacc),'_', num2str(weeks_vacc),'W_dcT_L',num2str(j)];
    saveas(hj,[figpath, fnamej,'.png'])
end  

%%
fprintf('No containment: cmax = %.2f, Tend = %.0f days.\n', results_no.results(1)/100, results_no.results(4))
fprintf('Distancing only: cmax = %.2f, Tend = %.0f days.\n', results_dist.results(1)/100, results_dist.results(4))
fprintf('Vaccination only: cmax = %.2f, Tend = %.0f days.\n', results_vacc.results(1)/100, results_vacc.results(4))
fprintf('Combined: cmax = %.2f, Tend = %.0f days.\n', results_dist_vacc.results(1)/100, results_dist_vacc.results(4))
fprintf('No containment, by group: %.2f, %.2f, %.2f, %.2f, %.2f.\n', results_no.resultsL(:,1)./100)
results_random.resultsL
results_oldfirst.resultsL
results_random.results
results_oldfirst.results
% results_no.resultsL
% results_no.results

%% save csv files, no containment
Tplot = 200;
dclT = diff(results_no.clT,1,2);  % clT is L by T by nsimul
for j=1:5
    dclT_plot = permute(dclT(j,1:Tplot-1,:),[3,2,1]).*100;  % clT dimensions: (L,T,nsimul);
    dlmwrite([fpath,'multigroup_L5_dcT_L',num2str(j),'.csv'],dclT_plot,'precision','%4.16f');
end
dcT_plot = results_no.dcT(:,1:Tplot-1).*100;
dlmwrite([fpath,'multigroup_L5_dcT.csv'],dcT_plot,'precision','%4.16f');
