clearvars
close all

date_string = '20210529';
fpath = ['.\results_theory\',date_string,'\'];
figpath = '.\paper\figs\';

Tplot = 300;
% distancing parameters
TR_target = 0.9;  
TR_relax = 1.5;
weeks_R0 = 2;
weeks_dist_fall = 3;
weeks_dist_keep = 8;
weeks_dist_rise = 3;
% vaccination parameters
frac_vacc = 0.75;
weeks_vacc = 12;
eff_vacc = 0.95;
wbeg_vacc_E = weeks_R0 + weeks_dist_fall + weeks_dist_keep/2 + 0*weeks_dist_rise + 1;
wbeg_vacc_L = weeks_R0 + weeks_dist_fall + weeks_dist_keep + 0*weeks_dist_rise + 1;

fname = ['dist_TR_target',num2str(TR_target*10),'_relax',num2str(TR_relax*10),...
        '_fall',num2str(weeks_dist_fall),'W_keep',num2str(weeks_dist_keep),'W_rise',num2str(weeks_dist_rise),'W',...
        '_vacc_pct',num2str(frac_vacc*100),'_eff',num2str(eff_vacc*100),...
        '_Wbeg', num2str(wbeg_vacc_E),'_', num2str(weeks_vacc),'W'];
results_E = load([fpath, 'multigroup_L5_',fname]);

fname = ['dist_TR_target',num2str(TR_target*10),'_relax',num2str(TR_relax*10),...
        '_fall',num2str(weeks_dist_fall),'W_keep',num2str(weeks_dist_keep),'W_rise',num2str(weeks_dist_rise),'W',...
        '_vacc_pct',num2str(frac_vacc*100),'_eff',num2str(eff_vacc*100),...
        '_Wbeg', num2str(wbeg_vacc_L),'_', num2str(weeks_vacc),'W'];
results_L = load([fpath, 'multigroup_L5_',fname]);

%%
dcT_plot = [results_E.dcT_avg; results_L.dcT_avg];
[h1,hl] = fn_plot_theory_dc(dcT_plot, Tplot);
hl.String = {'Vaccination starts at Week 10','Vaccination starts at Week 13'};

fprintf('wbeg_E: cmax = %.2f, Tend = %.0f days.\n', results_E.results(1)/100, results_E.results(4))
fprintf('wbeg_L: cmax = %.2f, Tend = %.0f days.\n', results_L.results(1)/100, results_L.results(4))

%%
figname = ['theory_cmp_vacc_wbeg_dist_pct',num2str(frac_vacc*100),'_eff',num2str(eff_vacc*100),...
    '_',num2str(weeks_vacc),'W','_dcT'];
saveas(h1,[figpath, figname,'.png'])
