library(ggplot2)
library(magrittr)
library(tidyr)
library(dplyr)
library(ggfan)
library(matrixStats)
library(latex2exp)
library(here)

date_string = "20210618"
MF_window = 2 # two or three weeks
MF_ini = 5
fpath = paste0("results_empirical/",date_string,"_MF",MF_window,"W_guess", MF_ini, "_N50000_par")
figpath = "paper/figs"

country_list = c("Austria","France","Germany","Italy","Spain","UK", "US")
for (country in country_list) {
  intervals = seq(0.1,0.8,0.05)
  quants <- c(0.1, 0.25, 0.5, 0.75, 0.9)
  qnames <- c("10th percentile", "25th percentile","50th percentile","75th percentile","90th percentile")
  
  fname = paste(country, "ER_dcT_real.csv", sep = "_")
  dcT_data_real <- read.csv(here(fpath, fname), header=FALSE)
  dcT_real <- as.numeric(dcT_data_real$V1)
  
  fname = paste(country, "ER_dcT_cal.csv", sep = "_")
  dcT_data_sim <- read.csv(here(fpath, fname), header=FALSE)
  dcT_sim <- as.matrix(dcT_data_sim)
  
  fname = paste(country, "ER_date.csv", sep = "_")
  date_beg <- read.csv(here(fpath, fname), header=FALSE)
  
  tmin <- as.Date(date_beg[1,1],"%d-%b-%Y")
  T = dim(dcT_sim)[2]
  tmax <- tmin + T-1
  date = as.Date(tmin) + 1:T
  break.vec <- seq(from = tmin, to = tmax, by = "3 weeks")
  
  dcT_sim_long <- data.frame(x=date, t(dcT_sim)) %>% gather(key=sim, value=y, -x)
  
  dcT_sim_q <- colQuantiles(dcT_sim, probs=quants)
  dcT_sim_q_df <- as.data.frame(dcT_sim_q)
  names(dcT_sim_q_df) <- qnames
  dcT_sim_q_df <- cbind(dcT_sim_q_df,date)
  dcT_sim_q_df_long <- gather(dcT_sim_q_df,key=Percentile, value=value, -date)
  
  p <- ggplot(dcT_sim_long, aes(x=x,y=y)) +
    geom_fan(stat = "interval", intervals=intervals) +
    geom_line(data=dcT_sim_q_df_long, aes(x=date,y=value, group=Percentile, linetype=Percentile, 
                                                  color=Percentile, size=Percentile)) +
    
    geom_line(data=data.frame(x=date,y=dcT_real), aes(x=x, y=y, color="Realized data", linetype="Realized data", 
                                                      size="Realized data")) +
    
    scale_linetype_manual(values = c(3,2,1,4,5,1)) + 
    scale_color_manual(values = c("grey30","grey30","royalblue4","grey30","grey30","lightcoral")) +
    scale_size_manual(values = c(0.5,0.5,1,0.5,0.5,1.2)) +
    scale_fill_gradient(low="steelblue", high="lightcyan") +
    guides(size="none", fill="none", linetype = guide_legend(nrow=2, byrow=TRUE)) +

    xlab("2020-2021") + 
    ylab(expression(paste("Proportion daily new cases ( ", Delta, c[t], ", per cent)")))+
    scale_x_date(expand = c(0, 0), date_labels = "%b %d", breaks = break.vec, limits=c(tmin,tmax)) +
    scale_y_continuous(expand = c(0, 0), breaks=scales::extended_breaks(10)) + 
    theme_bw() +
    theme(panel.border = element_blank(), panel.grid.major = element_blank(),
          panel.grid.minor = element_blank(), axis.line = element_line(),
          legend.position="bottom",
          aspect.ratio=4/6,
          axis.text=element_text(color="black"),
          axis.text.x=element_text(angle=90, vjust=0.5, hjust=0.5),
          axis.title.y=element_text(hjust=1, size=12),
          axis.title.x=element_text(size=10, hjust=0.96),
          legend.title=element_blank(),
          legend.text=element_text(size=10))
  print(p)
  
  figname = paste0(country, "_ER_N50000_guess", MF_ini,"_",MF_window,"W_dcT.png")
  ggsave(here(figpath, figname), dpi=300, width = 5, height = 4, unit="in")
}