library(ggplot2)
library(magrittr)
library(tidyr)
library(dplyr)
library(ggfan)
library(matrixStats)
library(latex2exp)
library(ggnewscale)
library(here)

fpath = "results_empirical/20210618_counterfactual_roll2W_MF5"
figpath = "paper/figs"

country = "Germany"
# country = "UK"
shift_week = 1
intervals = seq(0.1, 0.8, 0.1)
quants <- c(0.1, 0.25, 0.5, 0.75, 0.9)
qnames <- c("10th","25th","50th","75th","90th")
if (country=="Germany") {
  color_shift_low = "#e31a1c"
  color_shift_high = "#fcae91"
} else if (country=="UK") {
  color_shift_low = "#fa8607"
  color_shift_high = "#ffe469"
}

for (j in 1:2) {
  if (j==1){ 
    vstring = "cT"
    ylabel = TeX('Proportion infected ($c_t$, per cent)')}
  else {
    vstring = "iT"
    ylabel = TeX('Proportion active cases ($i_t$, per cent)')
  }
  
  fname_cal_yT <- paste0(country, "_ER_shift0W_", vstring, ".csv")
  yT_cal <- as.matrix(read.csv(here(fpath, fname_cal_yT), header=FALSE))
  fname_shift_yT <- paste0(country, "_ER_shift", shift_week, "W_", vstring, ".csv")
  yT_shift <- as.matrix(read.csv(here(fpath, fname_shift_yT), header=FALSE))
  
  T <- dim(yT_cal)[2]
  tmax <- as.Date("2020-06-28")
  tmin <- tmax - T + 1
  break.vec <- c(seq(from = tmin, to = tmax, by = "1 week"))
  days <- as.Date(tmin) + 0:(T-1)
  
  yT_long_cal <- data.frame(x=days, t(yT_cal)) %>% gather(key=sim, value=y, -x)
  yT_q_cal <- as.data.frame(colQuantiles(yT_cal, probs=quants))
  names(yT_q_cal) <- qnames
  yT_q_cal <- cbind(yT_q_cal, days)
  yT_q_long_cal <- gather(yT_q_cal, key=Percentile, value=value, -days)
  
  yT_long_shift <- data.frame(x=days, t(yT_shift)) %>% gather(key=sim, value=y, -x)
  yT_q_shift <- as.data.frame(colQuantiles(yT_shift, probs=quants))
  names(yT_q_shift) <- qnames
  yT_q_shift <- cbind(yT_q_shift, days)
  yT_q_long_shift <- gather(yT_q_shift, key=Percentile, value=value, -days)
  
  
  p <- ggplot(yT_long_cal, aes(x=x,y=y)) +
    geom_fan(stat = "interval", intervals=intervals) +
    geom_line(data=yT_q_long_cal, aes(x=days, y=value, group=Percentile, linetype=Percentile, 
                                      color=Percentile, size=Percentile)) +
    scale_linetype_manual(values=c(3,2,1,4,5)) + 
    scale_color_manual(values=c("grey30","grey30","royalblue4","grey30","grey30")) +
    scale_size_manual(values = c(0.5,0.5,1,0.5,0.5)) +
    scale_fill_gradient(low="steelblue", high="lightcyan", guide="none") +
    
    new_scale_color() +
    geom_line(data=yT_q_long_shift, aes(x=days, y=value, group=Percentile, linetype=Percentile,
                                        color=Percentile, size=Percentile)) +
    scale_color_manual(values=c("grey30","grey30","grey30","grey30","grey30")) +
    
    new_scale_fill() +
    geom_fan(data=yT_long_shift, aes(x=x,y=y), stat = "interval", intervals=intervals, alpha=0.2) +
    scale_fill_gradient(low=color_shift_low, high=color_shift_high, guide="none") +
    xlab("2020") +
    ylab(ylabel) +
    scale_x_date(expand = c(0, 0), date_labels = "%b %d", breaks = break.vec, limits=c(tmin,tmax)) +
    scale_y_continuous(expand = c(0, 0), breaks=scales::extended_breaks(10)) +
    theme_bw() +
    theme(panel.border = element_blank(), panel.grid.major = element_blank(),
          panel.grid.minor = element_blank(), axis.line = element_line(),
          legend.position="bottom",
          aspect.ratio=4/6,
          axis.text=element_text(colour="black"),
          axis.text.x=element_text(angle = 90, vjust = 0.5, hjust=0.5),
          axis.title.x=element_text(size=10, hjust=0.96),
          axis.title.y=element_text(vjust=2.5),
          axis.title=element_text(size=12),
          legend.title=element_blank(),
          legend.text=element_text(size=10))
  print(p)
  
  figname = paste0(country, "_ER_shift", shift_week, "W_", vstring, ".png")
  ggsave(here(figpath, figname), dpi=300, width = 5, height = 4, unit="in")
}
