clearvars
est_ymd = 20210618;

country_list = {'Austria','France','Germany','Italy','Spain','UK','US'};
figpath = '.\paper\figs\';

for ci = 1:length(country_list)
    close all
    country = char(country_list(ci));

    ymax = 3;
    roll_window = 14;
    gamma = 1/14;

    date_string = num2str(est_ymd);
    path_read = ['.\data_raw\',date_string,'\'];
    path_write = ['.\results_empirical\',date_string,'\'];
    if ~exist(path_write,'dir')
        mkdir(path_write)
    end

    MF_set = [3,5];
    TR_set = [];
    beg_idx_set = zeros(1,length(MF_set));
    for j = 1:length(MF_set)
        MF = MF_set(j);
        results_est = fn_estimation_empirical ...
            (country, roll_window, est_ymd, MF, path_read);
        betahat_rollT = results_est.betahat_rollT;
        date_beg_betahat = results_est.date_beg_betahat;
        cT_MA = results_est.cT_MA;

        TR = betahat_rollT./gamma;
        beg_idx_set(j) = find(TR<3, 1, 'first');
        TR_set = [TR_set,TR];    
    end

    tmax = datetime(est_ymd,'ConvertFrom','yyyymmdd');
    if ~all(beg_idx_set==beg_idx_set(1))
        TR_less3_set = TR_set(max(beg_idx_set):end,:);
        tmin = tmax - size(TR_less3_set,1)+1;
    else
        TR_less3_set = TR_set(beg_idx_set(1):end,:);
        tmin = tmax - size(TR_less3_set,1)+1;
    end
    cT_plot = cT_MA(end-length(TR_less3_set)+1:end).*100;
    
    %% plot dc   
    dcT_MA = diff(cT_MA);
    if min(dcT_MA)<0
        error('Negative new cases!')
    end
    dcT_plot = dcT_MA.*100000;
    if strcmp(country,'US')
        days_drop = days(tmax - datetime(2021,3,10));
        tmax = datetime(2021,3,10);        
        dcT_plot(end - days_drop+1: end) = [];
    end
    h_dc = fn_plot_empirical_dc(tmax, dcT_plot);

    %% plot TR with different values of MF
    if ~strcmp(country,'US')
        linS = {'-','--',':'};
        linW = [2,2,1.5];
        colormap = get(groot,'defaultAxesColorOrder');
        mycolor = [colormap(1,:); colormap(2,:); colormap(3,:)];
        for j = 1:length(MF_set)
            MF = MF_set(j);
            h_TR = figure(2);
            plot(tmin:tmax, TR_less3_set(:,j), 'LineStyle', linS{j},'Linewidth',linW(j),'Color', mycolor(j,:), ...
                'DisplayName',['MF = ',num2str(MF)])
            hold on;
        end
        plot(tmin:tmax, ones(length(tmin:tmax),1),'LineStyle','--','Linewidth',1.5,...
            'HandleVisibility','off','Color', ones(1,3)*150/255);
        hold off;
        legend boxoff 
        legend('Orientation','horizontal','Location','NorthEast')
        ylabel('${\hat{\beta}_t}/{\gamma} \ $','Interpreter','Latex','Color','black')
        box('off')
        set(gca,'TickDir','out'); 
        ax = gca;
        xtickangle(ax,90)
        xlim([tmin,tmax])
        xticks(tmin:21:tmax)
        ax.LineWidth = 1.2;
        xtickformat('MMM dd')
        ylim([0,ymax])
        yticks(0:0.5:ymax)
        set(gca,'fontsize',12)
        pbaspect([1.8 1 1])  
        set(gcf,'PaperUnits','inches','PaperPosition',[0 0 4.3750*2 4.3750])
        set(gcf,'Position',[1441 919 420*2 420])
        
        figname_TR = [country,'_TR_', num2str(roll_window/7),'W_cmp_MF'];
        saveas(h_TR,[figpath, figname_TR,'.png'])
    end
    
    figname_dc = [country,'_dcT'];
    saveas(h_dc,[figpath, figname_dc,'.png'])

end