clearvars
close all
% evalc('feature(''numcores'')')
% parpool('local',6)
t0 = tic();
date_string = '20210618';
country = 'Germany';
% country = 'UK';
shift_week = 2;  % =0,1,2: shift 0,1,or 2 weeks
date_end = datetime(2020,06,28); % stop before TR returns above 1

N = 50000;
nsimul = 1000;
roll_window = 14;
ini_days = 7;
MA_window = 7;
gamma = 1/14;
MF = 5;

path_read = [pwd,'/data_raw/',date_string,'/'];
path_write = [pwd,'/results_empirical/',date_string,'_counterfactual_roll',...
    num2str(roll_window/7),'W_MF',num2str(MF),'/'];

if ~exist(path_write,'dir')
    mkdir(path_write)
end

%% load realized data
fname_read = [path_read, country,'.csv'];
data_raw = readtable(fname_read);
data_raw.Date = datetime(data_raw.Date,'InputFormat','ddMMMyyyy');

if strcmp(country,'Germany') % delay 
   date_end_est = date_end;
elseif strcmp(country,'UK') % advance
   date_end_est = date_end + shift_week*7;
end
data = data_raw;
data(data.Date > date_end_est, :) = [];

CT = data.C;
pop = data.Pop(1);
IT = fn_est_IT(CT,gamma);

out_MA = fn_MA([CT,IT],MA_window);
CT_MA = out_MA(:,1);
IT_MA = out_MA(:,2);
cT_MA = CT_MA./pop;
iT_MA = IT_MA./pop;

dCT_MA = diff(CT_MA);
dcT_MAp = dCT_MA./pop.*100000;  % daily new cases per 100k
idx_cross1 = find(dcT_MAp>=1,1,'first'); 
idx_beg = idx_cross1 + (MA_window-1) + 1;
date_beg_betahat = data.Date(idx_beg+1);

idx_beg_MA = idx_beg - MA_window + 1;                                        
cT_MA_use = cT_MA(max(idx_beg_MA-roll_window,0)+1:end);
iT_MA_use = iT_MA(max(idx_beg_MA-roll_window,0)+1:end);
T = length(cT_MA_use);
date_beg_MA_use = data.Date(end - length(cT_MA_use) + 1);

%%
betahat_rollT = fn_est_beta(cT_MA_use,iT_MA_use,roll_window,MF);
beta_beg_idx = find(betahat_rollT./gamma<3,1,'first'); 
betaT_less3 = betahat_rollT(beta_beg_idx:end);
betaT = [betaT_less3(1).*ones(ini_days,1); betaT_less3];

if strcmp(country,'Germany') % delay 
    betaT_shift = [betaT(1).*ones(shift_week*7,1); betaT(1:end-shift_week*7)];
    betaT_true = betaT;  % no shift
elseif strcmp(country,'UK') % advance
    betaT_shift = betaT(shift_week*7+1:end);
    betaT_true = betaT(1:end-shift_week*7);
end

date_beg_betaT_less3 = date_beg_betahat + beta_beg_idx - 1;
date_beg_sim = date_beg_betaT_less3 - ini_days;

 x_ini = []; y_ini = [];
 myStream = RandStream.create('Threefry');
[parm, results_sim] = fn_sim_empirical_cont_par(myStream, betaT_shift, N, nsimul, x_ini, y_ini);

fname_write = [path_write, country,'_ER_shift',num2str(shift_week),'W_N',num2str(N),...
    '_nsimul',num2str(nsimul)];
save(fname_write,'parm','results_sim');

elapsedMin = toc(t0)/60
delete(gcp('nocreate'))
