function [h, hl] = fn_plot_theory_dc(dc, Tplot)

k = size(dc,1);
h = figure;
linS = {'-','--','-.'};
colormap = get(groot,'defaultAxesColorOrder');
for j = 1:k
    plot(2:Tplot, dc(j,1:Tplot-1)*100,'Linewidth',2,'Linestyle',linS{j},...
        'Color',colormap(j,:),'DisplayName',['dc',num2str(j)]);
    hold on;
end
hold off;
hl = legend('Location','NorthEast');
hl.FontSize = 12;
legend boxoff 
ylabel('Proportion new cases (\Delta c_t, per cent)', 'Color','black')
xlabel('Days since the outbreak','Color','black')
box('off')
set(gca,'TickDir','out','fontsize',12,'LineWidth',1.2); 
xticks(linspace(0,Tplot,11))
xtickangle(90)

end