function h = fn_plot_empirical_TR_Re(tmax, TR, Re)
% plot TR together with Re
h = figure;
tmin = tmax - length(TR) + 1;
plot(tmin:tmax,TR,'Linewidth',1.5)
hold on;
plot(tmin:tmax,Re,'--','Linewidth',1.5)
hold on;
plot(tmin:tmax,ones(1,length(tmin:tmax)),'--','Color',ones(1,3)*150/255,'Linewidth',1.5) 
hold off;
hl = legend('${\hat{\beta}_t}/{\gamma}$','${\hat{\mathcal{R}}_{et}}$');
set(hl, 'Fontsize',12,'Interpreter','Latex')
legend boxoff
box('off')
ax = gca;
ax.LineWidth = 1.2;
ax.FontSize = 12;
ax.TickDir = 'out';
xlim([tmin,tmax])
xticks(tmin:21:tmax)
xtickformat('MMM dd')
xtickangle(90)
ylim([0,3])

end