clearvars 
close all
date_string = '20210807';
n_states = 49;
roll_window = 14;
MF = 3;
gamma = 1/14;

path_read = '.\data_temp\';
fname_read = [path_read,'cases_states_',num2str(date_string)];
load(fname_read);
figpath = '.\paper\figs\';

dcmtx_MA = diff(cmtx_MA);
dcmtx_MAp = dcmtx_MA.*100000;  % daily new cases per 100k

tmax = datetime(date_string,'InputFormat','yyyyMMdd');

idx_cross1 = zeros(1,n_states);
for j=1:n_states
    disp(j);
    idx_cross1(j) = find(dcmtx_MAp(:,j)>=1,1,'first'); 
    idx_beg_MA =  idx_cross1(j) + 1;
    cmtx_MA_use = cmtx_MA(idx_beg_MA-roll_window+1 :end, j);
    imtx_MA_use = imtx_MA(idx_beg_MA-roll_window+1 :end, j);
    
    beta = fn_est_beta_states(cmtx_MA_use, imtx_MA_use, roll_window, MF);
    Re = (1 - MF.*cmtx_MA_use(roll_window+1:end)).*beta./gamma;
    idx_less3 = find(Re<3,1,'first');
    Tplot = size(cmtx_MA_use,1)-roll_window - idx_less3+1;
    tmin = tmax - Tplot + 1;
    
    % ----- plot Re ------
    h1 = figure(1);
    plot(tmin:tmax, Re(idx_less3:end),'Linewidth',2)
    hold on;
    plot(tmin:tmax, ones(length(tmin:tmax),1),'LineStyle','--','Linewidth',1.5,'HandleVisibility','off','Color', ones(1,3)*150/255);
    hold off;
    ylabel('${\hat{\mathcal{R}}_{et}}$','Interpreter','Latex','Color','black')
    box('off')
    set(gca,'TickDir','out'); 
    ax = gca;
    xlim([tmin,tmax])
    xticks(tmin:21:tmax)
    xtickformat('MMM dd')
    xtickangle(90)
    ax.FontSize = 12;
    ax.LineWidth = 1.2;
    ymax = 3;
    ylim([0,ymax])
    yticks(0:0.5:ymax)
    pbaspect([1.8 1 1])  
    set(gcf,'PaperUnits','inches','PaperPosition',[0 0 4.3750*2 4.3750])
    set(gcf,'Position',[1441 919 420*2 420])
    
    figname = ['US-Re-', char(ST_string(j)), '-', num2str(roll_window/7),'W'];
    saveas(h1,[figpath, figname,'.png'])
end
